@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin

import com.pulumi.aws.cloudformation.kotlin.outputs.StackSetAutoDeployment
import com.pulumi.aws.cloudformation.kotlin.outputs.StackSetManagedExecution
import com.pulumi.aws.cloudformation.kotlin.outputs.StackSetOperationPreferences
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.cloudformation.kotlin.outputs.StackSetAutoDeployment.Companion.toKotlin as stackSetAutoDeploymentToKotlin
import com.pulumi.aws.cloudformation.kotlin.outputs.StackSetManagedExecution.Companion.toKotlin as stackSetManagedExecutionToKotlin
import com.pulumi.aws.cloudformation.kotlin.outputs.StackSetOperationPreferences.Companion.toKotlin as stackSetOperationPreferencesToKotlin

/**
 * Builder for [StackSet].
 */
@PulumiTagMarker
public class StackSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StackSetArgs = StackSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StackSetArgsBuilder.() -> Unit) {
        val builder = StackSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StackSet {
        val builtJavaResource = com.pulumi.aws.cloudformation.StackSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StackSet(builtJavaResource)
    }
}

/**
 * Manages a CloudFormation StackSet. StackSets allow CloudFormation templates to be easily deployed across multiple accounts and regions via StackSet Instances (`aws.cloudformation.StackSetInstance` resource). Additional information about StackSets can be found in the [AWS CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/what-is-cfnstacksets.html).
 * > **NOTE:** All template parameters, including those with a `Default`, must be configured or ignored with the `lifecycle` configuration block `ignore_changes` argument.
 * > **NOTE:** All `NoEcho` template parameters must be ignored with the `lifecycle` configuration block `ignore_changes` argument.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cloudformation.StackSet;
 * import com.pulumi.aws.cloudformation.StackSetArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var aWSCloudFormationStackSetAdministrationRoleAssumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("cloudformation.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .build())
 *             .build());
 *         var aWSCloudFormationStackSetAdministrationRole = new Role("aWSCloudFormationStackSetAdministrationRole", RoleArgs.builder()
 *             .assumeRolePolicy(aWSCloudFormationStackSetAdministrationRoleAssumeRolePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var example = new StackSet("example", StackSetArgs.builder()
 *             .administrationRoleArn(aWSCloudFormationStackSetAdministrationRole.arn())
 *             .parameters(Map.of("VPCCidr", "10.0.0.0/16"))
 *             .templateBody(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Parameters", jsonObject(
 *                         jsonProperty("VPCCidr", jsonObject(
 *                             jsonProperty("Type", "String"),
 *                             jsonProperty("Default", "10.0.0.0/16"),
 *                             jsonProperty("Description", "Enter the CIDR block for the VPC. Default is 10.0.0.0/16.")
 *                         ))
 *                     )),
 *                     jsonProperty("Resources", jsonObject(
 *                         jsonProperty("myVpc", jsonObject(
 *                             jsonProperty("Type", "AWS::EC2::VPC"),
 *                             jsonProperty("Properties", jsonObject(
 *                                 jsonProperty("CidrBlock", jsonObject(
 *                                     jsonProperty("Ref", "VPCCidr")
 *                                 )),
 *                                 jsonProperty("Tags", jsonArray(jsonObject(
 *                                     jsonProperty("Key", "Name"),
 *                                     jsonProperty("Value", "Primary_CF_VPC")
 *                                 )))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *         final var aWSCloudFormationStackSetAdministrationRoleExecutionPolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .effect("Allow")
 *                 .resources(example.executionRoleName().applyValue(executionRoleName -> String.format("arn:aws:iam::*:role/%s", executionRoleName)))
 *                 .build())
 *             .build());
 *         var aWSCloudFormationStackSetAdministrationRoleExecutionPolicyRolePolicy = new RolePolicy("aWSCloudFormationStackSetAdministrationRoleExecutionPolicyRolePolicy", RolePolicyArgs.builder()
 *             .policy(aWSCloudFormationStackSetAdministrationRoleExecutionPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(aWSCloudFormationStackSetAdministrationRoleExecutionPolicyPolicyDocument -> aWSCloudFormationStackSetAdministrationRoleExecutionPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .role(aWSCloudFormationStackSetAdministrationRole.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Import CloudFormation StackSets when acting a delegated administrator in a member account using the `name` and `call_as` values separated by a comma (`,`). For example:
 * Using `pulumi import`, import CloudFormation StackSets using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudformation/stackSet:StackSet example example
 * ```
 *  Using `pulumi import`, import CloudFormation StackSets when acting a delegated administrator in a member account using the `name` and `call_as` values separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:cloudformation/stackSet:StackSet example example,DELEGATED_ADMIN
 * ```
 *
 */
public class StackSet internal constructor(
    override val javaResource: com.pulumi.aws.cloudformation.StackSet,
) : KotlinCustomResource(javaResource, StackSetMapper) {
    /**
     * Amazon Resource Number (ARN) of the IAM Role in the administrator account. This must be defined when using the `SELF_MANAGED` permission model.
     */
    public val administrationRoleArn: Output<String>?
        get() = javaResource.administrationRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the StackSet.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block containing the auto-deployment model for your StackSet. This can only be defined when using the `SERVICE_MANAGED` permission model.
     */
    public val autoDeployment: Output<StackSetAutoDeployment>?
        get() = javaResource.autoDeployment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> stackSetAutoDeploymentToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
     */
    public val callAs: Output<String>?
        get() = javaResource.callAs().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A list of capabilities. Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_AUTO_EXPAND`.
     */
    public val capabilities: Output<List<String>>?
        get() = javaResource.capabilities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Description of the StackSet.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the IAM Role in all target accounts for StackSet operations. Defaults to `AWSCloudFormationStackSetExecutionRole` when using the `SELF_MANAGED` permission model. This should not be defined when using the `SERVICE_MANAGED` permission model.
     */
    public val executionRoleName: Output<String>
        get() = javaResource.executionRoleName().applyValue({ args0 -> args0 })

    /**
     * Configuration block to allow StackSets to perform non-conflicting operations concurrently and queues conflicting operations.
     */
    public val managedExecution: Output<StackSetManagedExecution>?
        get() = javaResource.managedExecution().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> stackSetManagedExecutionToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Name of the StackSet. The name must be unique in the region where you create your StackSet. The name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an alphabetic character and cannot be longer than 128 characters.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Preferences for how AWS CloudFormation performs a stack set update.
     */
    public val operationPreferences: Output<StackSetOperationPreferences>?
        get() = javaResource.operationPreferences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> stackSetOperationPreferencesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Key-value map of input parameters for the StackSet template. All template parameters, including those with a `Default`, must be configured or ignored with `lifecycle` configuration block `ignore_changes` argument. All `NoEcho` template parameters must be ignored with the `lifecycle` configuration block `ignore_changes` argument.
     */
    public val parameters: Output<Map<String, String>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Describes how the IAM roles required for your StackSet are created. Valid values: `SELF_MANAGED` (default), `SERVICE_MANAGED`.
     */
    public val permissionModel: Output<String>?
        get() = javaResource.permissionModel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique identifier of the StackSet.
     */
    public val stackSetId: Output<String>
        get() = javaResource.stackSetId().applyValue({ args0 -> args0 })

    /**
     * Key-value map of tags to associate with this StackSet and the Stacks created from it. AWS CloudFormation also propagates these tags to supported resources that are created in the Stacks. A maximum number of 50 tags can be specified. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * String containing the CloudFormation template body. Maximum size: 51,200 bytes. Conflicts with `template_url`.
     */
    public val templateBody: Output<String>
        get() = javaResource.templateBody().applyValue({ args0 -> args0 })

    /**
     * String containing the location of a file containing the CloudFormation template body. The URL must point to a template that is located in an Amazon S3 bucket. Maximum location file size: 460,800 bytes. Conflicts with `template_body`.
     */
    public val templateUrl: Output<String>?
        get() = javaResource.templateUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object StackSetMapper : ResourceMapper<StackSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudformation.StackSet::class == javaResource::class

    override fun map(javaResource: Resource): StackSet = StackSet(
        javaResource as
            com.pulumi.aws.cloudformation.StackSet,
    )
}

/**
 * @see [StackSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StackSet].
 */
public suspend fun stackSet(name: String, block: suspend StackSetResourceBuilder.() -> Unit):
    StackSet {
    val builder = StackSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StackSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun stackSet(name: String): StackSet {
    val builder = StackSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
