@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin

import com.pulumi.aws.cloudformation.StackSetArgs.builder
import com.pulumi.aws.cloudformation.kotlin.inputs.StackSetAutoDeploymentArgs
import com.pulumi.aws.cloudformation.kotlin.inputs.StackSetAutoDeploymentArgsBuilder
import com.pulumi.aws.cloudformation.kotlin.inputs.StackSetManagedExecutionArgs
import com.pulumi.aws.cloudformation.kotlin.inputs.StackSetManagedExecutionArgsBuilder
import com.pulumi.aws.cloudformation.kotlin.inputs.StackSetOperationPreferencesArgs
import com.pulumi.aws.cloudformation.kotlin.inputs.StackSetOperationPreferencesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a CloudFormation StackSet. StackSets allow CloudFormation templates to be easily deployed across multiple accounts and regions via StackSet Instances (`aws.cloudformation.StackSetInstance` resource). Additional information about StackSets can be found in the [AWS CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/what-is-cfnstacksets.html).
 * > **NOTE:** All template parameters, including those with a `Default`, must be configured or ignored with the `lifecycle` configuration block `ignore_changes` argument.
 * > **NOTE:** All `NoEcho` template parameters must be ignored with the `lifecycle` configuration block `ignore_changes` argument.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cloudformation.StackSet;
 * import com.pulumi.aws.cloudformation.StackSetArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var aWSCloudFormationStackSetAdministrationRoleAssumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("cloudformation.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .build())
 *             .build());
 *         var aWSCloudFormationStackSetAdministrationRole = new Role("aWSCloudFormationStackSetAdministrationRole", RoleArgs.builder()
 *             .assumeRolePolicy(aWSCloudFormationStackSetAdministrationRoleAssumeRolePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var example = new StackSet("example", StackSetArgs.builder()
 *             .administrationRoleArn(aWSCloudFormationStackSetAdministrationRole.arn())
 *             .parameters(Map.of("VPCCidr", "10.0.0.0/16"))
 *             .templateBody(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Parameters", jsonObject(
 *                         jsonProperty("VPCCidr", jsonObject(
 *                             jsonProperty("Type", "String"),
 *                             jsonProperty("Default", "10.0.0.0/16"),
 *                             jsonProperty("Description", "Enter the CIDR block for the VPC. Default is 10.0.0.0/16.")
 *                         ))
 *                     )),
 *                     jsonProperty("Resources", jsonObject(
 *                         jsonProperty("myVpc", jsonObject(
 *                             jsonProperty("Type", "AWS::EC2::VPC"),
 *                             jsonProperty("Properties", jsonObject(
 *                                 jsonProperty("CidrBlock", jsonObject(
 *                                     jsonProperty("Ref", "VPCCidr")
 *                                 )),
 *                                 jsonProperty("Tags", jsonArray(jsonObject(
 *                                     jsonProperty("Key", "Name"),
 *                                     jsonProperty("Value", "Primary_CF_VPC")
 *                                 )))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *         final var aWSCloudFormationStackSetAdministrationRoleExecutionPolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .effect("Allow")
 *                 .resources(example.executionRoleName().applyValue(executionRoleName -> String.format("arn:aws:iam::*:role/%s", executionRoleName)))
 *                 .build())
 *             .build());
 *         var aWSCloudFormationStackSetAdministrationRoleExecutionPolicyRolePolicy = new RolePolicy("aWSCloudFormationStackSetAdministrationRoleExecutionPolicyRolePolicy", RolePolicyArgs.builder()
 *             .policy(aWSCloudFormationStackSetAdministrationRoleExecutionPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(aWSCloudFormationStackSetAdministrationRoleExecutionPolicyPolicyDocument -> aWSCloudFormationStackSetAdministrationRoleExecutionPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .role(aWSCloudFormationStackSetAdministrationRole.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Import CloudFormation StackSets when acting a delegated administrator in a member account using the `name` and `call_as` values separated by a comma (`,`). For example:
 * Using `pulumi import`, import CloudFormation StackSets using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudformation/stackSet:StackSet example example
 * ```
 *  Using `pulumi import`, import CloudFormation StackSets when acting a delegated administrator in a member account using the `name` and `call_as` values separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:cloudformation/stackSet:StackSet example example,DELEGATED_ADMIN
 * ```
 * @property administrationRoleArn Amazon Resource Number (ARN) of the IAM Role in the administrator account. This must be defined when using the `SELF_MANAGED` permission model.
 * @property autoDeployment Configuration block containing the auto-deployment model for your StackSet. This can only be defined when using the `SERVICE_MANAGED` permission model.
 * @property callAs Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
 * @property capabilities A list of capabilities. Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_AUTO_EXPAND`.
 * @property description Description of the StackSet.
 * @property executionRoleName Name of the IAM Role in all target accounts for StackSet operations. Defaults to `AWSCloudFormationStackSetExecutionRole` when using the `SELF_MANAGED` permission model. This should not be defined when using the `SERVICE_MANAGED` permission model.
 * @property managedExecution Configuration block to allow StackSets to perform non-conflicting operations concurrently and queues conflicting operations.
 * @property name Name of the StackSet. The name must be unique in the region where you create your StackSet. The name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an alphabetic character and cannot be longer than 128 characters.
 * @property operationPreferences Preferences for how AWS CloudFormation performs a stack set update.
 * @property parameters Key-value map of input parameters for the StackSet template. All template parameters, including those with a `Default`, must be configured or ignored with `lifecycle` configuration block `ignore_changes` argument. All `NoEcho` template parameters must be ignored with the `lifecycle` configuration block `ignore_changes` argument.
 * @property permissionModel Describes how the IAM roles required for your StackSet are created. Valid values: `SELF_MANAGED` (default), `SERVICE_MANAGED`.
 * @property tags Key-value map of tags to associate with this StackSet and the Stacks created from it. AWS CloudFormation also propagates these tags to supported resources that are created in the Stacks. A maximum number of 50 tags can be specified. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property templateBody String containing the CloudFormation template body. Maximum size: 51,200 bytes. Conflicts with `template_url`.
 * @property templateUrl String containing the location of a file containing the CloudFormation template body. The URL must point to a template that is located in an Amazon S3 bucket. Maximum location file size: 460,800 bytes. Conflicts with `template_body`.
 */
public data class StackSetArgs(
    public val administrationRoleArn: Output<String>? = null,
    public val autoDeployment: Output<StackSetAutoDeploymentArgs>? = null,
    public val callAs: Output<String>? = null,
    public val capabilities: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val executionRoleName: Output<String>? = null,
    public val managedExecution: Output<StackSetManagedExecutionArgs>? = null,
    public val name: Output<String>? = null,
    public val operationPreferences: Output<StackSetOperationPreferencesArgs>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val permissionModel: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateBody: Output<String>? = null,
    public val templateUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudformation.StackSetArgs> {
    override fun toJava(): com.pulumi.aws.cloudformation.StackSetArgs =
        com.pulumi.aws.cloudformation.StackSetArgs.builder()
            .administrationRoleArn(administrationRoleArn?.applyValue({ args0 -> args0 }))
            .autoDeployment(autoDeployment?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .callAs(callAs?.applyValue({ args0 -> args0 }))
            .capabilities(capabilities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .executionRoleName(executionRoleName?.applyValue({ args0 -> args0 }))
            .managedExecution(managedExecution?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .operationPreferences(
                operationPreferences?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .permissionModel(permissionModel?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateBody(templateBody?.applyValue({ args0 -> args0 }))
            .templateUrl(templateUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackSetArgs].
 */
@PulumiTagMarker
public class StackSetArgsBuilder internal constructor() {
    private var administrationRoleArn: Output<String>? = null

    private var autoDeployment: Output<StackSetAutoDeploymentArgs>? = null

    private var callAs: Output<String>? = null

    private var capabilities: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var executionRoleName: Output<String>? = null

    private var managedExecution: Output<StackSetManagedExecutionArgs>? = null

    private var name: Output<String>? = null

    private var operationPreferences: Output<StackSetOperationPreferencesArgs>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var permissionModel: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateBody: Output<String>? = null

    private var templateUrl: Output<String>? = null

    /**
     * @param value Amazon Resource Number (ARN) of the IAM Role in the administrator account. This must be defined when using the `SELF_MANAGED` permission model.
     */
    @JvmName("ukafxwujqmjqurbk")
    public suspend fun administrationRoleArn(`value`: Output<String>) {
        this.administrationRoleArn = value
    }

    /**
     * @param value Configuration block containing the auto-deployment model for your StackSet. This can only be defined when using the `SERVICE_MANAGED` permission model.
     */
    @JvmName("kxfxqmltnrosaipm")
    public suspend fun autoDeployment(`value`: Output<StackSetAutoDeploymentArgs>) {
        this.autoDeployment = value
    }

    /**
     * @param value Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
     */
    @JvmName("fyilrgmjtsjmucra")
    public suspend fun callAs(`value`: Output<String>) {
        this.callAs = value
    }

    /**
     * @param value A list of capabilities. Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_AUTO_EXPAND`.
     */
    @JvmName("fwuxlwwwaxljcvph")
    public suspend fun capabilities(`value`: Output<List<String>>) {
        this.capabilities = value
    }

    @JvmName("oocqvrttlfgffeol")
    public suspend fun capabilities(vararg values: Output<String>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values A list of capabilities. Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_AUTO_EXPAND`.
     */
    @JvmName("aedkongqnxretwqv")
    public suspend fun capabilities(values: List<Output<String>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value Description of the StackSet.
     */
    @JvmName("vbcaludybrhikxvg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the IAM Role in all target accounts for StackSet operations. Defaults to `AWSCloudFormationStackSetExecutionRole` when using the `SELF_MANAGED` permission model. This should not be defined when using the `SERVICE_MANAGED` permission model.
     */
    @JvmName("woflmsexxnfjugwg")
    public suspend fun executionRoleName(`value`: Output<String>) {
        this.executionRoleName = value
    }

    /**
     * @param value Configuration block to allow StackSets to perform non-conflicting operations concurrently and queues conflicting operations.
     */
    @JvmName("nepkwefiimqpquij")
    public suspend fun managedExecution(`value`: Output<StackSetManagedExecutionArgs>) {
        this.managedExecution = value
    }

    /**
     * @param value Name of the StackSet. The name must be unique in the region where you create your StackSet. The name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an alphabetic character and cannot be longer than 128 characters.
     */
    @JvmName("lrodcgdcnuimypyf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Preferences for how AWS CloudFormation performs a stack set update.
     */
    @JvmName("ewvvhvirvmlqnrss")
    public suspend fun operationPreferences(`value`: Output<StackSetOperationPreferencesArgs>) {
        this.operationPreferences = value
    }

    /**
     * @param value Key-value map of input parameters for the StackSet template. All template parameters, including those with a `Default`, must be configured or ignored with `lifecycle` configuration block `ignore_changes` argument. All `NoEcho` template parameters must be ignored with the `lifecycle` configuration block `ignore_changes` argument.
     */
    @JvmName("mlbpqanujtdnnmdg")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Describes how the IAM roles required for your StackSet are created. Valid values: `SELF_MANAGED` (default), `SERVICE_MANAGED`.
     */
    @JvmName("sikjhfloixebmxsu")
    public suspend fun permissionModel(`value`: Output<String>) {
        this.permissionModel = value
    }

    /**
     * @param value Key-value map of tags to associate with this StackSet and the Stacks created from it. AWS CloudFormation also propagates these tags to supported resources that are created in the Stacks. A maximum number of 50 tags can be specified. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cplpcchlfqujagyu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value String containing the CloudFormation template body. Maximum size: 51,200 bytes. Conflicts with `template_url`.
     */
    @JvmName("jmpibodhnfqxdxot")
    public suspend fun templateBody(`value`: Output<String>) {
        this.templateBody = value
    }

    /**
     * @param value String containing the location of a file containing the CloudFormation template body. The URL must point to a template that is located in an Amazon S3 bucket. Maximum location file size: 460,800 bytes. Conflicts with `template_body`.
     */
    @JvmName("vwebyvfjdkkhhcix")
    public suspend fun templateUrl(`value`: Output<String>) {
        this.templateUrl = value
    }

    /**
     * @param value Amazon Resource Number (ARN) of the IAM Role in the administrator account. This must be defined when using the `SELF_MANAGED` permission model.
     */
    @JvmName("mmcdqetcbqunihwi")
    public suspend fun administrationRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administrationRoleArn = mapped
    }

    /**
     * @param value Configuration block containing the auto-deployment model for your StackSet. This can only be defined when using the `SERVICE_MANAGED` permission model.
     */
    @JvmName("lseaeskjjpostdht")
    public suspend fun autoDeployment(`value`: StackSetAutoDeploymentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDeployment = mapped
    }

    /**
     * @param argument Configuration block containing the auto-deployment model for your StackSet. This can only be defined when using the `SERVICE_MANAGED` permission model.
     */
    @JvmName("isrnmmnbnnqlkqlv")
    public suspend
    fun autoDeployment(argument: suspend StackSetAutoDeploymentArgsBuilder.() -> Unit) {
        val toBeMapped = StackSetAutoDeploymentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoDeployment = mapped
    }

    /**
     * @param value Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
     */
    @JvmName("ukorllqotpcjjepf")
    public suspend fun callAs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callAs = mapped
    }

    /**
     * @param value A list of capabilities. Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_AUTO_EXPAND`.
     */
    @JvmName("wntgmuiogyksvwie")
    public suspend fun capabilities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param values A list of capabilities. Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_AUTO_EXPAND`.
     */
    @JvmName("yrsituneshywgbda")
    public suspend fun capabilities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value Description of the StackSet.
     */
    @JvmName("uhnkycmlcklyvwnv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the IAM Role in all target accounts for StackSet operations. Defaults to `AWSCloudFormationStackSetExecutionRole` when using the `SELF_MANAGED` permission model. This should not be defined when using the `SERVICE_MANAGED` permission model.
     */
    @JvmName("ejonvsaukkvamcta")
    public suspend fun executionRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionRoleName = mapped
    }

    /**
     * @param value Configuration block to allow StackSets to perform non-conflicting operations concurrently and queues conflicting operations.
     */
    @JvmName("rsfljdaikpibxvcu")
    public suspend fun managedExecution(`value`: StackSetManagedExecutionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedExecution = mapped
    }

    /**
     * @param argument Configuration block to allow StackSets to perform non-conflicting operations concurrently and queues conflicting operations.
     */
    @JvmName("dpwfjgfaatsmyben")
    public suspend
    fun managedExecution(argument: suspend StackSetManagedExecutionArgsBuilder.() -> Unit) {
        val toBeMapped = StackSetManagedExecutionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedExecution = mapped
    }

    /**
     * @param value Name of the StackSet. The name must be unique in the region where you create your StackSet. The name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an alphabetic character and cannot be longer than 128 characters.
     */
    @JvmName("dlwrqjynrieyqgxq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Preferences for how AWS CloudFormation performs a stack set update.
     */
    @JvmName("vlcxmevfpdajqgie")
    public suspend fun operationPreferences(`value`: StackSetOperationPreferencesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationPreferences = mapped
    }

    /**
     * @param argument Preferences for how AWS CloudFormation performs a stack set update.
     */
    @JvmName("xvocanmbawgwrcqn")
    public suspend
    fun operationPreferences(argument: suspend StackSetOperationPreferencesArgsBuilder.() -> Unit) {
        val toBeMapped = StackSetOperationPreferencesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.operationPreferences = mapped
    }

    /**
     * @param value Key-value map of input parameters for the StackSet template. All template parameters, including those with a `Default`, must be configured or ignored with `lifecycle` configuration block `ignore_changes` argument. All `NoEcho` template parameters must be ignored with the `lifecycle` configuration block `ignore_changes` argument.
     */
    @JvmName("pajquvxlcqtwddfi")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Key-value map of input parameters for the StackSet template. All template parameters, including those with a `Default`, must be configured or ignored with `lifecycle` configuration block `ignore_changes` argument. All `NoEcho` template parameters must be ignored with the `lifecycle` configuration block `ignore_changes` argument.
     */
    @JvmName("uetaxdurcxjtdplh")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Describes how the IAM roles required for your StackSet are created. Valid values: `SELF_MANAGED` (default), `SERVICE_MANAGED`.
     */
    @JvmName("meneyvxcxtfibdmr")
    public suspend fun permissionModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionModel = mapped
    }

    /**
     * @param value Key-value map of tags to associate with this StackSet and the Stacks created from it. AWS CloudFormation also propagates these tags to supported resources that are created in the Stacks. A maximum number of 50 tags can be specified. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mgpdebqvbtgxasrp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of tags to associate with this StackSet and the Stacks created from it. AWS CloudFormation also propagates these tags to supported resources that are created in the Stacks. A maximum number of 50 tags can be specified. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cfdodfepogtkacpu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value String containing the CloudFormation template body. Maximum size: 51,200 bytes. Conflicts with `template_url`.
     */
    @JvmName("qfjhvsnymjfiiiem")
    public suspend fun templateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateBody = mapped
    }

    /**
     * @param value String containing the location of a file containing the CloudFormation template body. The URL must point to a template that is located in an Amazon S3 bucket. Maximum location file size: 460,800 bytes. Conflicts with `template_body`.
     */
    @JvmName("kbqbrayrjfxwwpxa")
    public suspend fun templateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateUrl = mapped
    }

    internal fun build(): StackSetArgs = StackSetArgs(
        administrationRoleArn = administrationRoleArn,
        autoDeployment = autoDeployment,
        callAs = callAs,
        capabilities = capabilities,
        description = description,
        executionRoleName = executionRoleName,
        managedExecution = managedExecution,
        name = name,
        operationPreferences = operationPreferences,
        parameters = parameters,
        permissionModel = permissionModel,
        tags = tags,
        templateBody = templateBody,
        templateUrl = templateUrl,
    )
}
