@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin

import com.pulumi.aws.cloudformation.kotlin.outputs.StackSetInstanceDeploymentTargets
import com.pulumi.aws.cloudformation.kotlin.outputs.StackSetInstanceOperationPreferences
import com.pulumi.aws.cloudformation.kotlin.outputs.StackSetInstanceStackInstanceSummary
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.cloudformation.kotlin.outputs.StackSetInstanceDeploymentTargets.Companion.toKotlin as stackSetInstanceDeploymentTargetsToKotlin
import com.pulumi.aws.cloudformation.kotlin.outputs.StackSetInstanceOperationPreferences.Companion.toKotlin as stackSetInstanceOperationPreferencesToKotlin
import com.pulumi.aws.cloudformation.kotlin.outputs.StackSetInstanceStackInstanceSummary.Companion.toKotlin as stackSetInstanceStackInstanceSummaryToKotlin

/**
 * Builder for [StackSetInstance].
 */
@PulumiTagMarker
public class StackSetInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StackSetInstanceArgs = StackSetInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StackSetInstanceArgsBuilder.() -> Unit) {
        val builder = StackSetInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StackSetInstance {
        val builtJavaResource = com.pulumi.aws.cloudformation.StackSetInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StackSetInstance(builtJavaResource)
    }
}

/**
 * Manages a CloudFormation StackSet Instance. Instances are managed in the account and region of the StackSet after the target account permissions have been configured. Additional information about StackSets can be found in the [AWS CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/what-is-cfnstacksets.html).
 * > **NOTE:** All target accounts must have an IAM Role created that matches the name of the execution role configured in the StackSet (the `execution_role_name` argument in the `aws.cloudformation.StackSet` resource) in a trust relationship with the administrative account or administration IAM Role. The execution role must have appropriate permissions to manage resources defined in the template along with those required for StackSets to operate. See the [AWS CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html) for more details.
 * > **NOTE:** To retain the Stack during resource destroy, ensure `retain_stack` has been set to `true` in the state first. This must be completed _before_ a deployment that would destroy the resource.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudformation.StackSetInstance;
 * import com.pulumi.aws.cloudformation.StackSetInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StackSetInstance("example", StackSetInstanceArgs.builder()
 *             .accountId("123456789012")
 *             .region("us-east-1")
 *             .stackSetName(aws_cloudformation_stack_set.example().name())
 *             .build());
 *     }
 * }
 * ```
 * ### Example IAM Setup in Target Account
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var aWSCloudFormationStackSetExecutionRoleAssumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers(aws_iam_role.AWSCloudFormationStackSetAdministrationRole().arn())
 *                     .type("AWS")
 *                     .build())
 *                 .build())
 *             .build());
 *         var aWSCloudFormationStackSetExecutionRole = new Role("aWSCloudFormationStackSetExecutionRole", RoleArgs.builder()
 *             .assumeRolePolicy(aWSCloudFormationStackSetExecutionRoleAssumeRolePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var aWSCloudFormationStackSetExecutionRoleMinimumExecutionPolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "cloudformation:*",
 *                     "s3:*",
 *                     "sns:*")
 *                 .effect("Allow")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var aWSCloudFormationStackSetExecutionRoleMinimumExecutionPolicyRolePolicy = new RolePolicy("aWSCloudFormationStackSetExecutionRoleMinimumExecutionPolicyRolePolicy", RolePolicyArgs.builder()
 *             .policy(aWSCloudFormationStackSetExecutionRoleMinimumExecutionPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .role(aWSCloudFormationStackSetExecutionRole.name())
 *             .build());
 *     }
 * }
 * ```
 * ### Example Deployment across Organizations account
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudformation.StackSetInstance;
 * import com.pulumi.aws.cloudformation.StackSetInstanceArgs;
 * import com.pulumi.aws.cloudformation.inputs.StackSetInstanceDeploymentTargetsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StackSetInstance("example", StackSetInstanceArgs.builder()
 *             .deploymentTargets(StackSetInstanceDeploymentTargetsArgs.builder()
 *                 .organizationalUnitIds(aws_organizations_organization.example().roots()[0].id())
 *                 .build())
 *             .region("us-east-1")
 *             .stackSetName(aws_cloudformation_stack_set.example().name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Import CloudFormation StackSet Instances that target AWS Organizational Units using the StackSet name, a slash (`/`) separated list of organizational unit IDs, and target AWS Region separated by commas (`,`). For example:
 * Import CloudFormation StackSet Instances when acting a delegated administrator in a member account using the StackSet name, target AWS account ID or slash (`/`) separated list of organizational unit IDs, target AWS Region and `call_as` value separated by commas (`,`). For example:
 * Using `pulumi import`, import CloudFormation StackSet Instances that target an AWS Account ID using the StackSet name, target AWS account ID, and target AWS Region separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:cloudformation/stackSetInstance:StackSetInstance example example,123456789012,us-east-1
 * ```
 *  Using `pulumi import`, import CloudFormation StackSet Instances that target AWS Organizational Units using the StackSet name, a slash (`/`) separated list of organizational unit IDs, and target AWS Region separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:cloudformation/stackSetInstance:StackSetInstance example example,ou-sdas-123123123/ou-sdas-789789789,us-east-1
 * ```
 *  Using `pulumi import`, import CloudFormation StackSet Instances when acting a delegated administrator in a member account using the StackSet name, target AWS account ID or slash (`/`) separated list of organizational unit IDs, target AWS Region and `call_as` value separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:cloudformation/stackSetInstance:StackSetInstance example example,ou-sdas-123123123/ou-sdas-789789789,us-east-1,DELEGATED_ADMIN
 * ```
 *
 */
public class StackSetInstance internal constructor(
    override val javaResource: com.pulumi.aws.cloudformation.StackSetInstance,
) : KotlinCustomResource(javaResource, StackSetInstanceMapper) {
    /**
     * Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
     */
    public val callAs: Output<String>?
        get() = javaResource.callAs().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The AWS Organizations accounts to which StackSets deploys. StackSets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
     */
    public val deploymentTargets: Output<StackSetInstanceDeploymentTargets>?
        get() = javaResource.deploymentTargets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> stackSetInstanceDeploymentTargetsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Preferences for how AWS CloudFormation performs a stack set operation.
     */
    public val operationPreferences: Output<StackSetInstanceOperationPreferences>?
        get() = javaResource.operationPreferences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> stackSetInstanceOperationPreferencesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Organizational unit ID in which the stack is deployed.
     */
    public val organizationalUnitId: Output<String>
        get() = javaResource.organizationalUnitId().applyValue({ args0 -> args0 })

    /**
     * Key-value map of input parameters to override from the StackSet for this Instance.
     */
    public val parameterOverrides: Output<Map<String, String>>?
        get() = javaResource.parameterOverrides().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
     */
    public val region: Output<String>
        get() = javaResource.region().applyValue({ args0 -> args0 })

    /**
     * During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
     */
    public val retainStack: Output<Boolean>?
        get() = javaResource.retainStack().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Stack identifier.
     */
    public val stackId: Output<String>
        get() = javaResource.stackId().applyValue({ args0 -> args0 })

    /**
     * List of stack instances created from an organizational unit deployment target. This will only be populated when `deployment_targets` is set. See `stack_instance_summaries`.
     */
    public val stackInstanceSummaries: Output<List<StackSetInstanceStackInstanceSummary>>
        get() = javaResource.stackInstanceSummaries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> stackSetInstanceStackInstanceSummaryToKotlin(args0) })
            })
        })

    /**
     * Name of the StackSet.
     */
    public val stackSetName: Output<String>
        get() = javaResource.stackSetName().applyValue({ args0 -> args0 })
}

public object StackSetInstanceMapper : ResourceMapper<StackSetInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudformation.StackSetInstance::class == javaResource::class

    override fun map(javaResource: Resource): StackSetInstance = StackSetInstance(
        javaResource as
            com.pulumi.aws.cloudformation.StackSetInstance,
    )
}

/**
 * @see [StackSetInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StackSetInstance].
 */
public suspend fun stackSetInstance(
    name: String,
    block: suspend StackSetInstanceResourceBuilder.() -> Unit,
): StackSetInstance {
    val builder = StackSetInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StackSetInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun stackSetInstance(name: String): StackSetInstance {
    val builder = StackSetInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
