@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin

import com.pulumi.aws.cloudformation.StackSetInstanceArgs.builder
import com.pulumi.aws.cloudformation.kotlin.inputs.StackSetInstanceDeploymentTargetsArgs
import com.pulumi.aws.cloudformation.kotlin.inputs.StackSetInstanceDeploymentTargetsArgsBuilder
import com.pulumi.aws.cloudformation.kotlin.inputs.StackSetInstanceOperationPreferencesArgs
import com.pulumi.aws.cloudformation.kotlin.inputs.StackSetInstanceOperationPreferencesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a CloudFormation StackSet Instance. Instances are managed in the account and region of the StackSet after the target account permissions have been configured. Additional information about StackSets can be found in the [AWS CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/what-is-cfnstacksets.html).
 * > **NOTE:** All target accounts must have an IAM Role created that matches the name of the execution role configured in the StackSet (the `execution_role_name` argument in the `aws.cloudformation.StackSet` resource) in a trust relationship with the administrative account or administration IAM Role. The execution role must have appropriate permissions to manage resources defined in the template along with those required for StackSets to operate. See the [AWS CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html) for more details.
 * > **NOTE:** To retain the Stack during resource destroy, ensure `retain_stack` has been set to `true` in the state first. This must be completed _before_ a deployment that would destroy the resource.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudformation.StackSetInstance;
 * import com.pulumi.aws.cloudformation.StackSetInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StackSetInstance("example", StackSetInstanceArgs.builder()
 *             .accountId("123456789012")
 *             .region("us-east-1")
 *             .stackSetName(aws_cloudformation_stack_set.example().name())
 *             .build());
 *     }
 * }
 * ```
 * ### Example IAM Setup in Target Account
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var aWSCloudFormationStackSetExecutionRoleAssumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers(aws_iam_role.AWSCloudFormationStackSetAdministrationRole().arn())
 *                     .type("AWS")
 *                     .build())
 *                 .build())
 *             .build());
 *         var aWSCloudFormationStackSetExecutionRole = new Role("aWSCloudFormationStackSetExecutionRole", RoleArgs.builder()
 *             .assumeRolePolicy(aWSCloudFormationStackSetExecutionRoleAssumeRolePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var aWSCloudFormationStackSetExecutionRoleMinimumExecutionPolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "cloudformation:*",
 *                     "s3:*",
 *                     "sns:*")
 *                 .effect("Allow")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var aWSCloudFormationStackSetExecutionRoleMinimumExecutionPolicyRolePolicy = new RolePolicy("aWSCloudFormationStackSetExecutionRoleMinimumExecutionPolicyRolePolicy", RolePolicyArgs.builder()
 *             .policy(aWSCloudFormationStackSetExecutionRoleMinimumExecutionPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .role(aWSCloudFormationStackSetExecutionRole.name())
 *             .build());
 *     }
 * }
 * ```
 * ### Example Deployment across Organizations account
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudformation.StackSetInstance;
 * import com.pulumi.aws.cloudformation.StackSetInstanceArgs;
 * import com.pulumi.aws.cloudformation.inputs.StackSetInstanceDeploymentTargetsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StackSetInstance("example", StackSetInstanceArgs.builder()
 *             .deploymentTargets(StackSetInstanceDeploymentTargetsArgs.builder()
 *                 .organizationalUnitIds(aws_organizations_organization.example().roots()[0].id())
 *                 .build())
 *             .region("us-east-1")
 *             .stackSetName(aws_cloudformation_stack_set.example().name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Import CloudFormation StackSet Instances that target AWS Organizational Units using the StackSet name, a slash (`/`) separated list of organizational unit IDs, and target AWS Region separated by commas (`,`). For example:
 * Import CloudFormation StackSet Instances when acting a delegated administrator in a member account using the StackSet name, target AWS account ID or slash (`/`) separated list of organizational unit IDs, target AWS Region and `call_as` value separated by commas (`,`). For example:
 * Using `pulumi import`, import CloudFormation StackSet Instances that target an AWS Account ID using the StackSet name, target AWS account ID, and target AWS Region separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:cloudformation/stackSetInstance:StackSetInstance example example,123456789012,us-east-1
 * ```
 *  Using `pulumi import`, import CloudFormation StackSet Instances that target AWS Organizational Units using the StackSet name, a slash (`/`) separated list of organizational unit IDs, and target AWS Region separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:cloudformation/stackSetInstance:StackSetInstance example example,ou-sdas-123123123/ou-sdas-789789789,us-east-1
 * ```
 *  Using `pulumi import`, import CloudFormation StackSet Instances when acting a delegated administrator in a member account using the StackSet name, target AWS account ID or slash (`/`) separated list of organizational unit IDs, target AWS Region and `call_as` value separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:cloudformation/stackSetInstance:StackSetInstance example example,ou-sdas-123123123/ou-sdas-789789789,us-east-1,DELEGATED_ADMIN
 * ```
 * @property accountId Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
 * @property callAs Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
 * @property deploymentTargets The AWS Organizations accounts to which StackSets deploys. StackSets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
 * @property operationPreferences Preferences for how AWS CloudFormation performs a stack set operation.
 * @property parameterOverrides Key-value map of input parameters to override from the StackSet for this Instance.
 * @property region Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
 * @property retainStack During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
 * @property stackSetName Name of the StackSet.
 */
public data class StackSetInstanceArgs(
    public val accountId: Output<String>? = null,
    public val callAs: Output<String>? = null,
    public val deploymentTargets: Output<StackSetInstanceDeploymentTargetsArgs>? = null,
    public val operationPreferences: Output<StackSetInstanceOperationPreferencesArgs>? = null,
    public val parameterOverrides: Output<Map<String, String>>? = null,
    public val region: Output<String>? = null,
    public val retainStack: Output<Boolean>? = null,
    public val stackSetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudformation.StackSetInstanceArgs> {
    override fun toJava(): com.pulumi.aws.cloudformation.StackSetInstanceArgs =
        com.pulumi.aws.cloudformation.StackSetInstanceArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .callAs(callAs?.applyValue({ args0 -> args0 }))
            .deploymentTargets(deploymentTargets?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .operationPreferences(
                operationPreferences?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .parameterOverrides(
                parameterOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .region(region?.applyValue({ args0 -> args0 }))
            .retainStack(retainStack?.applyValue({ args0 -> args0 }))
            .stackSetName(stackSetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackSetInstanceArgs].
 */
@PulumiTagMarker
public class StackSetInstanceArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var callAs: Output<String>? = null

    private var deploymentTargets: Output<StackSetInstanceDeploymentTargetsArgs>? = null

    private var operationPreferences: Output<StackSetInstanceOperationPreferencesArgs>? = null

    private var parameterOverrides: Output<Map<String, String>>? = null

    private var region: Output<String>? = null

    private var retainStack: Output<Boolean>? = null

    private var stackSetName: Output<String>? = null

    /**
     * @param value Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
     */
    @JvmName("ixaloixyolnmnsbj")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
     */
    @JvmName("fxmyhomnlmejtgsn")
    public suspend fun callAs(`value`: Output<String>) {
        this.callAs = value
    }

    /**
     * @param value The AWS Organizations accounts to which StackSets deploys. StackSets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
     */
    @JvmName("xivghnhwvbpsgtcp")
    public suspend fun deploymentTargets(`value`: Output<StackSetInstanceDeploymentTargetsArgs>) {
        this.deploymentTargets = value
    }

    /**
     * @param value Preferences for how AWS CloudFormation performs a stack set operation.
     */
    @JvmName("jenpjfdrixvkkvic")
    public suspend
    fun operationPreferences(`value`: Output<StackSetInstanceOperationPreferencesArgs>) {
        this.operationPreferences = value
    }

    /**
     * @param value Key-value map of input parameters to override from the StackSet for this Instance.
     */
    @JvmName("jlnryulfyjvysjvy")
    public suspend fun parameterOverrides(`value`: Output<Map<String, String>>) {
        this.parameterOverrides = value
    }

    /**
     * @param value Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
     */
    @JvmName("texmadneqltbvbaw")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
     */
    @JvmName("unuakhuyqchtntap")
    public suspend fun retainStack(`value`: Output<Boolean>) {
        this.retainStack = value
    }

    /**
     * @param value Name of the StackSet.
     */
    @JvmName("jftmrphimblscqtr")
    public suspend fun stackSetName(`value`: Output<String>) {
        this.stackSetName = value
    }

    /**
     * @param value Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
     */
    @JvmName("jtvlcghwpnqwitxa")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
     */
    @JvmName("kyhfnoxkojafuvvj")
    public suspend fun callAs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callAs = mapped
    }

    /**
     * @param value The AWS Organizations accounts to which StackSets deploys. StackSets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
     */
    @JvmName("plsyxuwveqwnoqwf")
    public suspend fun deploymentTargets(`value`: StackSetInstanceDeploymentTargetsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentTargets = mapped
    }

    /**
     * @param argument The AWS Organizations accounts to which StackSets deploys. StackSets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
     */
    @JvmName("ntpmyoydnivpfxds")
    public suspend
    fun deploymentTargets(argument: suspend StackSetInstanceDeploymentTargetsArgsBuilder.() -> Unit) {
        val toBeMapped = StackSetInstanceDeploymentTargetsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deploymentTargets = mapped
    }

    /**
     * @param value Preferences for how AWS CloudFormation performs a stack set operation.
     */
    @JvmName("qsrjqrktumkjymng")
    public suspend fun operationPreferences(`value`: StackSetInstanceOperationPreferencesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationPreferences = mapped
    }

    /**
     * @param argument Preferences for how AWS CloudFormation performs a stack set operation.
     */
    @JvmName("nxkpwhqjxtjbskpj")
    public suspend
    fun operationPreferences(argument: suspend StackSetInstanceOperationPreferencesArgsBuilder.() -> Unit) {
        val toBeMapped = StackSetInstanceOperationPreferencesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.operationPreferences = mapped
    }

    /**
     * @param value Key-value map of input parameters to override from the StackSet for this Instance.
     */
    @JvmName("illjntbresxijfdt")
    public suspend fun parameterOverrides(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterOverrides = mapped
    }

    /**
     * @param values Key-value map of input parameters to override from the StackSet for this Instance.
     */
    @JvmName("vncolintrdttkqln")
    public fun parameterOverrides(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterOverrides = mapped
    }

    /**
     * @param value Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
     */
    @JvmName("sypueonmygwnfonc")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
     */
    @JvmName("mdltbruxcjidoipf")
    public suspend fun retainStack(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainStack = mapped
    }

    /**
     * @param value Name of the StackSet.
     */
    @JvmName("jekujcwmlqmatmvc")
    public suspend fun stackSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackSetName = mapped
    }

    internal fun build(): StackSetInstanceArgs = StackSetInstanceArgs(
        accountId = accountId,
        callAs = callAs,
        deploymentTargets = deploymentTargets,
        operationPreferences = operationPreferences,
        parameterOverrides = parameterOverrides,
        region = region,
        retainStack = retainStack,
        stackSetName = stackSetName,
    )
}
