@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.inputs

import com.pulumi.aws.cloudformation.inputs.CloudFormationTypeLoggingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logGroupName Name of the CloudWatch Log Group where CloudFormation sends error logging information when invoking the type's handlers.
 * @property logRoleArn Amazon Resource Name (ARN) of the IAM Role CloudFormation assumes when sending error logging information to CloudWatch Logs.
 */
public data class CloudFormationTypeLoggingConfigArgs(
    public val logGroupName: Output<String>,
    public val logRoleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudformation.inputs.CloudFormationTypeLoggingConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudformation.inputs.CloudFormationTypeLoggingConfigArgs =
        com.pulumi.aws.cloudformation.inputs.CloudFormationTypeLoggingConfigArgs.builder()
            .logGroupName(logGroupName.applyValue({ args0 -> args0 }))
            .logRoleArn(logRoleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CloudFormationTypeLoggingConfigArgs].
 */
@PulumiTagMarker
public class CloudFormationTypeLoggingConfigArgsBuilder internal constructor() {
    private var logGroupName: Output<String>? = null

    private var logRoleArn: Output<String>? = null

    /**
     * @param value Name of the CloudWatch Log Group where CloudFormation sends error logging information when invoking the type's handlers.
     */
    @JvmName("bfnofditwifvnicb")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role CloudFormation assumes when sending error logging information to CloudWatch Logs.
     */
    @JvmName("vbuljmwfntgrwslc")
    public suspend fun logRoleArn(`value`: Output<String>) {
        this.logRoleArn = value
    }

    /**
     * @param value Name of the CloudWatch Log Group where CloudFormation sends error logging information when invoking the type's handlers.
     */
    @JvmName("hvmgsxvogpxnsxvd")
    public suspend fun logGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role CloudFormation assumes when sending error logging information to CloudWatch Logs.
     */
    @JvmName("adarqsajointydst")
    public suspend fun logRoleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logRoleArn = mapped
    }

    internal fun build(): CloudFormationTypeLoggingConfigArgs = CloudFormationTypeLoggingConfigArgs(
        logGroupName = logGroupName ?: throw PulumiNullFieldException("logGroupName"),
        logRoleArn = logRoleArn ?: throw PulumiNullFieldException("logRoleArn"),
    )
}
