@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.inputs

import com.pulumi.aws.cloudformation.inputs.StackSetInstanceDeploymentTargetsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property organizationalUnitIds The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
 */
public data class StackSetInstanceDeploymentTargetsArgs(
    public val organizationalUnitIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudformation.inputs.StackSetInstanceDeploymentTargetsArgs> {
    override fun toJava(): com.pulumi.aws.cloudformation.inputs.StackSetInstanceDeploymentTargetsArgs =
        com.pulumi.aws.cloudformation.inputs.StackSetInstanceDeploymentTargetsArgs.builder()
            .organizationalUnitIds(
                organizationalUnitIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [StackSetInstanceDeploymentTargetsArgs].
 */
@PulumiTagMarker
public class StackSetInstanceDeploymentTargetsArgsBuilder internal constructor() {
    private var organizationalUnitIds: Output<List<String>>? = null

    /**
     * @param value The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
     */
    @JvmName("jceyllqiiubibxbx")
    public suspend fun organizationalUnitIds(`value`: Output<List<String>>) {
        this.organizationalUnitIds = value
    }

    @JvmName("qbwublsjbdkocllo")
    public suspend fun organizationalUnitIds(vararg values: Output<String>) {
        this.organizationalUnitIds = Output.all(values.asList())
    }

    /**
     * @param values The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
     */
    @JvmName("lwfvwbeorpsafxvk")
    public suspend fun organizationalUnitIds(values: List<Output<String>>) {
        this.organizationalUnitIds = Output.all(values)
    }

    /**
     * @param value The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
     */
    @JvmName("mypvljdkumwykwix")
    public suspend fun organizationalUnitIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalUnitIds = mapped
    }

    /**
     * @param values The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
     */
    @JvmName("soyxsmkjfxvvfmjp")
    public suspend fun organizationalUnitIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationalUnitIds = mapped
    }

    internal fun build(): StackSetInstanceDeploymentTargetsArgs =
        StackSetInstanceDeploymentTargetsArgs(
            organizationalUnitIds = organizationalUnitIds,
        )
}
