@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.inputs

import com.pulumi.aws.cloudformation.inputs.StackSetInstanceOperationPreferencesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property failureToleranceCount The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
 * @property failureTolerancePercentage The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
 * @property maxConcurrentCount The maximum number of accounts in which to perform this operation at one time.
 * @property maxConcurrentPercentage The maximum percentage of accounts in which to perform this operation at one time.
 * @property regionConcurrencyType The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time. Valid values are `SEQUENTIAL` and `PARALLEL`.
 * @property regionOrders The order of the Regions in where you want to perform the stack operation.
 */
public data class StackSetInstanceOperationPreferencesArgs(
    public val failureToleranceCount: Output<Int>? = null,
    public val failureTolerancePercentage: Output<Int>? = null,
    public val maxConcurrentCount: Output<Int>? = null,
    public val maxConcurrentPercentage: Output<Int>? = null,
    public val regionConcurrencyType: Output<String>? = null,
    public val regionOrders: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudformation.inputs.StackSetInstanceOperationPreferencesArgs> {
    override fun toJava():
        com.pulumi.aws.cloudformation.inputs.StackSetInstanceOperationPreferencesArgs =
        com.pulumi.aws.cloudformation.inputs.StackSetInstanceOperationPreferencesArgs.builder()
            .failureToleranceCount(failureToleranceCount?.applyValue({ args0 -> args0 }))
            .failureTolerancePercentage(failureTolerancePercentage?.applyValue({ args0 -> args0 }))
            .maxConcurrentCount(maxConcurrentCount?.applyValue({ args0 -> args0 }))
            .maxConcurrentPercentage(maxConcurrentPercentage?.applyValue({ args0 -> args0 }))
            .regionConcurrencyType(regionConcurrencyType?.applyValue({ args0 -> args0 }))
            .regionOrders(regionOrders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [StackSetInstanceOperationPreferencesArgs].
 */
@PulumiTagMarker
public class StackSetInstanceOperationPreferencesArgsBuilder internal constructor() {
    private var failureToleranceCount: Output<Int>? = null

    private var failureTolerancePercentage: Output<Int>? = null

    private var maxConcurrentCount: Output<Int>? = null

    private var maxConcurrentPercentage: Output<Int>? = null

    private var regionConcurrencyType: Output<String>? = null

    private var regionOrders: Output<List<String>>? = null

    /**
     * @param value The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
     */
    @JvmName("afyplrohbtgxvssc")
    public suspend fun failureToleranceCount(`value`: Output<Int>) {
        this.failureToleranceCount = value
    }

    /**
     * @param value The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
     */
    @JvmName("fxowhjkarwpsdmul")
    public suspend fun failureTolerancePercentage(`value`: Output<Int>) {
        this.failureTolerancePercentage = value
    }

    /**
     * @param value The maximum number of accounts in which to perform this operation at one time.
     */
    @JvmName("hroeiglkdjaltumh")
    public suspend fun maxConcurrentCount(`value`: Output<Int>) {
        this.maxConcurrentCount = value
    }

    /**
     * @param value The maximum percentage of accounts in which to perform this operation at one time.
     */
    @JvmName("xeirdyrwnjcxaqst")
    public suspend fun maxConcurrentPercentage(`value`: Output<Int>) {
        this.maxConcurrentPercentage = value
    }

    /**
     * @param value The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time. Valid values are `SEQUENTIAL` and `PARALLEL`.
     */
    @JvmName("rvoxubpdffbgroda")
    public suspend fun regionConcurrencyType(`value`: Output<String>) {
        this.regionConcurrencyType = value
    }

    /**
     * @param value The order of the Regions in where you want to perform the stack operation.
     */
    @JvmName("pirobxflslqaehih")
    public suspend fun regionOrders(`value`: Output<List<String>>) {
        this.regionOrders = value
    }

    @JvmName("rlppibylpkjombkw")
    public suspend fun regionOrders(vararg values: Output<String>) {
        this.regionOrders = Output.all(values.asList())
    }

    /**
     * @param values The order of the Regions in where you want to perform the stack operation.
     */
    @JvmName("xejuvuhijaflcnob")
    public suspend fun regionOrders(values: List<Output<String>>) {
        this.regionOrders = Output.all(values)
    }

    /**
     * @param value The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
     */
    @JvmName("lbfcvjfrtwfsqvch")
    public suspend fun failureToleranceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureToleranceCount = mapped
    }

    /**
     * @param value The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
     */
    @JvmName("acbedckklsuboamn")
    public suspend fun failureTolerancePercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureTolerancePercentage = mapped
    }

    /**
     * @param value The maximum number of accounts in which to perform this operation at one time.
     */
    @JvmName("dshmjdxkerenfptb")
    public suspend fun maxConcurrentCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentCount = mapped
    }

    /**
     * @param value The maximum percentage of accounts in which to perform this operation at one time.
     */
    @JvmName("dflkjhstmnulwjik")
    public suspend fun maxConcurrentPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentPercentage = mapped
    }

    /**
     * @param value The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time. Valid values are `SEQUENTIAL` and `PARALLEL`.
     */
    @JvmName("ueoeiuwsiswcqnxl")
    public suspend fun regionConcurrencyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionConcurrencyType = mapped
    }

    /**
     * @param value The order of the Regions in where you want to perform the stack operation.
     */
    @JvmName("oumtjrbhxlmhcrsc")
    public suspend fun regionOrders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionOrders = mapped
    }

    /**
     * @param values The order of the Regions in where you want to perform the stack operation.
     */
    @JvmName("yatylwhanvcdrrgc")
    public suspend fun regionOrders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionOrders = mapped
    }

    internal fun build(): StackSetInstanceOperationPreferencesArgs =
        StackSetInstanceOperationPreferencesArgs(
            failureToleranceCount = failureToleranceCount,
            failureTolerancePercentage = failureTolerancePercentage,
            maxConcurrentCount = maxConcurrentCount,
            maxConcurrentPercentage = maxConcurrentPercentage,
            regionConcurrencyType = regionConcurrencyType,
            regionOrders = regionOrders,
        )
}
