@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.inputs

import com.pulumi.aws.cloudformation.inputs.StackSetOperationPreferencesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property failureToleranceCount The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
 * @property failureTolerancePercentage The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
 * @property maxConcurrentCount The maximum number of accounts in which to perform this operation at one time.
 * @property maxConcurrentPercentage The maximum percentage of accounts in which to perform this operation at one time.
 * @property regionConcurrencyType The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
 * @property regionOrders The order of the Regions in where you want to perform the stack operation.
 */
public data class StackSetOperationPreferencesArgs(
    public val failureToleranceCount: Output<Int>? = null,
    public val failureTolerancePercentage: Output<Int>? = null,
    public val maxConcurrentCount: Output<Int>? = null,
    public val maxConcurrentPercentage: Output<Int>? = null,
    public val regionConcurrencyType: Output<String>? = null,
    public val regionOrders: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudformation.inputs.StackSetOperationPreferencesArgs> {
    override fun toJava(): com.pulumi.aws.cloudformation.inputs.StackSetOperationPreferencesArgs =
        com.pulumi.aws.cloudformation.inputs.StackSetOperationPreferencesArgs.builder()
            .failureToleranceCount(failureToleranceCount?.applyValue({ args0 -> args0 }))
            .failureTolerancePercentage(failureTolerancePercentage?.applyValue({ args0 -> args0 }))
            .maxConcurrentCount(maxConcurrentCount?.applyValue({ args0 -> args0 }))
            .maxConcurrentPercentage(maxConcurrentPercentage?.applyValue({ args0 -> args0 }))
            .regionConcurrencyType(regionConcurrencyType?.applyValue({ args0 -> args0 }))
            .regionOrders(regionOrders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [StackSetOperationPreferencesArgs].
 */
@PulumiTagMarker
public class StackSetOperationPreferencesArgsBuilder internal constructor() {
    private var failureToleranceCount: Output<Int>? = null

    private var failureTolerancePercentage: Output<Int>? = null

    private var maxConcurrentCount: Output<Int>? = null

    private var maxConcurrentPercentage: Output<Int>? = null

    private var regionConcurrencyType: Output<String>? = null

    private var regionOrders: Output<List<String>>? = null

    /**
     * @param value The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
     */
    @JvmName("ccinpvphovwdxkhu")
    public suspend fun failureToleranceCount(`value`: Output<Int>) {
        this.failureToleranceCount = value
    }

    /**
     * @param value The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
     */
    @JvmName("ogoekyulijfmuhlx")
    public suspend fun failureTolerancePercentage(`value`: Output<Int>) {
        this.failureTolerancePercentage = value
    }

    /**
     * @param value The maximum number of accounts in which to perform this operation at one time.
     */
    @JvmName("roffqcgtubthpmxk")
    public suspend fun maxConcurrentCount(`value`: Output<Int>) {
        this.maxConcurrentCount = value
    }

    /**
     * @param value The maximum percentage of accounts in which to perform this operation at one time.
     */
    @JvmName("cledruwwxxvomlfn")
    public suspend fun maxConcurrentPercentage(`value`: Output<Int>) {
        this.maxConcurrentPercentage = value
    }

    /**
     * @param value The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
     */
    @JvmName("iyvkdvvchjtuimek")
    public suspend fun regionConcurrencyType(`value`: Output<String>) {
        this.regionConcurrencyType = value
    }

    /**
     * @param value The order of the Regions in where you want to perform the stack operation.
     */
    @JvmName("psmdifkyjnxburuf")
    public suspend fun regionOrders(`value`: Output<List<String>>) {
        this.regionOrders = value
    }

    @JvmName("niakgnwmegxwupor")
    public suspend fun regionOrders(vararg values: Output<String>) {
        this.regionOrders = Output.all(values.asList())
    }

    /**
     * @param values The order of the Regions in where you want to perform the stack operation.
     */
    @JvmName("gifxwxggnxyfjxyu")
    public suspend fun regionOrders(values: List<Output<String>>) {
        this.regionOrders = Output.all(values)
    }

    /**
     * @param value The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
     */
    @JvmName("wbocftbquttovcgt")
    public suspend fun failureToleranceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureToleranceCount = mapped
    }

    /**
     * @param value The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
     */
    @JvmName("qfteqoyvuduvntlw")
    public suspend fun failureTolerancePercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureTolerancePercentage = mapped
    }

    /**
     * @param value The maximum number of accounts in which to perform this operation at one time.
     */
    @JvmName("vxhwoxqgibgyijdd")
    public suspend fun maxConcurrentCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentCount = mapped
    }

    /**
     * @param value The maximum percentage of accounts in which to perform this operation at one time.
     */
    @JvmName("ljspmebybubtdpsf")
    public suspend fun maxConcurrentPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentPercentage = mapped
    }

    /**
     * @param value The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
     */
    @JvmName("oshdnrwxmwnryvtj")
    public suspend fun regionConcurrencyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionConcurrencyType = mapped
    }

    /**
     * @param value The order of the Regions in where you want to perform the stack operation.
     */
    @JvmName("sjwownusiolqakfu")
    public suspend fun regionOrders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionOrders = mapped
    }

    /**
     * @param values The order of the Regions in where you want to perform the stack operation.
     */
    @JvmName("fhdrbpkthigffaol")
    public suspend fun regionOrders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionOrders = mapped
    }

    internal fun build(): StackSetOperationPreferencesArgs = StackSetOperationPreferencesArgs(
        failureToleranceCount = failureToleranceCount,
        failureTolerancePercentage = failureTolerancePercentage,
        maxConcurrentCount = maxConcurrentCount,
        maxConcurrentPercentage = maxConcurrentPercentage,
        regionConcurrencyType = regionConcurrencyType,
        regionOrders = regionOrders,
    )
}
