@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCloudFormationType.
 * @property arn
 * @property defaultVersionId Identifier of the CloudFormation Type default version.
 * @property deprecatedStatus Deprecation status of the CloudFormation Type.
 * @property description Description of the CloudFormation Type.
 * @property documentationUrl URL of the documentation for the CloudFormation Type.
 * @property executionRoleArn ARN of the IAM Role used to register the CloudFormation Type.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property isDefaultVersion Whether the CloudFormation Type version is the default version.
 * @property loggingConfigs List of objects containing logging configuration.
 * @property provisioningType Provisioning behavior of the CloudFormation Type.
 * @property schema JSON document of the CloudFormation Type schema.
 * @property sourceUrl URL of the source code for the CloudFormation Type.
 * @property type
 * @property typeArn
 * @property typeName
 * @property versionId
 * @property visibility Scope of the CloudFormation Type.
 */
public data class GetCloudFormationTypeResult(
    public val arn: String,
    public val defaultVersionId: String,
    public val deprecatedStatus: String,
    public val description: String,
    public val documentationUrl: String,
    public val executionRoleArn: String,
    public val id: String,
    public val isDefaultVersion: Boolean,
    public val loggingConfigs: List<GetCloudFormationTypeLoggingConfig>,
    public val provisioningType: String,
    public val schema: String,
    public val sourceUrl: String,
    public val type: String,
    public val typeArn: String,
    public val typeName: String,
    public val versionId: String? = null,
    public val visibility: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudformation.outputs.GetCloudFormationTypeResult):
            GetCloudFormationTypeResult = GetCloudFormationTypeResult(
            arn = javaType.arn(),
            defaultVersionId = javaType.defaultVersionId(),
            deprecatedStatus = javaType.deprecatedStatus(),
            description = javaType.description(),
            documentationUrl = javaType.documentationUrl(),
            executionRoleArn = javaType.executionRoleArn(),
            id = javaType.id(),
            isDefaultVersion = javaType.isDefaultVersion(),
            loggingConfigs = javaType.loggingConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudformation.kotlin.outputs.GetCloudFormationTypeLoggingConfig.Companion.toKotlin(args0)
                })
            }),
            provisioningType = javaType.provisioningType(),
            schema = javaType.schema(),
            sourceUrl = javaType.sourceUrl(),
            type = javaType.type(),
            typeArn = javaType.typeArn(),
            typeName = javaType.typeName(),
            versionId = javaType.versionId().map({ args0 -> args0 }).orElse(null),
            visibility = javaType.visibility(),
        )
    }
}
