@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getExport.
 * @property exportingStackId ARN of stack that contains the exported output name and value.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property value Value from Cloudformation export identified by the export name found from [list-exports](http://docs.aws.amazon.com/cli/latest/reference/cloudformation/list-exports.html)
 */
public data class GetExportResult(
    public val exportingStackId: String,
    public val id: String,
    public val name: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudformation.outputs.GetExportResult):
            GetExportResult = GetExportResult(
            exportingStackId = javaType.exportingStackId(),
            id = javaType.id(),
            name = javaType.name(),
            `value` = javaType.`value`(),
        )
    }
}
