@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enabled Whether or not auto-deployment is enabled.
 * @property retainStacksOnAccountRemoval Whether or not to retain stacks when the account is removed.
 */
public data class StackSetAutoDeployment(
    public val enabled: Boolean? = null,
    public val retainStacksOnAccountRemoval: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudformation.outputs.StackSetAutoDeployment):
            StackSetAutoDeployment = StackSetAutoDeployment(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            retainStacksOnAccountRemoval = javaType.retainStacksOnAccountRemoval().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
