@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
 * @property organizationalUnitId Organizational unit ID in which the stack is deployed.
 * @property stackId Stack identifier.
 */
public data class StackSetInstanceStackInstanceSummary(
    public val accountId: String? = null,
    public val organizationalUnitId: String? = null,
    public val stackId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cloudformation.outputs.StackSetInstanceStackInstanceSummary):
            StackSetInstanceStackInstanceSummary = StackSetInstanceStackInstanceSummary(
            accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
            organizationalUnitId = javaType.organizationalUnitId().map({ args0 -> args0 }).orElse(null),
            stackId = javaType.stackId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
