@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.CloudfrontFunctions.getCachePolicyPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getDistributionPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getFunctionPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getLogDeliveryCanonicalUserIdPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getOriginAccessIdentitiesPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getOriginAccessIdentityPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getOriginRequestPolicyPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getRealtimeLogConfigPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getResponseHeadersPolicyPlain
import com.pulumi.aws.cloudfront.kotlin.inputs.GetCachePolicyPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetCachePolicyPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetDistributionPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetDistributionPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetFunctionPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetFunctionPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetLogDeliveryCanonicalUserIdPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetLogDeliveryCanonicalUserIdPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetOriginAccessIdentitiesPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetOriginAccessIdentitiesPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetOriginAccessIdentityPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetOriginAccessIdentityPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetOriginRequestPolicyPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetOriginRequestPolicyPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetRealtimeLogConfigPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetRealtimeLogConfigPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetResponseHeadersPolicyPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetResponseHeadersPolicyPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.outputs.GetCachePolicyResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetDistributionResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetFunctionResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetLogDeliveryCanonicalUserIdResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginAccessIdentitiesResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginAccessIdentityResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginRequestPolicyResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetRealtimeLogConfigResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicyResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.cloudfront.kotlin.outputs.GetCachePolicyResult.Companion.toKotlin as getCachePolicyResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetDistributionResult.Companion.toKotlin as getDistributionResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetFunctionResult.Companion.toKotlin as getFunctionResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetLogDeliveryCanonicalUserIdResult.Companion.toKotlin as getLogDeliveryCanonicalUserIdResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginAccessIdentitiesResult.Companion.toKotlin as getOriginAccessIdentitiesResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginAccessIdentityResult.Companion.toKotlin as getOriginAccessIdentityResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginRequestPolicyResult.Companion.toKotlin as getOriginRequestPolicyResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetRealtimeLogConfigResult.Companion.toKotlin as getRealtimeLogConfigResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicyResult.Companion.toKotlin as getResponseHeadersPolicyResultToKotlin

public object CloudfrontFunctions {
    /**
     * Use this data source to retrieve information about a CloudFront cache policy.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetCachePolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getCachePolicy(GetCachePolicyArgs.builder()
     *             .name("example-policy")
     *             .build());
     *     }
     * }
     * ```
     * ### AWS-Managed Policies
     * AWS managed cache policy names are prefixed with `Managed-`:
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetCachePolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getCachePolicy(GetCachePolicyArgs.builder()
     *             .name("Managed-CachingOptimized")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCachePolicy.
     * @return A collection of values returned by getCachePolicy.
     */
    public suspend fun getCachePolicy(argument: GetCachePolicyPlainArgs): GetCachePolicyResult =
        getCachePolicyResultToKotlin(getCachePolicyPlain(argument.toJava()).await())

    /**
     * @see [getCachePolicy].
     * @param id Identifier for the cache policy.
     * @param name Unique name to identify the cache policy.
     * @return A collection of values returned by getCachePolicy.
     */
    public suspend fun getCachePolicy(id: String? = null, name: String? = null):
        GetCachePolicyResult {
        val argument = GetCachePolicyPlainArgs(
            id = id,
            name = name,
        )
        return getCachePolicyResultToKotlin(getCachePolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getCachePolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetCachePolicyPlainArgs].
     * @return A collection of values returned by getCachePolicy.
     */
    public suspend fun getCachePolicy(argument: suspend GetCachePolicyPlainArgsBuilder.() -> Unit):
        GetCachePolicyResult {
        val builder = GetCachePolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCachePolicyResultToKotlin(getCachePolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to retrieve information about a CloudFront distribution.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetDistributionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = CloudfrontFunctions.getDistribution(GetDistributionArgs.builder()
     *             .id("EDFDVBD632BHDS5")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDistribution.
     * @return A collection of values returned by getDistribution.
     */
    public suspend fun getDistribution(argument: GetDistributionPlainArgs): GetDistributionResult =
        getDistributionResultToKotlin(getDistributionPlain(argument.toJava()).await())

    /**
     * @see [getDistribution].
     * @param id Identifier for the distribution. For example: `EDFDVBD632BHDS5`.
     * @param tags
     * @return A collection of values returned by getDistribution.
     */
    public suspend fun getDistribution(id: String, tags: Map<String, String>? = null):
        GetDistributionResult {
        val argument = GetDistributionPlainArgs(
            id = id,
            tags = tags,
        )
        return getDistributionResultToKotlin(getDistributionPlain(argument.toJava()).await())
    }

    /**
     * @see [getDistribution].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetDistributionPlainArgs].
     * @return A collection of values returned by getDistribution.
     */
    public suspend fun getDistribution(argument: suspend GetDistributionPlainArgsBuilder.() -> Unit):
        GetDistributionResult {
        val builder = GetDistributionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDistributionResultToKotlin(getDistributionPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a CloudFront Function.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetFunctionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var functionName = config.get("functionName");
     *         final var existing = CloudfrontFunctions.getFunction(GetFunctionArgs.builder()
     *             .name(functionName)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getFunction.
     * @return A collection of values returned by getFunction.
     */
    public suspend fun getFunction(argument: GetFunctionPlainArgs): GetFunctionResult =
        getFunctionResultToKotlin(getFunctionPlain(argument.toJava()).await())

    /**
     * @see [getFunction].
     * @param name Name of the CloudFront function.
     * @param stage Function’s stage, either `DEVELOPMENT` or `LIVE`.
     * @return A collection of values returned by getFunction.
     */
    public suspend fun getFunction(name: String, stage: String): GetFunctionResult {
        val argument = GetFunctionPlainArgs(
            name = name,
            stage = stage,
        )
        return getFunctionResultToKotlin(getFunctionPlain(argument.toJava()).await())
    }

    /**
     * @see [getFunction].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetFunctionPlainArgs].
     * @return A collection of values returned by getFunction.
     */
    public suspend fun getFunction(argument: suspend GetFunctionPlainArgsBuilder.() -> Unit):
        GetFunctionResult {
        val builder = GetFunctionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFunctionResultToKotlin(getFunctionPlain(builtArgument.toJava()).await())
    }

    /**
     * The CloudFront Log Delivery Canonical User ID data source allows access to the [canonical user ID](http://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html) of the AWS `awslogsdelivery` account for CloudFront bucket logging.
     * See the [Amazon CloudFront Developer Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) for more information.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetLogDeliveryCanonicalUserIdArgs;
     * import com.pulumi.aws.s3.BucketV2;
     * import com.pulumi.aws.s3.BucketAclV2;
     * import com.pulumi.aws.s3.BucketAclV2Args;
     * import com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var exampleLogDeliveryCanonicalUserId = CloudfrontFunctions.getLogDeliveryCanonicalUserId();
     *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
     *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
     *             .bucket(exampleBucketV2.id())
     *             .accessControlPolicy(BucketAclV2AccessControlPolicyArgs.builder()
     *                 .grants(BucketAclV2AccessControlPolicyGrantArgs.builder()
     *                     .grantee(BucketAclV2AccessControlPolicyGrantGranteeArgs.builder()
     *                         .id(exampleLogDeliveryCanonicalUserId.applyValue(getLogDeliveryCanonicalUserIdResult -> getLogDeliveryCanonicalUserIdResult.id()))
     *                         .type("CanonicalUser")
     *                         .build())
     *                     .permission("FULL_CONTROL")
     *                     .build())
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLogDeliveryCanonicalUserId.
     * @return A collection of values returned by getLogDeliveryCanonicalUserId.
     */
    public suspend
    fun getLogDeliveryCanonicalUserId(argument: GetLogDeliveryCanonicalUserIdPlainArgs):
        GetLogDeliveryCanonicalUserIdResult =
        getLogDeliveryCanonicalUserIdResultToKotlin(getLogDeliveryCanonicalUserIdPlain(argument.toJava()).await())

    /**
     * @see [getLogDeliveryCanonicalUserId].
     * @param region Region you'd like the zone for. By default, fetches the current region.
     * @return A collection of values returned by getLogDeliveryCanonicalUserId.
     */
    public suspend fun getLogDeliveryCanonicalUserId(region: String? = null):
        GetLogDeliveryCanonicalUserIdResult {
        val argument = GetLogDeliveryCanonicalUserIdPlainArgs(
            region = region,
        )
        return getLogDeliveryCanonicalUserIdResultToKotlin(getLogDeliveryCanonicalUserIdPlain(argument.toJava()).await())
    }

    /**
     * @see [getLogDeliveryCanonicalUserId].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetLogDeliveryCanonicalUserIdPlainArgs].
     * @return A collection of values returned by getLogDeliveryCanonicalUserId.
     */
    public suspend
    fun getLogDeliveryCanonicalUserId(argument: suspend GetLogDeliveryCanonicalUserIdPlainArgsBuilder.() -> Unit):
        GetLogDeliveryCanonicalUserIdResult {
        val builder = GetLogDeliveryCanonicalUserIdPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLogDeliveryCanonicalUserIdResultToKotlin(getLogDeliveryCanonicalUserIdPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get ARNs, ids and S3 canonical user IDs of Amazon CloudFront origin access identities.
     * ## Example Usage
     * ### All origin access identities in the account
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetOriginAccessIdentitiesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getOriginAccessIdentities();
     *     }
     * }
     * ```
     * ### Origin access identities filtered by comment/name
     * Origin access identities whose comments are `example-comment1`, `example-comment2`
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetOriginAccessIdentitiesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getOriginAccessIdentities(GetOriginAccessIdentitiesArgs.builder()
     *             .comments(
     *                 "example-comment1",
     *                 "example-comment2")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOriginAccessIdentities.
     * @return A collection of values returned by getOriginAccessIdentities.
     */
    public suspend fun getOriginAccessIdentities(argument: GetOriginAccessIdentitiesPlainArgs):
        GetOriginAccessIdentitiesResult =
        getOriginAccessIdentitiesResultToKotlin(getOriginAccessIdentitiesPlain(argument.toJava()).await())

    /**
     * @see [getOriginAccessIdentities].
     * @param comments Filter origin access identities by comment.
     * @return A collection of values returned by getOriginAccessIdentities.
     */
    public suspend fun getOriginAccessIdentities(comments: List<String>? = null):
        GetOriginAccessIdentitiesResult {
        val argument = GetOriginAccessIdentitiesPlainArgs(
            comments = comments,
        )
        return getOriginAccessIdentitiesResultToKotlin(getOriginAccessIdentitiesPlain(argument.toJava()).await())
    }

    /**
     * @see [getOriginAccessIdentities].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetOriginAccessIdentitiesPlainArgs].
     * @return A collection of values returned by getOriginAccessIdentities.
     */
    public suspend
    fun getOriginAccessIdentities(argument: suspend GetOriginAccessIdentitiesPlainArgsBuilder.() -> Unit):
        GetOriginAccessIdentitiesResult {
        val builder = GetOriginAccessIdentitiesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOriginAccessIdentitiesResultToKotlin(getOriginAccessIdentitiesPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to retrieve information for an Amazon CloudFront origin access identity.
     * ## Example Usage
     * The following example below creates a CloudFront origin access identity.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetOriginAccessIdentityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getOriginAccessIdentity(GetOriginAccessIdentityArgs.builder()
     *             .id("EDFDVBD632BHDS5")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOriginAccessIdentity.
     * @return A collection of values returned by getOriginAccessIdentity.
     */
    public suspend fun getOriginAccessIdentity(argument: GetOriginAccessIdentityPlainArgs):
        GetOriginAccessIdentityResult =
        getOriginAccessIdentityResultToKotlin(getOriginAccessIdentityPlain(argument.toJava()).await())

    /**
     * @see [getOriginAccessIdentity].
     * @param id The identifier for the distribution. For example: `EDFDVBD632BHDS5`.
     * @return A collection of values returned by getOriginAccessIdentity.
     */
    public suspend fun getOriginAccessIdentity(id: String): GetOriginAccessIdentityResult {
        val argument = GetOriginAccessIdentityPlainArgs(
            id = id,
        )
        return getOriginAccessIdentityResultToKotlin(getOriginAccessIdentityPlain(argument.toJava()).await())
    }

    /**
     * @see [getOriginAccessIdentity].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetOriginAccessIdentityPlainArgs].
     * @return A collection of values returned by getOriginAccessIdentity.
     */
    public suspend
    fun getOriginAccessIdentity(argument: suspend GetOriginAccessIdentityPlainArgsBuilder.() -> Unit):
        GetOriginAccessIdentityResult {
        val builder = GetOriginAccessIdentityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOriginAccessIdentityResultToKotlin(getOriginAccessIdentityPlain(builtArgument.toJava()).await())
    }

    /**
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetOriginRequestPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getOriginRequestPolicy(GetOriginRequestPolicyArgs.builder()
     *             .name("example-policy")
     *             .build());
     *     }
     * }
     * ```
     * ### AWS-Managed Policies
     * AWS managed origin request policy names are prefixed with `Managed-`:
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetOriginRequestPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var uaReferer = CloudfrontFunctions.getOriginRequestPolicy(GetOriginRequestPolicyArgs.builder()
     *             .name("Managed-UserAgentRefererHeaders")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOriginRequestPolicy.
     * @return A collection of values returned by getOriginRequestPolicy.
     */
    public suspend fun getOriginRequestPolicy(argument: GetOriginRequestPolicyPlainArgs):
        GetOriginRequestPolicyResult =
        getOriginRequestPolicyResultToKotlin(getOriginRequestPolicyPlain(argument.toJava()).await())

    /**
     * @see [getOriginRequestPolicy].
     * @param id Identifier for the origin request policy.
     * @param name Unique name to identify the origin request policy.
     * @return A collection of values returned by getOriginRequestPolicy.
     */
    public suspend fun getOriginRequestPolicy(id: String? = null, name: String? = null):
        GetOriginRequestPolicyResult {
        val argument = GetOriginRequestPolicyPlainArgs(
            id = id,
            name = name,
        )
        return getOriginRequestPolicyResultToKotlin(getOriginRequestPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getOriginRequestPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetOriginRequestPolicyPlainArgs].
     * @return A collection of values returned by getOriginRequestPolicy.
     */
    public suspend
    fun getOriginRequestPolicy(argument: suspend GetOriginRequestPolicyPlainArgsBuilder.() -> Unit):
        GetOriginRequestPolicyResult {
        val builder = GetOriginRequestPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOriginRequestPolicyResultToKotlin(getOriginRequestPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides a CloudFront real-time log configuration resource.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetRealtimeLogConfigArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getRealtimeLogConfig(GetRealtimeLogConfigArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRealtimeLogConfig.
     * @return A collection of values returned by getRealtimeLogConfig.
     */
    public suspend fun getRealtimeLogConfig(argument: GetRealtimeLogConfigPlainArgs):
        GetRealtimeLogConfigResult =
        getRealtimeLogConfigResultToKotlin(getRealtimeLogConfigPlain(argument.toJava()).await())

    /**
     * @see [getRealtimeLogConfig].
     * @param name Unique name to identify this real-time log configuration.
     * @return A collection of values returned by getRealtimeLogConfig.
     */
    public suspend fun getRealtimeLogConfig(name: String): GetRealtimeLogConfigResult {
        val argument = GetRealtimeLogConfigPlainArgs(
            name = name,
        )
        return getRealtimeLogConfigResultToKotlin(getRealtimeLogConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getRealtimeLogConfig].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetRealtimeLogConfigPlainArgs].
     * @return A collection of values returned by getRealtimeLogConfig.
     */
    public suspend
    fun getRealtimeLogConfig(argument: suspend GetRealtimeLogConfigPlainArgsBuilder.() -> Unit):
        GetRealtimeLogConfigResult {
        val builder = GetRealtimeLogConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRealtimeLogConfigResultToKotlin(getRealtimeLogConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to retrieve information about a CloudFront cache policy.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetResponseHeadersPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getResponseHeadersPolicy(GetResponseHeadersPolicyArgs.builder()
     *             .name("example-policy")
     *             .build());
     *     }
     * }
     * ```
     * ### AWS-Managed Policies
     * AWS managed response header policy names are prefixed with `Managed-`:
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetResponseHeadersPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getResponseHeadersPolicy(GetResponseHeadersPolicyArgs.builder()
     *             .name("Managed-SimpleCORS")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResponseHeadersPolicy.
     * @return A collection of values returned by getResponseHeadersPolicy.
     */
    public suspend fun getResponseHeadersPolicy(argument: GetResponseHeadersPolicyPlainArgs):
        GetResponseHeadersPolicyResult =
        getResponseHeadersPolicyResultToKotlin(getResponseHeadersPolicyPlain(argument.toJava()).await())

    /**
     * @see [getResponseHeadersPolicy].
     * @param id Identifier for the response headers policy.
     * @param name Unique name to identify the response headers policy.
     * @return A collection of values returned by getResponseHeadersPolicy.
     */
    public suspend fun getResponseHeadersPolicy(id: String? = null, name: String? = null):
        GetResponseHeadersPolicyResult {
        val argument = GetResponseHeadersPolicyPlainArgs(
            id = id,
            name = name,
        )
        return getResponseHeadersPolicyResultToKotlin(getResponseHeadersPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getResponseHeadersPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetResponseHeadersPolicyPlainArgs].
     * @return A collection of values returned by getResponseHeadersPolicy.
     */
    public suspend
    fun getResponseHeadersPolicy(argument: suspend GetResponseHeadersPolicyPlainArgsBuilder.() -> Unit):
        GetResponseHeadersPolicyResult {
        val builder = GetResponseHeadersPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResponseHeadersPolicyResultToKotlin(getResponseHeadersPolicyPlain(builtArgument.toJava()).await())
    }
}
