@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.kotlin.outputs.ContinuousDeploymentPolicyStagingDistributionDnsNames
import com.pulumi.aws.cloudfront.kotlin.outputs.ContinuousDeploymentPolicyTrafficConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.cloudfront.kotlin.outputs.ContinuousDeploymentPolicyStagingDistributionDnsNames.Companion.toKotlin as continuousDeploymentPolicyStagingDistributionDnsNamesToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.ContinuousDeploymentPolicyTrafficConfig.Companion.toKotlin as continuousDeploymentPolicyTrafficConfigToKotlin

/**
 * Builder for [ContinuousDeploymentPolicy].
 */
@PulumiTagMarker
public class ContinuousDeploymentPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContinuousDeploymentPolicyArgs = ContinuousDeploymentPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContinuousDeploymentPolicyArgsBuilder.() -> Unit) {
        val builder = ContinuousDeploymentPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ContinuousDeploymentPolicy {
        val builtJavaResource =
            com.pulumi.aws.cloudfront.ContinuousDeploymentPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ContinuousDeploymentPolicy(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS CloudFront Continuous Deployment Policy.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.Distribution;
 * import com.pulumi.aws.cloudfront.DistributionArgs;
 * import com.pulumi.aws.cloudfront.ContinuousDeploymentPolicy;
 * import com.pulumi.aws.cloudfront.ContinuousDeploymentPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staging = new Distribution("staging", DistributionArgs.builder()
 *             .enabled(true)
 *             .staging(true)
 *             .build());
 *         var example = new ContinuousDeploymentPolicy("example", ContinuousDeploymentPolicyArgs.builder()
 *             .enabled(true)
 *             .stagingDistributionDnsNames(ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs.builder()
 *                 .items(staging.domainName())
 *                 .quantity(1)
 *                 .build())
 *             .trafficConfig(ContinuousDeploymentPolicyTrafficConfigArgs.builder()
 *                 .type("SingleWeight")
 *                 .singleWeightConfig(ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs.builder()
 *                     .weight("0.01")
 *                     .build())
 *                 .build())
 *             .build());
 *         var production = new Distribution("production", DistributionArgs.builder()
 *             .enabled(true)
 *             .continuousDeploymentPolicyId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ### Single Weight Config with Session Stickiness
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.ContinuousDeploymentPolicy;
 * import com.pulumi.aws.cloudfront.ContinuousDeploymentPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContinuousDeploymentPolicy("example", ContinuousDeploymentPolicyArgs.builder()
 *             .enabled(true)
 *             .stagingDistributionDnsNames(ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs.builder()
 *                 .items(aws_cloudfront_distribution.staging().domain_name())
 *                 .quantity(1)
 *                 .build())
 *             .trafficConfig(ContinuousDeploymentPolicyTrafficConfigArgs.builder()
 *                 .type("SingleWeight")
 *                 .singleWeightConfig(ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs.builder()
 *                     .weight("0.01")
 *                     .sessionStickinessConfig(ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs.builder()
 *                         .idleTtl(300)
 *                         .maximumTtl(600)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Single Header Config
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.ContinuousDeploymentPolicy;
 * import com.pulumi.aws.cloudfront.ContinuousDeploymentPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContinuousDeploymentPolicy("example", ContinuousDeploymentPolicyArgs.builder()
 *             .enabled(true)
 *             .stagingDistributionDnsNames(ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs.builder()
 *                 .items(aws_cloudfront_distribution.staging().domain_name())
 *                 .quantity(1)
 *                 .build())
 *             .trafficConfig(ContinuousDeploymentPolicyTrafficConfigArgs.builder()
 *                 .type("SingleHeader")
 *                 .singleHeaderConfig(ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs.builder()
 *                     .header("aws-cf-cd-example")
 *                     .value("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudFront Continuous Deployment Policy using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/continuousDeploymentPolicy:ContinuousDeploymentPolicy example abcd-1234
 * ```
 *
 */
public class ContinuousDeploymentPolicy internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.ContinuousDeploymentPolicy,
) : KotlinCustomResource(javaResource, ContinuousDeploymentPolicyMapper) {
    /**
     * Whether this continuous deployment policy is enabled.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * Current version of the continuous distribution policy.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Date and time the continuous deployment policy was last modified.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
     */
    public val stagingDistributionDnsNames:
        Output<ContinuousDeploymentPolicyStagingDistributionDnsNames>?
        get() = javaResource.stagingDistributionDnsNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    continuousDeploymentPolicyStagingDistributionDnsNamesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
     */
    public val trafficConfig: Output<ContinuousDeploymentPolicyTrafficConfig>?
        get() = javaResource.trafficConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    continuousDeploymentPolicyTrafficConfigToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ContinuousDeploymentPolicyMapper : ResourceMapper<ContinuousDeploymentPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.ContinuousDeploymentPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ContinuousDeploymentPolicy =
        ContinuousDeploymentPolicy(
            javaResource as
                com.pulumi.aws.cloudfront.ContinuousDeploymentPolicy,
        )
}

/**
 * @see [ContinuousDeploymentPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContinuousDeploymentPolicy].
 */
public suspend fun continuousDeploymentPolicy(
    name: String,
    block: suspend ContinuousDeploymentPolicyResourceBuilder.() -> Unit,
):
    ContinuousDeploymentPolicy {
    val builder = ContinuousDeploymentPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContinuousDeploymentPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun continuousDeploymentPolicy(name: String): ContinuousDeploymentPolicy {
    val builder = ContinuousDeploymentPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
