@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.ContinuousDeploymentPolicyArgs.builder
import com.pulumi.aws.cloudfront.kotlin.inputs.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.ContinuousDeploymentPolicyTrafficConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.ContinuousDeploymentPolicyTrafficConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS CloudFront Continuous Deployment Policy.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.Distribution;
 * import com.pulumi.aws.cloudfront.DistributionArgs;
 * import com.pulumi.aws.cloudfront.ContinuousDeploymentPolicy;
 * import com.pulumi.aws.cloudfront.ContinuousDeploymentPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staging = new Distribution("staging", DistributionArgs.builder()
 *             .enabled(true)
 *             .staging(true)
 *             .build());
 *         var example = new ContinuousDeploymentPolicy("example", ContinuousDeploymentPolicyArgs.builder()
 *             .enabled(true)
 *             .stagingDistributionDnsNames(ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs.builder()
 *                 .items(staging.domainName())
 *                 .quantity(1)
 *                 .build())
 *             .trafficConfig(ContinuousDeploymentPolicyTrafficConfigArgs.builder()
 *                 .type("SingleWeight")
 *                 .singleWeightConfig(ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs.builder()
 *                     .weight("0.01")
 *                     .build())
 *                 .build())
 *             .build());
 *         var production = new Distribution("production", DistributionArgs.builder()
 *             .enabled(true)
 *             .continuousDeploymentPolicyId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ### Single Weight Config with Session Stickiness
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.ContinuousDeploymentPolicy;
 * import com.pulumi.aws.cloudfront.ContinuousDeploymentPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContinuousDeploymentPolicy("example", ContinuousDeploymentPolicyArgs.builder()
 *             .enabled(true)
 *             .stagingDistributionDnsNames(ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs.builder()
 *                 .items(aws_cloudfront_distribution.staging().domain_name())
 *                 .quantity(1)
 *                 .build())
 *             .trafficConfig(ContinuousDeploymentPolicyTrafficConfigArgs.builder()
 *                 .type("SingleWeight")
 *                 .singleWeightConfig(ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs.builder()
 *                     .weight("0.01")
 *                     .sessionStickinessConfig(ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs.builder()
 *                         .idleTtl(300)
 *                         .maximumTtl(600)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Single Header Config
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.ContinuousDeploymentPolicy;
 * import com.pulumi.aws.cloudfront.ContinuousDeploymentPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContinuousDeploymentPolicy("example", ContinuousDeploymentPolicyArgs.builder()
 *             .enabled(true)
 *             .stagingDistributionDnsNames(ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs.builder()
 *                 .items(aws_cloudfront_distribution.staging().domain_name())
 *                 .quantity(1)
 *                 .build())
 *             .trafficConfig(ContinuousDeploymentPolicyTrafficConfigArgs.builder()
 *                 .type("SingleHeader")
 *                 .singleHeaderConfig(ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs.builder()
 *                     .header("aws-cf-cd-example")
 *                     .value("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudFront Continuous Deployment Policy using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/continuousDeploymentPolicy:ContinuousDeploymentPolicy example abcd-1234
 * ```
 * @property enabled Whether this continuous deployment policy is enabled.
 * @property stagingDistributionDnsNames CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
 * @property trafficConfig Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
 */
public data class ContinuousDeploymentPolicyArgs(
    public val enabled: Output<Boolean>? = null,
    public val stagingDistributionDnsNames:
    Output<ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs>? = null,
    public val trafficConfig: Output<ContinuousDeploymentPolicyTrafficConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.ContinuousDeploymentPolicyArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.ContinuousDeploymentPolicyArgs =
        com.pulumi.aws.cloudfront.ContinuousDeploymentPolicyArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .stagingDistributionDnsNames(
                stagingDistributionDnsNames?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .trafficConfig(trafficConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ContinuousDeploymentPolicyArgs].
 */
@PulumiTagMarker
public class ContinuousDeploymentPolicyArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var stagingDistributionDnsNames:
        Output<ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs>? = null

    private var trafficConfig: Output<ContinuousDeploymentPolicyTrafficConfigArgs>? = null

    /**
     * @param value Whether this continuous deployment policy is enabled.
     */
    @JvmName("nfuxjhvwrqdjgiat")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
     */
    @JvmName("sldeqmwulvfuuphh")
    public suspend
    fun stagingDistributionDnsNames(`value`: Output<ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs>) {
        this.stagingDistributionDnsNames = value
    }

    /**
     * @param value Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
     */
    @JvmName("cxjchsmovcxcjkps")
    public suspend fun trafficConfig(`value`: Output<ContinuousDeploymentPolicyTrafficConfigArgs>) {
        this.trafficConfig = value
    }

    /**
     * @param value Whether this continuous deployment policy is enabled.
     */
    @JvmName("jsucibasvftubvge")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
     */
    @JvmName("xsakqectpqqlcmhe")
    public suspend
    fun stagingDistributionDnsNames(`value`: ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stagingDistributionDnsNames = mapped
    }

    /**
     * @param argument CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
     */
    @JvmName("vjicupqpmqswbjtc")
    public suspend
    fun stagingDistributionDnsNames(argument: suspend ContinuousDeploymentPolicyStagingDistributionDnsNamesArgsBuilder.() -> Unit) {
        val toBeMapped =
            ContinuousDeploymentPolicyStagingDistributionDnsNamesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.stagingDistributionDnsNames = mapped
    }

    /**
     * @param value Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
     */
    @JvmName("rarvwyupsbvciywx")
    public suspend fun trafficConfig(`value`: ContinuousDeploymentPolicyTrafficConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficConfig = mapped
    }

    /**
     * @param argument Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
     */
    @JvmName("xpnyadumgkstbckq")
    public suspend
    fun trafficConfig(argument: suspend ContinuousDeploymentPolicyTrafficConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ContinuousDeploymentPolicyTrafficConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.trafficConfig = mapped
    }

    internal fun build(): ContinuousDeploymentPolicyArgs = ContinuousDeploymentPolicyArgs(
        enabled = enabled,
        stagingDistributionDnsNames = stagingDistributionDnsNames,
        trafficConfig = trafficConfig,
    )
}
