@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionCustomErrorResponse
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionDefaultCacheBehavior
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionLoggingConfig
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOrderedCacheBehavior
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOrigin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOriginGroup
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionRestrictions
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionTrustedKeyGroup
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionTrustedSigner
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionViewerCertificate
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionCustomErrorResponse.Companion.toKotlin as distributionCustomErrorResponseToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionDefaultCacheBehavior.Companion.toKotlin as distributionDefaultCacheBehaviorToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionLoggingConfig.Companion.toKotlin as distributionLoggingConfigToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOrderedCacheBehavior.Companion.toKotlin as distributionOrderedCacheBehaviorToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOrigin.Companion.toKotlin as distributionOriginToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOriginGroup.Companion.toKotlin as distributionOriginGroupToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionRestrictions.Companion.toKotlin as distributionRestrictionsToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionTrustedKeyGroup.Companion.toKotlin as distributionTrustedKeyGroupToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionTrustedSigner.Companion.toKotlin as distributionTrustedSignerToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionViewerCertificate.Companion.toKotlin as distributionViewerCertificateToKotlin

/**
 * Builder for [Distribution].
 */
@PulumiTagMarker
public class DistributionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DistributionArgs = DistributionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DistributionArgsBuilder.() -> Unit) {
        val builder = DistributionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Distribution {
        val builtJavaResource = com.pulumi.aws.cloudfront.Distribution(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Distribution(builtJavaResource)
    }
}

/**
 * Creates an Amazon CloudFront web distribution.
 * For information about CloudFront distributions, see the [Amazon CloudFront Developer Guide](http://docs&#46;aws&#46;amazon&#46;com/AmazonCloudFront/latest/DeveloperGuide/Introduction&#46;html)&#46; For specific information about creating CloudFront web distributions, see the [POST Distribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html) page in the Amazon CloudFront API Reference.
 * > **NOTE:** CloudFront distributions take about 15 minutes to reach a deployed state after creation or modification. During this time, deletes to resources will be blocked. If you need to delete a distribution that is enabled and you do not want to wait, you need to use the `retain_on_delete` flag.
 * ## Example Usage
 * ### S3 Origin
 * The example below creates a CloudFront distribution with an S3 origin.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.cloudfront.Distribution;
 * import com.pulumi.aws.cloudfront.DistributionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionLoggingConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorForwardedValuesArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorForwardedValuesArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsGeoRestrictionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionViewerCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucketV2 = new BucketV2("bucketV2", BucketV2Args.builder()
 *             .tags(Map.of("Name", "My bucket"))
 *             .build());
 *         var bAcl = new BucketAclV2("bAcl", BucketAclV2Args.builder()
 *             .bucket(bucketV2.id())
 *             .acl("private")
 *             .build());
 *         final var s3OriginId = "myS3Origin";
 *         var s3Distribution = new Distribution("s3Distribution", DistributionArgs.builder()
 *             .origins(DistributionOriginArgs.builder()
 *                 .domainName(bucketV2.bucketRegionalDomainName())
 *                 .originAccessControlId(aws_cloudfront_origin_access_control.default().id())
 *                 .originId(s3OriginId)
 *                 .build())
 *             .enabled(true)
 *             .isIpv6Enabled(true)
 *             .comment("Some comment")
 *             .defaultRootObject("index.html")
 *             .loggingConfig(DistributionLoggingConfigArgs.builder()
 *                 .includeCookies(false)
 *                 .bucket("mylogs.s3.amazonaws.com")
 *                 .prefix("myprefix")
 *                 .build())
 *             .aliases(
 *                 "mysite.example.com",
 *                 "yoursite.example.com")
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .allowedMethods(
 *                     "DELETE",
 *                     "GET",
 *                     "HEAD",
 *                     "OPTIONS",
 *                     "PATCH",
 *                     "POST",
 *                     "PUT")
 *                 .cachedMethods(
 *                     "GET",
 *                     "HEAD")
 *                 .targetOriginId(s3OriginId)
 *                 .forwardedValues(DistributionDefaultCacheBehaviorForwardedValuesArgs.builder()
 *                     .queryString(false)
 *                     .cookies(DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs.builder()
 *                         .forward("none")
 *                         .build())
 *                     .build())
 *                 .viewerProtocolPolicy("allow-all")
 *                 .minTtl(0)
 *                 .defaultTtl(3600)
 *                 .maxTtl(86400)
 *                 .build())
 *             .orderedCacheBehaviors(
 *                 DistributionOrderedCacheBehaviorArgs.builder()
 *                     .pathPattern("/content/immutable/*")
 *                     .allowedMethods(
 *                         "GET",
 *                         "HEAD",
 *                         "OPTIONS")
 *                     .cachedMethods(
 *                         "GET",
 *                         "HEAD",
 *                         "OPTIONS")
 *                     .targetOriginId(s3OriginId)
 *                     .forwardedValues(DistributionOrderedCacheBehaviorForwardedValuesArgs.builder()
 *                         .queryString(false)
 *                         .headers("Origin")
 *                         .cookies(DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs.builder()
 *                             .forward("none")
 *                             .build())
 *                         .build())
 *                     .minTtl(0)
 *                     .defaultTtl(86400)
 *                     .maxTtl(31536000)
 *                     .compress(true)
 *                     .viewerProtocolPolicy("redirect-to-https")
 *                     .build(),
 *                 DistributionOrderedCacheBehaviorArgs.builder()
 *                     .pathPattern("/content/*")
 *                     .allowedMethods(
 *                         "GET",
 *                         "HEAD",
 *                         "OPTIONS")
 *                     .cachedMethods(
 *                         "GET",
 *                         "HEAD")
 *                     .targetOriginId(s3OriginId)
 *                     .forwardedValues(DistributionOrderedCacheBehaviorForwardedValuesArgs.builder()
 *                         .queryString(false)
 *                         .cookies(DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs.builder()
 *                             .forward("none")
 *                             .build())
 *                         .build())
 *                     .minTtl(0)
 *                     .defaultTtl(3600)
 *                     .maxTtl(86400)
 *                     .compress(true)
 *                     .viewerProtocolPolicy("redirect-to-https")
 *                     .build())
 *             .priceClass("PriceClass_200")
 *             .restrictions(DistributionRestrictionsArgs.builder()
 *                 .geoRestriction(DistributionRestrictionsGeoRestrictionArgs.builder()
 *                     .restrictionType("whitelist")
 *                     .locations(
 *                         "US",
 *                         "CA",
 *                         "GB",
 *                         "DE")
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Environment", "production"))
 *             .viewerCertificate(DistributionViewerCertificateArgs.builder()
 *                 .cloudfrontDefaultCertificate(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Failover Routing
 * The example below creates a CloudFront distribution with an origin group for failover routing.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.Distribution;
 * import com.pulumi.aws.cloudfront.DistributionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupFailoverCriteriaArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginS3OriginConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var s3Distribution = new Distribution("s3Distribution", DistributionArgs.builder()
 *             .originGroups(DistributionOriginGroupArgs.builder()
 *                 .originId("groupS3")
 *                 .failoverCriteria(DistributionOriginGroupFailoverCriteriaArgs.builder()
 *                     .statusCodes(
 *                         403,
 *                         404,
 *                         500,
 *                         502)
 *                     .build())
 *                 .members(
 *                     DistributionOriginGroupMemberArgs.builder()
 *                         .originId("primaryS3")
 *                         .build(),
 *                     DistributionOriginGroupMemberArgs.builder()
 *                         .originId("failoverS3")
 *                         .build())
 *                 .build())
 *             .origins(
 *                 DistributionOriginArgs.builder()
 *                     .domainName(aws_s3_bucket.primary().bucket_regional_domain_name())
 *                     .originId("primaryS3")
 *                     .s3OriginConfig(DistributionOriginS3OriginConfigArgs.builder()
 *                         .originAccessIdentity(aws_cloudfront_origin_access_identity.default().cloudfront_access_identity_path())
 *                         .build())
 *                     .build(),
 *                 DistributionOriginArgs.builder()
 *                     .domainName(aws_s3_bucket.failover().bucket_regional_domain_name())
 *                     .originId("failoverS3")
 *                     .s3OriginConfig(DistributionOriginS3OriginConfigArgs.builder()
 *                         .originAccessIdentity(aws_cloudfront_origin_access_identity.default().cloudfront_access_identity_path())
 *                         .build())
 *                     .build())
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .targetOriginId("groupS3")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Managed Caching Policy
 * The example below creates a CloudFront distribution with an [AWS managed caching policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.Distribution;
 * import com.pulumi.aws.cloudfront.DistributionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginS3OriginConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsGeoRestrictionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionViewerCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var s3OriginId = "myS3Origin";
 *         var s3Distribution = new Distribution("s3Distribution", DistributionArgs.builder()
 *             .origins(DistributionOriginArgs.builder()
 *                 .domainName(aws_s3_bucket.primary().bucket_regional_domain_name())
 *                 .originId("myS3Origin")
 *                 .s3OriginConfig(DistributionOriginS3OriginConfigArgs.builder()
 *                     .originAccessIdentity(aws_cloudfront_origin_access_identity.default().cloudfront_access_identity_path())
 *                     .build())
 *                 .build())
 *             .enabled(true)
 *             .isIpv6Enabled(true)
 *             .comment("Some comment")
 *             .defaultRootObject("index.html")
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .cachePolicyId("4135ea2d-6df8-44a3-9df3-4b5a84be39ad")
 *                 .allowedMethods(
 *                     "GET",
 *                     "HEAD",
 *                     "OPTIONS")
 *                 .targetOriginId(s3OriginId)
 *                 .build())
 *             .restrictions(DistributionRestrictionsArgs.builder()
 *                 .geoRestriction(DistributionRestrictionsGeoRestrictionArgs.builder()
 *                     .restrictionType("whitelist")
 *                     .locations(
 *                         "US",
 *                         "CA",
 *                         "GB",
 *                         "DE")
 *                     .build())
 *                 .build())
 *             .viewerCertificate(DistributionViewerCertificateArgs.builder()
 *                 .cloudfrontDefaultCertificate(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudFront Distributions using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/distribution:Distribution distribution E74FTE3EXAMPLE
 * ```
 * */*/
 */
public class Distribution internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.Distribution,
) : KotlinCustomResource(javaResource, DistributionMapper) {
    /**
     * Extra CNAMEs (alternate domain names), if any, for this distribution.
     */
    public val aliases: Output<List<String>>?
        get() = javaResource.aliases().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * ARN for the distribution. For example: `arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5`, where `123456789012` is your AWS account ID.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Internal value used by CloudFront to allow future updates to the distribution configuration.
     */
    public val callerReference: Output<String>
        get() = javaResource.callerReference().applyValue({ args0 -> args0 })

    /**
     * Any comments you want to include about the distribution.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Identifier of a continuous deployment policy. This argument should only be set on a production distribution. See the `aws.cloudfront.ContinuousDeploymentPolicy` resource for additional details.
     */
    public val continuousDeploymentPolicyId: Output<String>
        get() = javaResource.continuousDeploymentPolicyId().applyValue({ args0 -> args0 })

    /**
     * One or more custom error response elements (multiples allowed).
     */
    public val customErrorResponses: Output<List<DistributionCustomErrorResponse>>?
        get() = javaResource.customErrorResponses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        distributionCustomErrorResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Default cache behavior for this distribution (maximum one). Requires either `cache_policy_id` (preferred) or `forwarded_values` (deprecated) be set.
     */
    public val defaultCacheBehavior: Output<DistributionDefaultCacheBehavior>
        get() = javaResource.defaultCacheBehavior().applyValue({ args0 ->
            args0.let({ args0 ->
                distributionDefaultCacheBehaviorToKotlin(args0)
            })
        })

    /**
     * Object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
     */
    public val defaultRootObject: Output<String>?
        get() = javaResource.defaultRootObject().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * DNS domain name of either the S3 bucket, or web site of your custom origin.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Whether Origin Shield is enabled.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * Current version of the distribution's information. For example: `E2QWRUHAPOMQZL`.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * CloudFront Route 53 zone ID that can be used to route an [Alias Resource Record Set](http://docs.aws.amazon.com/Route53/latest/APIReference/CreateAliasRRSAPI.html) to. This attribute is simply an alias for the zone ID `Z2FDTNDATAQYW2`.
     */
    public val hostedZoneId: Output<String>
        get() = javaResource.hostedZoneId().applyValue({ args0 -> args0 })

    /**
     * Maximum HTTP version to support on the distribution. Allowed values are `http1.1`, `http2`, `http2and3` and `http3`. The default is `http2`.
     */
    public val httpVersion: Output<String>?
        get() = javaResource.httpVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of invalidation batches currently in progress.
     */
    public val inProgressValidationBatches: Output<Int>
        get() = javaResource.inProgressValidationBatches().applyValue({ args0 -> args0 })

    /**
     * Whether the IPv6 is enabled for the distribution.
     */
    public val isIpv6Enabled: Output<Boolean>?
        get() = javaResource.isIpv6Enabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date and time the distribution was last modified.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * The logging configuration that controls how logs are written to your distribution (maximum one).
     */
    public val loggingConfig: Output<DistributionLoggingConfig>?
        get() = javaResource.loggingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> distributionLoggingConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
     */
    public val orderedCacheBehaviors: Output<List<DistributionOrderedCacheBehavior>>?
        get() = javaResource.orderedCacheBehaviors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        distributionOrderedCacheBehaviorToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * One or more origin_group for this distribution (multiples allowed).
     */
    public val originGroups: Output<List<DistributionOriginGroup>>?
        get() = javaResource.originGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> distributionOriginGroupToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * One or more origins for this distribution (multiples allowed).
     */
    public val origins: Output<List<DistributionOrigin>>
        get() = javaResource.origins().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    distributionOriginToKotlin(args0)
                })
            })
        })

    /**
     * Price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100`.
     */
    public val priceClass: Output<String>?
        get() = javaResource.priceClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The restriction configuration for this distribution (maximum one).
     */
    public val restrictions: Output<DistributionRestrictions>
        get() = javaResource.restrictions().applyValue({ args0 ->
            args0.let({ args0 ->
                distributionRestrictionsToKotlin(args0)
            })
        })

    /**
     * Disables the distribution instead of deleting it when destroying the resource through the provider. If this is set, the distribution needs to be deleted manually afterwards. Default: `false`.
     */
    public val retainOnDelete: Output<Boolean>?
        get() = javaResource.retainOnDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A Boolean that indicates whether this is a staging distribution. Defaults to `false`.
     */
    public val staging: Output<Boolean>?
        get() = javaResource.staging().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Current status of the distribution. `Deployed` if the distribution's information is fully propagated throughout the Amazon CloudFront system.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * List of key group IDs that CloudFront can use to validate signed URLs or signed cookies. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    public val trustedKeyGroups: Output<List<DistributionTrustedKeyGroup>>
        get() = javaResource.trustedKeyGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> distributionTrustedKeyGroupToKotlin(args0) })
            })
        })

    /**
     * List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    public val trustedSigners: Output<List<DistributionTrustedSigner>>
        get() = javaResource.trustedSigners().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> distributionTrustedSignerToKotlin(args0) })
            })
        })

    /**
     * The SSL configuration for this distribution (maximum one).
     */
    public val viewerCertificate: Output<DistributionViewerCertificate>
        get() = javaResource.viewerCertificate().applyValue({ args0 ->
            args0.let({ args0 ->
                distributionViewerCertificateToKotlin(args0)
            })
        })

    /**
     * If enabled, the resource will wait for the distribution status to change from `InProgress` to `Deployed`. Setting this to`false` will skip the process. Default: `true`.
     */
    public val waitForDeployment: Output<Boolean>?
        get() = javaResource.waitForDeployment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of AWS WAF (WAFv2), use the ACL ARN, for example `aws_wafv2_web_acl.example.arn`. To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example `aws_waf_web_acl.example.id`. The WAF Web ACL must exist in the WAF Global (CloudFront) region and the credentials configuring this argument must have `waf:GetWebACL` permissions assigned.
     */
    public val webAclId: Output<String>?
        get() = javaResource.webAclId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object DistributionMapper : ResourceMapper<Distribution> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.Distribution::class == javaResource::class

    override fun map(javaResource: Resource): Distribution = Distribution(
        javaResource as
            com.pulumi.aws.cloudfront.Distribution,
    )
}

/**
 * @see [Distribution].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Distribution].
 */
public suspend fun distribution(
    name: String,
    block: suspend DistributionResourceBuilder.() -> Unit,
): Distribution {
    val builder = DistributionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Distribution].
 * @param name The _unique_ name of the resulting resource.
 */
public fun distribution(name: String): Distribution {
    val builder = DistributionResourceBuilder()
    builder.name(name)
    return builder.build()
}
