@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.DistributionArgs.builder
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionCustomErrorResponseArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionCustomErrorResponseArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionDefaultCacheBehaviorArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionDefaultCacheBehaviorArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionLoggingConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionLoggingConfigArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionOrderedCacheBehaviorArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionOrderedCacheBehaviorArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionOriginArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionOriginArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionOriginGroupArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionOriginGroupArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionRestrictionsArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionRestrictionsArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionViewerCertificateArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.DistributionViewerCertificateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates an Amazon CloudFront web distribution.
 * For information about CloudFront distributions, see the [Amazon CloudFront Developer Guide](http://docs&#46;aws&#46;amazon&#46;com/AmazonCloudFront/latest/DeveloperGuide/Introduction&#46;html)&#46; For specific information about creating CloudFront web distributions, see the [POST Distribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html) page in the Amazon CloudFront API Reference.
 * > **NOTE:** CloudFront distributions take about 15 minutes to reach a deployed state after creation or modification. During this time, deletes to resources will be blocked. If you need to delete a distribution that is enabled and you do not want to wait, you need to use the `retain_on_delete` flag.
 * ## Example Usage
 * ### S3 Origin
 * The example below creates a CloudFront distribution with an S3 origin.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.cloudfront.Distribution;
 * import com.pulumi.aws.cloudfront.DistributionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionLoggingConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorForwardedValuesArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorForwardedValuesArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsGeoRestrictionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionViewerCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucketV2 = new BucketV2("bucketV2", BucketV2Args.builder()
 *             .tags(Map.of("Name", "My bucket"))
 *             .build());
 *         var bAcl = new BucketAclV2("bAcl", BucketAclV2Args.builder()
 *             .bucket(bucketV2.id())
 *             .acl("private")
 *             .build());
 *         final var s3OriginId = "myS3Origin";
 *         var s3Distribution = new Distribution("s3Distribution", DistributionArgs.builder()
 *             .origins(DistributionOriginArgs.builder()
 *                 .domainName(bucketV2.bucketRegionalDomainName())
 *                 .originAccessControlId(aws_cloudfront_origin_access_control.default().id())
 *                 .originId(s3OriginId)
 *                 .build())
 *             .enabled(true)
 *             .isIpv6Enabled(true)
 *             .comment("Some comment")
 *             .defaultRootObject("index.html")
 *             .loggingConfig(DistributionLoggingConfigArgs.builder()
 *                 .includeCookies(false)
 *                 .bucket("mylogs.s3.amazonaws.com")
 *                 .prefix("myprefix")
 *                 .build())
 *             .aliases(
 *                 "mysite.example.com",
 *                 "yoursite.example.com")
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .allowedMethods(
 *                     "DELETE",
 *                     "GET",
 *                     "HEAD",
 *                     "OPTIONS",
 *                     "PATCH",
 *                     "POST",
 *                     "PUT")
 *                 .cachedMethods(
 *                     "GET",
 *                     "HEAD")
 *                 .targetOriginId(s3OriginId)
 *                 .forwardedValues(DistributionDefaultCacheBehaviorForwardedValuesArgs.builder()
 *                     .queryString(false)
 *                     .cookies(DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs.builder()
 *                         .forward("none")
 *                         .build())
 *                     .build())
 *                 .viewerProtocolPolicy("allow-all")
 *                 .minTtl(0)
 *                 .defaultTtl(3600)
 *                 .maxTtl(86400)
 *                 .build())
 *             .orderedCacheBehaviors(
 *                 DistributionOrderedCacheBehaviorArgs.builder()
 *                     .pathPattern("/content/immutable/*")
 *                     .allowedMethods(
 *                         "GET",
 *                         "HEAD",
 *                         "OPTIONS")
 *                     .cachedMethods(
 *                         "GET",
 *                         "HEAD",
 *                         "OPTIONS")
 *                     .targetOriginId(s3OriginId)
 *                     .forwardedValues(DistributionOrderedCacheBehaviorForwardedValuesArgs.builder()
 *                         .queryString(false)
 *                         .headers("Origin")
 *                         .cookies(DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs.builder()
 *                             .forward("none")
 *                             .build())
 *                         .build())
 *                     .minTtl(0)
 *                     .defaultTtl(86400)
 *                     .maxTtl(31536000)
 *                     .compress(true)
 *                     .viewerProtocolPolicy("redirect-to-https")
 *                     .build(),
 *                 DistributionOrderedCacheBehaviorArgs.builder()
 *                     .pathPattern("/content/*")
 *                     .allowedMethods(
 *                         "GET",
 *                         "HEAD",
 *                         "OPTIONS")
 *                     .cachedMethods(
 *                         "GET",
 *                         "HEAD")
 *                     .targetOriginId(s3OriginId)
 *                     .forwardedValues(DistributionOrderedCacheBehaviorForwardedValuesArgs.builder()
 *                         .queryString(false)
 *                         .cookies(DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs.builder()
 *                             .forward("none")
 *                             .build())
 *                         .build())
 *                     .minTtl(0)
 *                     .defaultTtl(3600)
 *                     .maxTtl(86400)
 *                     .compress(true)
 *                     .viewerProtocolPolicy("redirect-to-https")
 *                     .build())
 *             .priceClass("PriceClass_200")
 *             .restrictions(DistributionRestrictionsArgs.builder()
 *                 .geoRestriction(DistributionRestrictionsGeoRestrictionArgs.builder()
 *                     .restrictionType("whitelist")
 *                     .locations(
 *                         "US",
 *                         "CA",
 *                         "GB",
 *                         "DE")
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Environment", "production"))
 *             .viewerCertificate(DistributionViewerCertificateArgs.builder()
 *                 .cloudfrontDefaultCertificate(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Failover Routing
 * The example below creates a CloudFront distribution with an origin group for failover routing.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.Distribution;
 * import com.pulumi.aws.cloudfront.DistributionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupFailoverCriteriaArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginS3OriginConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var s3Distribution = new Distribution("s3Distribution", DistributionArgs.builder()
 *             .originGroups(DistributionOriginGroupArgs.builder()
 *                 .originId("groupS3")
 *                 .failoverCriteria(DistributionOriginGroupFailoverCriteriaArgs.builder()
 *                     .statusCodes(
 *                         403,
 *                         404,
 *                         500,
 *                         502)
 *                     .build())
 *                 .members(
 *                     DistributionOriginGroupMemberArgs.builder()
 *                         .originId("primaryS3")
 *                         .build(),
 *                     DistributionOriginGroupMemberArgs.builder()
 *                         .originId("failoverS3")
 *                         .build())
 *                 .build())
 *             .origins(
 *                 DistributionOriginArgs.builder()
 *                     .domainName(aws_s3_bucket.primary().bucket_regional_domain_name())
 *                     .originId("primaryS3")
 *                     .s3OriginConfig(DistributionOriginS3OriginConfigArgs.builder()
 *                         .originAccessIdentity(aws_cloudfront_origin_access_identity.default().cloudfront_access_identity_path())
 *                         .build())
 *                     .build(),
 *                 DistributionOriginArgs.builder()
 *                     .domainName(aws_s3_bucket.failover().bucket_regional_domain_name())
 *                     .originId("failoverS3")
 *                     .s3OriginConfig(DistributionOriginS3OriginConfigArgs.builder()
 *                         .originAccessIdentity(aws_cloudfront_origin_access_identity.default().cloudfront_access_identity_path())
 *                         .build())
 *                     .build())
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .targetOriginId("groupS3")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Managed Caching Policy
 * The example below creates a CloudFront distribution with an [AWS managed caching policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.Distribution;
 * import com.pulumi.aws.cloudfront.DistributionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginS3OriginConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsGeoRestrictionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionViewerCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var s3OriginId = "myS3Origin";
 *         var s3Distribution = new Distribution("s3Distribution", DistributionArgs.builder()
 *             .origins(DistributionOriginArgs.builder()
 *                 .domainName(aws_s3_bucket.primary().bucket_regional_domain_name())
 *                 .originId("myS3Origin")
 *                 .s3OriginConfig(DistributionOriginS3OriginConfigArgs.builder()
 *                     .originAccessIdentity(aws_cloudfront_origin_access_identity.default().cloudfront_access_identity_path())
 *                     .build())
 *                 .build())
 *             .enabled(true)
 *             .isIpv6Enabled(true)
 *             .comment("Some comment")
 *             .defaultRootObject("index.html")
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .cachePolicyId("4135ea2d-6df8-44a3-9df3-4b5a84be39ad")
 *                 .allowedMethods(
 *                     "GET",
 *                     "HEAD",
 *                     "OPTIONS")
 *                 .targetOriginId(s3OriginId)
 *                 .build())
 *             .restrictions(DistributionRestrictionsArgs.builder()
 *                 .geoRestriction(DistributionRestrictionsGeoRestrictionArgs.builder()
 *                     .restrictionType("whitelist")
 *                     .locations(
 *                         "US",
 *                         "CA",
 *                         "GB",
 *                         "DE")
 *                     .build())
 *                 .build())
 *             .viewerCertificate(DistributionViewerCertificateArgs.builder()
 *                 .cloudfrontDefaultCertificate(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudFront Distributions using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/distribution:Distribution distribution E74FTE3EXAMPLE
 * ```
 * @property aliases Extra CNAMEs (alternate domain names), if any, for this distribution.
 * @property comment Any comments you want to include about the distribution.
 * @property continuousDeploymentPolicyId Identifier of a continuous deployment policy. This argument should only be set on a production distribution. See the `aws.cloudfront.ContinuousDeploymentPolicy` resource for additional details.
 * @property customErrorResponses One or more custom error response elements (multiples allowed).
 * @property defaultCacheBehavior Default cache behavior for this distribution (maximum one). Requires either `cache_policy_id` (preferred) or `forwarded_values` (deprecated) be set.
 * @property defaultRootObject Object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
 * @property enabled Whether Origin Shield is enabled.
 * @property httpVersion Maximum HTTP version to support on the distribution. Allowed values are `http1.1`, `http2`, `http2and3` and `http3`. The default is `http2`.
 * @property isIpv6Enabled Whether the IPv6 is enabled for the distribution.
 * @property loggingConfig The logging configuration that controls how logs are written to your distribution (maximum one).
 * @property orderedCacheBehaviors Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
 * @property originGroups One or more origin_group for this distribution (multiples allowed).
 * @property origins One or more origins for this distribution (multiples allowed).
 * @property priceClass Price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100`.
 * @property restrictions The restriction configuration for this distribution (maximum one).
 * @property retainOnDelete Disables the distribution instead of deleting it when destroying the resource through the provider. If this is set, the distribution needs to be deleted manually afterwards. Default: `false`.
 * @property staging A Boolean that indicates whether this is a staging distribution. Defaults to `false`.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property viewerCertificate The SSL configuration for this distribution (maximum one).
 * @property waitForDeployment If enabled, the resource will wait for the distribution status to change from `InProgress` to `Deployed`. Setting this to`false` will skip the process. Default: `true`.
 * @property webAclId Unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of AWS WAF (WAFv2), use the ACL ARN, for example `aws_wafv2_web_acl.example.arn`. To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example `aws_waf_web_acl.example.id`. The WAF Web ACL must exist in the WAF Global (CloudFront) region and the credentials configuring this argument must have `waf:GetWebACL` permissions assigned.
 * */*/
 */
public data class DistributionArgs(
    public val aliases: Output<List<String>>? = null,
    public val comment: Output<String>? = null,
    public val continuousDeploymentPolicyId: Output<String>? = null,
    public val customErrorResponses: Output<List<DistributionCustomErrorResponseArgs>>? = null,
    public val defaultCacheBehavior: Output<DistributionDefaultCacheBehaviorArgs>? = null,
    public val defaultRootObject: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val httpVersion: Output<String>? = null,
    public val isIpv6Enabled: Output<Boolean>? = null,
    public val loggingConfig: Output<DistributionLoggingConfigArgs>? = null,
    public val orderedCacheBehaviors: Output<List<DistributionOrderedCacheBehaviorArgs>>? = null,
    public val originGroups: Output<List<DistributionOriginGroupArgs>>? = null,
    public val origins: Output<List<DistributionOriginArgs>>? = null,
    public val priceClass: Output<String>? = null,
    public val restrictions: Output<DistributionRestrictionsArgs>? = null,
    public val retainOnDelete: Output<Boolean>? = null,
    public val staging: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val viewerCertificate: Output<DistributionViewerCertificateArgs>? = null,
    public val waitForDeployment: Output<Boolean>? = null,
    public val webAclId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.DistributionArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.DistributionArgs =
        com.pulumi.aws.cloudfront.DistributionArgs.builder()
            .aliases(aliases?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .comment(comment?.applyValue({ args0 -> args0 }))
            .continuousDeploymentPolicyId(continuousDeploymentPolicyId?.applyValue({ args0 -> args0 }))
            .customErrorResponses(
                customErrorResponses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .defaultCacheBehavior(
                defaultCacheBehavior?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultRootObject(defaultRootObject?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .httpVersion(httpVersion?.applyValue({ args0 -> args0 }))
            .isIpv6Enabled(isIpv6Enabled?.applyValue({ args0 -> args0 }))
            .loggingConfig(loggingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .orderedCacheBehaviors(
                orderedCacheBehaviors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .originGroups(
                originGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .origins(
                origins?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .priceClass(priceClass?.applyValue({ args0 -> args0 }))
            .restrictions(restrictions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retainOnDelete(retainOnDelete?.applyValue({ args0 -> args0 }))
            .staging(staging?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .viewerCertificate(viewerCertificate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .waitForDeployment(waitForDeployment?.applyValue({ args0 -> args0 }))
            .webAclId(webAclId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionArgs].
 */
@PulumiTagMarker
public class DistributionArgsBuilder internal constructor() {
    private var aliases: Output<List<String>>? = null

    private var comment: Output<String>? = null

    private var continuousDeploymentPolicyId: Output<String>? = null

    private var customErrorResponses: Output<List<DistributionCustomErrorResponseArgs>>? = null

    private var defaultCacheBehavior: Output<DistributionDefaultCacheBehaviorArgs>? = null

    private var defaultRootObject: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var httpVersion: Output<String>? = null

    private var isIpv6Enabled: Output<Boolean>? = null

    private var loggingConfig: Output<DistributionLoggingConfigArgs>? = null

    private var orderedCacheBehaviors: Output<List<DistributionOrderedCacheBehaviorArgs>>? = null

    private var originGroups: Output<List<DistributionOriginGroupArgs>>? = null

    private var origins: Output<List<DistributionOriginArgs>>? = null

    private var priceClass: Output<String>? = null

    private var restrictions: Output<DistributionRestrictionsArgs>? = null

    private var retainOnDelete: Output<Boolean>? = null

    private var staging: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var viewerCertificate: Output<DistributionViewerCertificateArgs>? = null

    private var waitForDeployment: Output<Boolean>? = null

    private var webAclId: Output<String>? = null

    /**
     * @param value Extra CNAMEs (alternate domain names), if any, for this distribution.
     */
    @JvmName("puvdsydwuxgtcqmk")
    public suspend fun aliases(`value`: Output<List<String>>) {
        this.aliases = value
    }

    @JvmName("okdcappoyqwdckja")
    public suspend fun aliases(vararg values: Output<String>) {
        this.aliases = Output.all(values.asList())
    }

    /**
     * @param values Extra CNAMEs (alternate domain names), if any, for this distribution.
     */
    @JvmName("mhmfpdnjwpivikub")
    public suspend fun aliases(values: List<Output<String>>) {
        this.aliases = Output.all(values)
    }

    /**
     * @param value Any comments you want to include about the distribution.
     */
    @JvmName("egubxbgnmyvkxbqf")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Identifier of a continuous deployment policy. This argument should only be set on a production distribution. See the `aws.cloudfront.ContinuousDeploymentPolicy` resource for additional details.
     */
    @JvmName("lgqiwnlswjcnqxsk")
    public suspend fun continuousDeploymentPolicyId(`value`: Output<String>) {
        this.continuousDeploymentPolicyId = value
    }

    /**
     * @param value One or more custom error response elements (multiples allowed).
     */
    @JvmName("aduekpurseurhdwe")
    public suspend
    fun customErrorResponses(`value`: Output<List<DistributionCustomErrorResponseArgs>>) {
        this.customErrorResponses = value
    }

    @JvmName("bkkkcygnvgrnysrq")
    public suspend fun customErrorResponses(
        vararg
        values: Output<DistributionCustomErrorResponseArgs>,
    ) {
        this.customErrorResponses = Output.all(values.asList())
    }

    /**
     * @param values One or more custom error response elements (multiples allowed).
     */
    @JvmName("wqmhqhcqdikxwpyf")
    public suspend
    fun customErrorResponses(values: List<Output<DistributionCustomErrorResponseArgs>>) {
        this.customErrorResponses = Output.all(values)
    }

    /**
     * @param value Default cache behavior for this distribution (maximum one). Requires either `cache_policy_id` (preferred) or `forwarded_values` (deprecated) be set.
     */
    @JvmName("eufybtefchdvwwya")
    public suspend fun defaultCacheBehavior(`value`: Output<DistributionDefaultCacheBehaviorArgs>) {
        this.defaultCacheBehavior = value
    }

    /**
     * @param value Object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
     */
    @JvmName("dhmwgajawhmdhjyu")
    public suspend fun defaultRootObject(`value`: Output<String>) {
        this.defaultRootObject = value
    }

    /**
     * @param value Whether Origin Shield is enabled.
     */
    @JvmName("ppydnehayuwdpeqs")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Maximum HTTP version to support on the distribution. Allowed values are `http1.1`, `http2`, `http2and3` and `http3`. The default is `http2`.
     */
    @JvmName("glqernjocwtnbdnu")
    public suspend fun httpVersion(`value`: Output<String>) {
        this.httpVersion = value
    }

    /**
     * @param value Whether the IPv6 is enabled for the distribution.
     */
    @JvmName("yhwhrpgjrmvlcbwc")
    public suspend fun isIpv6Enabled(`value`: Output<Boolean>) {
        this.isIpv6Enabled = value
    }

    /**
     * @param value The logging configuration that controls how logs are written to your distribution (maximum one).
     */
    @JvmName("ynfbeusbrdkwnnsm")
    public suspend fun loggingConfig(`value`: Output<DistributionLoggingConfigArgs>) {
        this.loggingConfig = value
    }

    /**
     * @param value Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
     */
    @JvmName("pebryrqgtaxronfq")
    public suspend
    fun orderedCacheBehaviors(`value`: Output<List<DistributionOrderedCacheBehaviorArgs>>) {
        this.orderedCacheBehaviors = value
    }

    @JvmName("glfsjpigvskmhxlc")
    public suspend fun orderedCacheBehaviors(
        vararg
        values: Output<DistributionOrderedCacheBehaviorArgs>,
    ) {
        this.orderedCacheBehaviors = Output.all(values.asList())
    }

    /**
     * @param values Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
     */
    @JvmName("qywxjqvowgvrjpcg")
    public suspend
    fun orderedCacheBehaviors(values: List<Output<DistributionOrderedCacheBehaviorArgs>>) {
        this.orderedCacheBehaviors = Output.all(values)
    }

    /**
     * @param value One or more origin_group for this distribution (multiples allowed).
     */
    @JvmName("umqgelvutshvmkhe")
    public suspend fun originGroups(`value`: Output<List<DistributionOriginGroupArgs>>) {
        this.originGroups = value
    }

    @JvmName("kfvefxlplehvbvae")
    public suspend fun originGroups(vararg values: Output<DistributionOriginGroupArgs>) {
        this.originGroups = Output.all(values.asList())
    }

    /**
     * @param values One or more origin_group for this distribution (multiples allowed).
     */
    @JvmName("fycddxtyohsfefcx")
    public suspend fun originGroups(values: List<Output<DistributionOriginGroupArgs>>) {
        this.originGroups = Output.all(values)
    }

    /**
     * @param value One or more origins for this distribution (multiples allowed).
     */
    @JvmName("ntkuogyxjnlvomvl")
    public suspend fun origins(`value`: Output<List<DistributionOriginArgs>>) {
        this.origins = value
    }

    @JvmName("edqilveygbaygubl")
    public suspend fun origins(vararg values: Output<DistributionOriginArgs>) {
        this.origins = Output.all(values.asList())
    }

    /**
     * @param values One or more origins for this distribution (multiples allowed).
     */
    @JvmName("bpuwbjbheboffbsu")
    public suspend fun origins(values: List<Output<DistributionOriginArgs>>) {
        this.origins = Output.all(values)
    }

    /**
     * @param value Price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100`.
     */
    @JvmName("arjeltwgbbkadrqc")
    public suspend fun priceClass(`value`: Output<String>) {
        this.priceClass = value
    }

    /**
     * @param value The restriction configuration for this distribution (maximum one).
     */
    @JvmName("blqdxurlhtsrunby")
    public suspend fun restrictions(`value`: Output<DistributionRestrictionsArgs>) {
        this.restrictions = value
    }

    /**
     * @param value Disables the distribution instead of deleting it when destroying the resource through the provider. If this is set, the distribution needs to be deleted manually afterwards. Default: `false`.
     */
    @JvmName("sebfwsnmyachtrfl")
    public suspend fun retainOnDelete(`value`: Output<Boolean>) {
        this.retainOnDelete = value
    }

    /**
     * @param value A Boolean that indicates whether this is a staging distribution. Defaults to `false`.
     */
    @JvmName("pvwjnfbvyitbxmwc")
    public suspend fun staging(`value`: Output<Boolean>) {
        this.staging = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nvbnvtbsbrxhtkyj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The SSL configuration for this distribution (maximum one).
     */
    @JvmName("dwrrhnqokdsqbfyp")
    public suspend fun viewerCertificate(`value`: Output<DistributionViewerCertificateArgs>) {
        this.viewerCertificate = value
    }

    /**
     * @param value If enabled, the resource will wait for the distribution status to change from `InProgress` to `Deployed`. Setting this to`false` will skip the process. Default: `true`.
     */
    @JvmName("yxktjcbscileuewv")
    public suspend fun waitForDeployment(`value`: Output<Boolean>) {
        this.waitForDeployment = value
    }

    /**
     * @param value Unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of AWS WAF (WAFv2), use the ACL ARN, for example `aws_wafv2_web_acl.example.arn`. To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example `aws_waf_web_acl.example.id`. The WAF Web ACL must exist in the WAF Global (CloudFront) region and the credentials configuring this argument must have `waf:GetWebACL` permissions assigned.
     */
    @JvmName("cogemvhdubbmmgou")
    public suspend fun webAclId(`value`: Output<String>) {
        this.webAclId = value
    }

    /**
     * @param value Extra CNAMEs (alternate domain names), if any, for this distribution.
     */
    @JvmName("ysxjsaimhjvssdpy")
    public suspend fun aliases(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliases = mapped
    }

    /**
     * @param values Extra CNAMEs (alternate domain names), if any, for this distribution.
     */
    @JvmName("phtjcfhyyvapnjix")
    public suspend fun aliases(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aliases = mapped
    }

    /**
     * @param value Any comments you want to include about the distribution.
     */
    @JvmName("eyyyksyhgpmjvhuc")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Identifier of a continuous deployment policy. This argument should only be set on a production distribution. See the `aws.cloudfront.ContinuousDeploymentPolicy` resource for additional details.
     */
    @JvmName("mekfyipybnuorbps")
    public suspend fun continuousDeploymentPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.continuousDeploymentPolicyId = mapped
    }

    /**
     * @param value One or more custom error response elements (multiples allowed).
     */
    @JvmName("uqcpkwraxgvnblav")
    public suspend fun customErrorResponses(`value`: List<DistributionCustomErrorResponseArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customErrorResponses = mapped
    }

    /**
     * @param argument One or more custom error response elements (multiples allowed).
     */
    @JvmName("kwqeauiaqevmiugo")
    public suspend
    fun customErrorResponses(argument: List<suspend DistributionCustomErrorResponseArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionCustomErrorResponseArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customErrorResponses = mapped
    }

    /**
     * @param argument One or more custom error response elements (multiples allowed).
     */
    @JvmName("cnyxjgfrcsgmopqr")
    public suspend fun customErrorResponses(
        vararg
        argument: suspend DistributionCustomErrorResponseArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DistributionCustomErrorResponseArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customErrorResponses = mapped
    }

    /**
     * @param argument One or more custom error response elements (multiples allowed).
     */
    @JvmName("qubdqprxstkshqeu")
    public suspend
    fun customErrorResponses(argument: suspend DistributionCustomErrorResponseArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DistributionCustomErrorResponseArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customErrorResponses = mapped
    }

    /**
     * @param values One or more custom error response elements (multiples allowed).
     */
    @JvmName("trluwjpuimhdqbfw")
    public suspend fun customErrorResponses(vararg values: DistributionCustomErrorResponseArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customErrorResponses = mapped
    }

    /**
     * @param value Default cache behavior for this distribution (maximum one). Requires either `cache_policy_id` (preferred) or `forwarded_values` (deprecated) be set.
     */
    @JvmName("qxmkgigkvuptnhhy")
    public suspend fun defaultCacheBehavior(`value`: DistributionDefaultCacheBehaviorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultCacheBehavior = mapped
    }

    /**
     * @param argument Default cache behavior for this distribution (maximum one). Requires either `cache_policy_id` (preferred) or `forwarded_values` (deprecated) be set.
     */
    @JvmName("qxhhgedjyrhddoqq")
    public suspend
    fun defaultCacheBehavior(argument: suspend DistributionDefaultCacheBehaviorArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionDefaultCacheBehaviorArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.defaultCacheBehavior = mapped
    }

    /**
     * @param value Object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
     */
    @JvmName("neojjrylcegtdsvh")
    public suspend fun defaultRootObject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRootObject = mapped
    }

    /**
     * @param value Whether Origin Shield is enabled.
     */
    @JvmName("jifibpplrepedqbv")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Maximum HTTP version to support on the distribution. Allowed values are `http1.1`, `http2`, `http2and3` and `http3`. The default is `http2`.
     */
    @JvmName("rvhnwrkqmexyjtmg")
    public suspend fun httpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpVersion = mapped
    }

    /**
     * @param value Whether the IPv6 is enabled for the distribution.
     */
    @JvmName("kybfiibhjlopardm")
    public suspend fun isIpv6Enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isIpv6Enabled = mapped
    }

    /**
     * @param value The logging configuration that controls how logs are written to your distribution (maximum one).
     */
    @JvmName("kfrjmsehyrukinbh")
    public suspend fun loggingConfig(`value`: DistributionLoggingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingConfig = mapped
    }

    /**
     * @param argument The logging configuration that controls how logs are written to your distribution (maximum one).
     */
    @JvmName("fwpgwevmppgeabxa")
    public suspend
    fun loggingConfig(argument: suspend DistributionLoggingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionLoggingConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loggingConfig = mapped
    }

    /**
     * @param value Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
     */
    @JvmName("icoqbddudtvpldig")
    public suspend fun orderedCacheBehaviors(`value`: List<DistributionOrderedCacheBehaviorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderedCacheBehaviors = mapped
    }

    /**
     * @param argument Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
     */
    @JvmName("yipgevaiiroqrjhq")
    public suspend
    fun orderedCacheBehaviors(argument: List<suspend DistributionOrderedCacheBehaviorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionOrderedCacheBehaviorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.orderedCacheBehaviors = mapped
    }

    /**
     * @param argument Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
     */
    @JvmName("gabdnoojnqkegynu")
    public suspend fun orderedCacheBehaviors(
        vararg
        argument: suspend DistributionOrderedCacheBehaviorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DistributionOrderedCacheBehaviorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.orderedCacheBehaviors = mapped
    }

    /**
     * @param argument Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
     */
    @JvmName("calrunkedyjqcure")
    public suspend
    fun orderedCacheBehaviors(argument: suspend DistributionOrderedCacheBehaviorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DistributionOrderedCacheBehaviorArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.orderedCacheBehaviors = mapped
    }

    /**
     * @param values Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
     */
    @JvmName("mtafnuqygqxfkbsm")
    public suspend fun orderedCacheBehaviors(vararg values: DistributionOrderedCacheBehaviorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orderedCacheBehaviors = mapped
    }

    /**
     * @param value One or more origin_group for this distribution (multiples allowed).
     */
    @JvmName("ungsbqfkmhqmntav")
    public suspend fun originGroups(`value`: List<DistributionOriginGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originGroups = mapped
    }

    /**
     * @param argument One or more origin_group for this distribution (multiples allowed).
     */
    @JvmName("oxoitwxeevyjnoyl")
    public suspend
    fun originGroups(argument: List<suspend DistributionOriginGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionOriginGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.originGroups = mapped
    }

    /**
     * @param argument One or more origin_group for this distribution (multiples allowed).
     */
    @JvmName("rvbivyhnbwsqeynu")
    public suspend fun originGroups(
        vararg
        argument: suspend DistributionOriginGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DistributionOriginGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.originGroups = mapped
    }

    /**
     * @param argument One or more origin_group for this distribution (multiples allowed).
     */
    @JvmName("uttkjtrjgcvgebev")
    public suspend fun originGroups(argument: suspend DistributionOriginGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DistributionOriginGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.originGroups = mapped
    }

    /**
     * @param values One or more origin_group for this distribution (multiples allowed).
     */
    @JvmName("bhdkampqubkfnljc")
    public suspend fun originGroups(vararg values: DistributionOriginGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.originGroups = mapped
    }

    /**
     * @param value One or more origins for this distribution (multiples allowed).
     */
    @JvmName("acdwlakkkftakdvo")
    public suspend fun origins(`value`: List<DistributionOriginArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.origins = mapped
    }

    /**
     * @param argument One or more origins for this distribution (multiples allowed).
     */
    @JvmName("ofnhnctanqmbyhij")
    public suspend fun origins(argument: List<suspend DistributionOriginArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionOriginArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.origins = mapped
    }

    /**
     * @param argument One or more origins for this distribution (multiples allowed).
     */
    @JvmName("pmpcavumxwtiswtl")
    public suspend fun origins(vararg argument: suspend DistributionOriginArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DistributionOriginArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.origins = mapped
    }

    /**
     * @param argument One or more origins for this distribution (multiples allowed).
     */
    @JvmName("sadjwbhofjsyphle")
    public suspend fun origins(argument: suspend DistributionOriginArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DistributionOriginArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.origins = mapped
    }

    /**
     * @param values One or more origins for this distribution (multiples allowed).
     */
    @JvmName("oiuhrnernhgedoai")
    public suspend fun origins(vararg values: DistributionOriginArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.origins = mapped
    }

    /**
     * @param value Price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100`.
     */
    @JvmName("nrhmngwiuwavivoj")
    public suspend fun priceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priceClass = mapped
    }

    /**
     * @param value The restriction configuration for this distribution (maximum one).
     */
    @JvmName("pfqtrkboobvspjwr")
    public suspend fun restrictions(`value`: DistributionRestrictionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restrictions = mapped
    }

    /**
     * @param argument The restriction configuration for this distribution (maximum one).
     */
    @JvmName("sitkhdxirqfwxbdc")
    public suspend
    fun restrictions(argument: suspend DistributionRestrictionsArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionRestrictionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.restrictions = mapped
    }

    /**
     * @param value Disables the distribution instead of deleting it when destroying the resource through the provider. If this is set, the distribution needs to be deleted manually afterwards. Default: `false`.
     */
    @JvmName("nbgbyvijnmytigmu")
    public suspend fun retainOnDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainOnDelete = mapped
    }

    /**
     * @param value A Boolean that indicates whether this is a staging distribution. Defaults to `false`.
     */
    @JvmName("mlusbuupuvecvgxo")
    public suspend fun staging(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staging = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tpmxtvybjuffradw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("swedkdxuvcbsrdkf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The SSL configuration for this distribution (maximum one).
     */
    @JvmName("limhvydfciscbrmk")
    public suspend fun viewerCertificate(`value`: DistributionViewerCertificateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.viewerCertificate = mapped
    }

    /**
     * @param argument The SSL configuration for this distribution (maximum one).
     */
    @JvmName("hbklyxkhulittgnp")
    public suspend
    fun viewerCertificate(argument: suspend DistributionViewerCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionViewerCertificateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.viewerCertificate = mapped
    }

    /**
     * @param value If enabled, the resource will wait for the distribution status to change from `InProgress` to `Deployed`. Setting this to`false` will skip the process. Default: `true`.
     */
    @JvmName("rnpgllrowjnpsfye")
    public suspend fun waitForDeployment(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForDeployment = mapped
    }

    /**
     * @param value Unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of AWS WAF (WAFv2), use the ACL ARN, for example `aws_wafv2_web_acl.example.arn`. To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example `aws_waf_web_acl.example.id`. The WAF Web ACL must exist in the WAF Global (CloudFront) region and the credentials configuring this argument must have `waf:GetWebACL` permissions assigned.
     */
    @JvmName("cuflhruvvbdmqava")
    public suspend fun webAclId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webAclId = mapped
    }

    internal fun build(): DistributionArgs = DistributionArgs(
        aliases = aliases,
        comment = comment,
        continuousDeploymentPolicyId = continuousDeploymentPolicyId,
        customErrorResponses = customErrorResponses,
        defaultCacheBehavior = defaultCacheBehavior,
        defaultRootObject = defaultRootObject,
        enabled = enabled,
        httpVersion = httpVersion,
        isIpv6Enabled = isIpv6Enabled,
        loggingConfig = loggingConfig,
        orderedCacheBehaviors = orderedCacheBehaviors,
        originGroups = originGroups,
        origins = origins,
        priceClass = priceClass,
        restrictions = restrictions,
        retainOnDelete = retainOnDelete,
        staging = staging,
        tags = tags,
        viewerCertificate = viewerCertificate,
        waitForDeployment = waitForDeployment,
        webAclId = webAclId,
    )
}
