@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.kotlin.outputs.FieldLevelEncryptionConfigContentTypeProfileConfig
import com.pulumi.aws.cloudfront.kotlin.outputs.FieldLevelEncryptionConfigQueryArgProfileConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.cloudfront.kotlin.outputs.FieldLevelEncryptionConfigContentTypeProfileConfig.Companion.toKotlin as fieldLevelEncryptionConfigContentTypeProfileConfigToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.FieldLevelEncryptionConfigQueryArgProfileConfig.Companion.toKotlin as fieldLevelEncryptionConfigQueryArgProfileConfigToKotlin

/**
 * Builder for [FieldLevelEncryptionConfig].
 */
@PulumiTagMarker
public class FieldLevelEncryptionConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FieldLevelEncryptionConfigArgs = FieldLevelEncryptionConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FieldLevelEncryptionConfigArgsBuilder.() -> Unit) {
        val builder = FieldLevelEncryptionConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FieldLevelEncryptionConfig {
        val builtJavaResource =
            com.pulumi.aws.cloudfront.FieldLevelEncryptionConfig(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FieldLevelEncryptionConfig(builtJavaResource)
    }
}

/**
 * Provides a CloudFront Field-level Encryption Config resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.FieldLevelEncryptionConfig;
 * import com.pulumi.aws.cloudfront.FieldLevelEncryptionConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new FieldLevelEncryptionConfig("test", FieldLevelEncryptionConfigArgs.builder()
 *             .comment("test comment")
 *             .contentTypeProfileConfig(FieldLevelEncryptionConfigContentTypeProfileConfigArgs.builder()
 *                 .forwardWhenContentTypeIsUnknown(true)
 *                 .contentTypeProfiles(FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesArgs.builder()
 *                     .items(FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItemArgs.builder()
 *                         .contentType("application/x-www-form-urlencoded")
 *                         .format("URLEncoded")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .queryArgProfileConfig(FieldLevelEncryptionConfigQueryArgProfileConfigArgs.builder()
 *                 .forwardWhenQueryArgProfileIsUnknown(true)
 *                 .queryArgProfiles(FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesArgs.builder()
 *                     .items(FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesItemArgs.builder()
 *                         .profileId(aws_cloudfront_field_level_encryption_profile.test().id())
 *                         .queryArg("Arg1")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cloudfront Field Level Encryption Config using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/fieldLevelEncryptionConfig:FieldLevelEncryptionConfig config E74FTE3AEXAMPLE
 * ```
 *
 */
public class FieldLevelEncryptionConfig internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.FieldLevelEncryptionConfig,
) : KotlinCustomResource(javaResource, FieldLevelEncryptionConfigMapper) {
    /**
     * Internal value used by CloudFront to allow future updates to the Field Level Encryption Config.
     */
    public val callerReference: Output<String>
        get() = javaResource.callerReference().applyValue({ args0 -> args0 })

    /**
     * An optional comment about the Field Level Encryption Config.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Content Type Profile Config specifies when to forward content if a content type isn't recognized and profiles to use as by default in a request if a query argument doesn't specify a profile to use.
     */
    public val contentTypeProfileConfig: Output<FieldLevelEncryptionConfigContentTypeProfileConfig>
        get() = javaResource.contentTypeProfileConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                fieldLevelEncryptionConfigContentTypeProfileConfigToKotlin(args0)
            })
        })

    /**
     * The current version of the Field Level Encryption Config. For example: `E2QWRUHAPOMQZL`.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Query Arg Profile Config that specifies when to forward content if a profile isn't found and the profile that can be provided as a query argument in a request.
     */
    public val queryArgProfileConfig: Output<FieldLevelEncryptionConfigQueryArgProfileConfig>
        get() = javaResource.queryArgProfileConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                fieldLevelEncryptionConfigQueryArgProfileConfigToKotlin(args0)
            })
        })
}

public object FieldLevelEncryptionConfigMapper : ResourceMapper<FieldLevelEncryptionConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.FieldLevelEncryptionConfig::class == javaResource::class

    override fun map(javaResource: Resource): FieldLevelEncryptionConfig =
        FieldLevelEncryptionConfig(
            javaResource as
                com.pulumi.aws.cloudfront.FieldLevelEncryptionConfig,
        )
}

/**
 * @see [FieldLevelEncryptionConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FieldLevelEncryptionConfig].
 */
public suspend fun fieldLevelEncryptionConfig(
    name: String,
    block: suspend FieldLevelEncryptionConfigResourceBuilder.() -> Unit,
):
    FieldLevelEncryptionConfig {
    val builder = FieldLevelEncryptionConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FieldLevelEncryptionConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fieldLevelEncryptionConfig(name: String): FieldLevelEncryptionConfig {
    val builder = FieldLevelEncryptionConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
