@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.FieldLevelEncryptionConfigArgs.builder
import com.pulumi.aws.cloudfront.kotlin.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a CloudFront Field-level Encryption Config resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.FieldLevelEncryptionConfig;
 * import com.pulumi.aws.cloudfront.FieldLevelEncryptionConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new FieldLevelEncryptionConfig("test", FieldLevelEncryptionConfigArgs.builder()
 *             .comment("test comment")
 *             .contentTypeProfileConfig(FieldLevelEncryptionConfigContentTypeProfileConfigArgs.builder()
 *                 .forwardWhenContentTypeIsUnknown(true)
 *                 .contentTypeProfiles(FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesArgs.builder()
 *                     .items(FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItemArgs.builder()
 *                         .contentType("application/x-www-form-urlencoded")
 *                         .format("URLEncoded")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .queryArgProfileConfig(FieldLevelEncryptionConfigQueryArgProfileConfigArgs.builder()
 *                 .forwardWhenQueryArgProfileIsUnknown(true)
 *                 .queryArgProfiles(FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesArgs.builder()
 *                     .items(FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesItemArgs.builder()
 *                         .profileId(aws_cloudfront_field_level_encryption_profile.test().id())
 *                         .queryArg("Arg1")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cloudfront Field Level Encryption Config using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/fieldLevelEncryptionConfig:FieldLevelEncryptionConfig config E74FTE3AEXAMPLE
 * ```
 * @property comment An optional comment about the Field Level Encryption Config.
 * @property contentTypeProfileConfig Content Type Profile Config specifies when to forward content if a content type isn't recognized and profiles to use as by default in a request if a query argument doesn't specify a profile to use.
 * @property queryArgProfileConfig Query Arg Profile Config that specifies when to forward content if a profile isn't found and the profile that can be provided as a query argument in a request.
 */
public data class FieldLevelEncryptionConfigArgs(
    public val comment: Output<String>? = null,
    public val contentTypeProfileConfig:
    Output<FieldLevelEncryptionConfigContentTypeProfileConfigArgs>? = null,
    public val queryArgProfileConfig: Output<FieldLevelEncryptionConfigQueryArgProfileConfigArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.FieldLevelEncryptionConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.FieldLevelEncryptionConfigArgs =
        com.pulumi.aws.cloudfront.FieldLevelEncryptionConfigArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .contentTypeProfileConfig(
                contentTypeProfileConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .queryArgProfileConfig(
                queryArgProfileConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FieldLevelEncryptionConfigArgs].
 */
@PulumiTagMarker
public class FieldLevelEncryptionConfigArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var contentTypeProfileConfig:
        Output<FieldLevelEncryptionConfigContentTypeProfileConfigArgs>? = null

    private var queryArgProfileConfig: Output<FieldLevelEncryptionConfigQueryArgProfileConfigArgs>? =
        null

    /**
     * @param value An optional comment about the Field Level Encryption Config.
     */
    @JvmName("kufuubqpcycdkpxh")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Content Type Profile Config specifies when to forward content if a content type isn't recognized and profiles to use as by default in a request if a query argument doesn't specify a profile to use.
     */
    @JvmName("vciksvtwnbbjggre")
    public suspend
    fun contentTypeProfileConfig(`value`: Output<FieldLevelEncryptionConfigContentTypeProfileConfigArgs>) {
        this.contentTypeProfileConfig = value
    }

    /**
     * @param value Query Arg Profile Config that specifies when to forward content if a profile isn't found and the profile that can be provided as a query argument in a request.
     */
    @JvmName("xmjdurskmsjvejlm")
    public suspend
    fun queryArgProfileConfig(`value`: Output<FieldLevelEncryptionConfigQueryArgProfileConfigArgs>) {
        this.queryArgProfileConfig = value
    }

    /**
     * @param value An optional comment about the Field Level Encryption Config.
     */
    @JvmName("xdhihmrnqauhfsfj")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Content Type Profile Config specifies when to forward content if a content type isn't recognized and profiles to use as by default in a request if a query argument doesn't specify a profile to use.
     */
    @JvmName("bhphlntfecospwty")
    public suspend
    fun contentTypeProfileConfig(`value`: FieldLevelEncryptionConfigContentTypeProfileConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentTypeProfileConfig = mapped
    }

    /**
     * @param argument Content Type Profile Config specifies when to forward content if a content type isn't recognized and profiles to use as by default in a request if a query argument doesn't specify a profile to use.
     */
    @JvmName("hfltexfldawxdaxd")
    public suspend
    fun contentTypeProfileConfig(argument: suspend FieldLevelEncryptionConfigContentTypeProfileConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FieldLevelEncryptionConfigContentTypeProfileConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.contentTypeProfileConfig = mapped
    }

    /**
     * @param value Query Arg Profile Config that specifies when to forward content if a profile isn't found and the profile that can be provided as a query argument in a request.
     */
    @JvmName("lxbgddefbsfpytrp")
    public suspend
    fun queryArgProfileConfig(`value`: FieldLevelEncryptionConfigQueryArgProfileConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryArgProfileConfig = mapped
    }

    /**
     * @param argument Query Arg Profile Config that specifies when to forward content if a profile isn't found and the profile that can be provided as a query argument in a request.
     */
    @JvmName("fxmlfubyixgvxagv")
    public suspend
    fun queryArgProfileConfig(argument: suspend FieldLevelEncryptionConfigQueryArgProfileConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FieldLevelEncryptionConfigQueryArgProfileConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.queryArgProfileConfig = mapped
    }

    internal fun build(): FieldLevelEncryptionConfigArgs = FieldLevelEncryptionConfigArgs(
        comment = comment,
        contentTypeProfileConfig = contentTypeProfileConfig,
        queryArgProfileConfig = queryArgProfileConfig,
    )
}
