@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.FieldLevelEncryptionProfileArgs.builder
import com.pulumi.aws.cloudfront.kotlin.inputs.FieldLevelEncryptionProfileEncryptionEntitiesArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.FieldLevelEncryptionProfileEncryptionEntitiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a CloudFront Field-level Encryption Profile resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.PublicKey;
 * import com.pulumi.aws.cloudfront.PublicKeyArgs;
 * import com.pulumi.aws.cloudfront.FieldLevelEncryptionProfile;
 * import com.pulumi.aws.cloudfront.FieldLevelEncryptionProfileArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionProfileEncryptionEntitiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PublicKey("example", PublicKeyArgs.builder()
 *             .comment("test public key")
 *             .encodedKey(Files.readString(Paths.get("public_key.pem")))
 *             .build());
 *         var test = new FieldLevelEncryptionProfile("test", FieldLevelEncryptionProfileArgs.builder()
 *             .comment("test comment")
 *             .encryptionEntities(FieldLevelEncryptionProfileEncryptionEntitiesArgs.builder()
 *                 .items(FieldLevelEncryptionProfileEncryptionEntitiesItemArgs.builder()
 *                     .publicKeyId(example.id())
 *                     .providerId("test provider")
 *                     .fieldPatterns(FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatternsArgs.builder()
 *                         .items("DateOfBirth")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cloudfront Field Level Encryption Profile using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/fieldLevelEncryptionProfile:FieldLevelEncryptionProfile profile K3D5EWEUDCCXON
 * ```
 * @property comment An optional comment about the Field Level Encryption Profile.
 * @property encryptionEntities The encryption entities config block for field-level encryption profiles that contains an attribute `items` which includes the encryption key and field pattern specifications.
 * @property name The name of the Field Level Encryption Profile.
 */
public data class FieldLevelEncryptionProfileArgs(
    public val comment: Output<String>? = null,
    public val encryptionEntities: Output<FieldLevelEncryptionProfileEncryptionEntitiesArgs>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.FieldLevelEncryptionProfileArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.FieldLevelEncryptionProfileArgs =
        com.pulumi.aws.cloudfront.FieldLevelEncryptionProfileArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .encryptionEntities(
                encryptionEntities?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FieldLevelEncryptionProfileArgs].
 */
@PulumiTagMarker
public class FieldLevelEncryptionProfileArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var encryptionEntities: Output<FieldLevelEncryptionProfileEncryptionEntitiesArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value An optional comment about the Field Level Encryption Profile.
     */
    @JvmName("ivexrapgndtnuwcb")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value The encryption entities config block for field-level encryption profiles that contains an attribute `items` which includes the encryption key and field pattern specifications.
     */
    @JvmName("htgxtmoetspnqbyr")
    public suspend
    fun encryptionEntities(`value`: Output<FieldLevelEncryptionProfileEncryptionEntitiesArgs>) {
        this.encryptionEntities = value
    }

    /**
     * @param value The name of the Field Level Encryption Profile.
     */
    @JvmName("ifljngblvlsqsiao")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An optional comment about the Field Level Encryption Profile.
     */
    @JvmName("cfbsvemscflymuny")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value The encryption entities config block for field-level encryption profiles that contains an attribute `items` which includes the encryption key and field pattern specifications.
     */
    @JvmName("xfetjursquncrafe")
    public suspend
    fun encryptionEntities(`value`: FieldLevelEncryptionProfileEncryptionEntitiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionEntities = mapped
    }

    /**
     * @param argument The encryption entities config block for field-level encryption profiles that contains an attribute `items` which includes the encryption key and field pattern specifications.
     */
    @JvmName("rybrtqkqwycovssd")
    public suspend
    fun encryptionEntities(argument: suspend FieldLevelEncryptionProfileEncryptionEntitiesArgsBuilder.() -> Unit) {
        val toBeMapped = FieldLevelEncryptionProfileEncryptionEntitiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.encryptionEntities = mapped
    }

    /**
     * @param value The name of the Field Level Encryption Profile.
     */
    @JvmName("ifiwwrqlcgvqvhiy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): FieldLevelEncryptionProfileArgs = FieldLevelEncryptionProfileArgs(
        comment = comment,
        encryptionEntities = encryptionEntities,
        name = name,
    )
}
