@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.FunctionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CloudFront Function resource. With CloudFront Functions in Amazon CloudFront, you can write lightweight functions in JavaScript for high-scale, latency-sensitive CDN customizations.
 * See [CloudFront Functions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-functions.html)
 * > **NOTE:** You cannot delete a function if it’s associated with a cache behavior. First, update your distributions to remove the function association from all cache behaviors, then delete the function.
 * ## Example Usage
 * ### Basic Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.Function;
 * import com.pulumi.aws.cloudfront.FunctionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Function("test", FunctionArgs.builder()
 *             .runtime("cloudfront-js-1.0")
 *             .comment("my function")
 *             .publish(true)
 *             .code(Files.readString(Paths.get(String.format("%s/function.js", path.module()))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudFront Functions using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/function:Function test my_test_function
 * ```
 * @property code Source code of the function
 * @property comment Comment.
 * @property name Unique name for your CloudFront Function.
 * @property publish Whether to publish creation/change as Live CloudFront Function Version. Defaults to `true`.
 * @property runtime Identifier of the function's runtime. Currently only `cloudfront-js-1.0` is valid.
 * The following arguments are optional:
 */
public data class FunctionArgs(
    public val code: Output<String>? = null,
    public val comment: Output<String>? = null,
    public val name: Output<String>? = null,
    public val publish: Output<Boolean>? = null,
    public val runtime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.FunctionArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.FunctionArgs =
        com.pulumi.aws.cloudfront.FunctionArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .comment(comment?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .publish(publish?.applyValue({ args0 -> args0 }))
            .runtime(runtime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionArgs].
 */
@PulumiTagMarker
public class FunctionArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var comment: Output<String>? = null

    private var name: Output<String>? = null

    private var publish: Output<Boolean>? = null

    private var runtime: Output<String>? = null

    /**
     * @param value Source code of the function
     */
    @JvmName("tcuublvdymosthvp")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Comment.
     */
    @JvmName("dlxayqjcsfpfibno")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Unique name for your CloudFront Function.
     */
    @JvmName("fhcptnemwkqhcxay")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Whether to publish creation/change as Live CloudFront Function Version. Defaults to `true`.
     */
    @JvmName("alfejkrcflfpcsmr")
    public suspend fun publish(`value`: Output<Boolean>) {
        this.publish = value
    }

    /**
     * @param value Identifier of the function's runtime. Currently only `cloudfront-js-1.0` is valid.
     * The following arguments are optional:
     */
    @JvmName("lxtcpdllhrfnwxmd")
    public suspend fun runtime(`value`: Output<String>) {
        this.runtime = value
    }

    /**
     * @param value Source code of the function
     */
    @JvmName("rdlgjwbmhdhkmhgt")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Comment.
     */
    @JvmName("rwntqkqglkciiaai")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Unique name for your CloudFront Function.
     */
    @JvmName("rtgqnjnsvalextrq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Whether to publish creation/change as Live CloudFront Function Version. Defaults to `true`.
     */
    @JvmName("xclcvfjunrgpcjnv")
    public suspend fun publish(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publish = mapped
    }

    /**
     * @param value Identifier of the function's runtime. Currently only `cloudfront-js-1.0` is valid.
     * The following arguments are optional:
     */
    @JvmName("oxlgnvhhcjglntjx")
    public suspend fun runtime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    internal fun build(): FunctionArgs = FunctionArgs(
        code = code,
        comment = comment,
        name = name,
        publish = publish,
        runtime = runtime,
    )
}
