@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [KeyGroup].
 */
@PulumiTagMarker
public class KeyGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyGroupArgs = KeyGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyGroupArgsBuilder.() -> Unit) {
        val builder = KeyGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): KeyGroup {
        val builtJavaResource = com.pulumi.aws.cloudfront.KeyGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeyGroup(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * The following example below creates a CloudFront key group.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.PublicKey;
 * import com.pulumi.aws.cloudfront.PublicKeyArgs;
 * import com.pulumi.aws.cloudfront.KeyGroup;
 * import com.pulumi.aws.cloudfront.KeyGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplePublicKey = new PublicKey("examplePublicKey", PublicKeyArgs.builder()
 *             .comment("example public key")
 *             .encodedKey(Files.readString(Paths.get("public_key.pem")))
 *             .build());
 *         var exampleKeyGroup = new KeyGroup("exampleKeyGroup", KeyGroupArgs.builder()
 *             .comment("example key group")
 *             .items(examplePublicKey.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudFront Key Group using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/keyGroup:KeyGroup example 4b4f2r1c-315d-5c2e-f093-216t50jed10f
 * ```
 *
 */
public class KeyGroup internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.KeyGroup,
) : KotlinCustomResource(javaResource, KeyGroupMapper) {
    /**
     * A comment to describe the key group..
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The identifier for this version of the key group.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * A list of the identifiers of the public keys in the key group.
     */
    public val items: Output<List<String>>
        get() = javaResource.items().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A name to identify the key group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object KeyGroupMapper : ResourceMapper<KeyGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.KeyGroup::class == javaResource::class

    override fun map(javaResource: Resource): KeyGroup = KeyGroup(
        javaResource as
            com.pulumi.aws.cloudfront.KeyGroup,
    )
}

/**
 * @see [KeyGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyGroup].
 */
public suspend fun keyGroup(name: String, block: suspend KeyGroupResourceBuilder.() -> Unit):
    KeyGroup {
    val builder = KeyGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyGroup(name: String): KeyGroup {
    val builder = KeyGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
