@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.KeyGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * The following example below creates a CloudFront key group.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.PublicKey;
 * import com.pulumi.aws.cloudfront.PublicKeyArgs;
 * import com.pulumi.aws.cloudfront.KeyGroup;
 * import com.pulumi.aws.cloudfront.KeyGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplePublicKey = new PublicKey("examplePublicKey", PublicKeyArgs.builder()
 *             .comment("example public key")
 *             .encodedKey(Files.readString(Paths.get("public_key.pem")))
 *             .build());
 *         var exampleKeyGroup = new KeyGroup("exampleKeyGroup", KeyGroupArgs.builder()
 *             .comment("example key group")
 *             .items(examplePublicKey.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudFront Key Group using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/keyGroup:KeyGroup example 4b4f2r1c-315d-5c2e-f093-216t50jed10f
 * ```
 * @property comment A comment to describe the key group..
 * @property items A list of the identifiers of the public keys in the key group.
 * @property name A name to identify the key group.
 */
public data class KeyGroupArgs(
    public val comment: Output<String>? = null,
    public val items: Output<List<String>>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.KeyGroupArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.KeyGroupArgs =
        com.pulumi.aws.cloudfront.KeyGroupArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .items(items?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyGroupArgs].
 */
@PulumiTagMarker
public class KeyGroupArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var items: Output<List<String>>? = null

    private var name: Output<String>? = null

    /**
     * @param value A comment to describe the key group..
     */
    @JvmName("pviknvcnderkpvex")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value A list of the identifiers of the public keys in the key group.
     */
    @JvmName("ytcmtlfpcmrchupr")
    public suspend fun items(`value`: Output<List<String>>) {
        this.items = value
    }

    @JvmName("cfmaxqhhkqadomyw")
    public suspend fun items(vararg values: Output<String>) {
        this.items = Output.all(values.asList())
    }

    /**
     * @param values A list of the identifiers of the public keys in the key group.
     */
    @JvmName("iecnplqiuiqvlsty")
    public suspend fun items(values: List<Output<String>>) {
        this.items = Output.all(values)
    }

    /**
     * @param value A name to identify the key group.
     */
    @JvmName("vakbptytambpybmu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A comment to describe the key group..
     */
    @JvmName("nuwiqbonwmuqjyjp")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value A list of the identifiers of the public keys in the key group.
     */
    @JvmName("wuiylxvqsddbbrpa")
    public suspend fun items(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param values A list of the identifiers of the public keys in the key group.
     */
    @JvmName("eibahkyruanpkthh")
    public suspend fun items(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param value A name to identify the key group.
     */
    @JvmName("ubpqdgemciyylcal")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): KeyGroupArgs = KeyGroupArgs(
        comment = comment,
        items = items,
        name = name,
    )
}
