@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.kotlin.outputs.MonitoringSubscriptionMonitoringSubscription
import com.pulumi.aws.cloudfront.kotlin.outputs.MonitoringSubscriptionMonitoringSubscription.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MonitoringSubscription].
 */
@PulumiTagMarker
public class MonitoringSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MonitoringSubscriptionArgs = MonitoringSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MonitoringSubscriptionArgsBuilder.() -> Unit) {
        val builder = MonitoringSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MonitoringSubscription {
        val builtJavaResource =
            com.pulumi.aws.cloudfront.MonitoringSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MonitoringSubscription(builtJavaResource)
    }
}

/**
 * Provides a CloudFront real-time log configuration resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.MonitoringSubscription;
 * import com.pulumi.aws.cloudfront.MonitoringSubscriptionArgs;
 * import com.pulumi.aws.cloudfront.inputs.MonitoringSubscriptionMonitoringSubscriptionArgs;
 * import com.pulumi.aws.cloudfront.inputs.MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MonitoringSubscription("example", MonitoringSubscriptionArgs.builder()
 *             .distributionId(aws_cloudfront_distribution.example().id())
 *             .monitoringSubscription(MonitoringSubscriptionMonitoringSubscriptionArgs.builder()
 *                 .realtimeMetricsSubscriptionConfig(MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs.builder()
 *                     .realtimeMetricsSubscriptionStatus("Enabled")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudFront monitoring subscription using the id. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/monitoringSubscription:MonitoringSubscription example E3QYSUHO4VYRGB
 * ```
 *
 */
public class MonitoringSubscription internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.MonitoringSubscription,
) : KotlinCustomResource(javaResource, MonitoringSubscriptionMapper) {
    /**
     * The ID of the distribution that you are enabling metrics for.
     */
    public val distributionId: Output<String>
        get() = javaResource.distributionId().applyValue({ args0 -> args0 })

    /**
     * A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
     */
    public val monitoringSubscription: Output<MonitoringSubscriptionMonitoringSubscription>
        get() = javaResource.monitoringSubscription().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object MonitoringSubscriptionMapper : ResourceMapper<MonitoringSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.MonitoringSubscription::class == javaResource::class

    override fun map(javaResource: Resource): MonitoringSubscription =
        MonitoringSubscription(javaResource as com.pulumi.aws.cloudfront.MonitoringSubscription)
}

/**
 * @see [MonitoringSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MonitoringSubscription].
 */
public suspend fun monitoringSubscription(
    name: String,
    block: suspend MonitoringSubscriptionResourceBuilder.() -> Unit,
): MonitoringSubscription {
    val builder = MonitoringSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MonitoringSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun monitoringSubscription(name: String): MonitoringSubscription {
    val builder = MonitoringSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
