@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.MonitoringSubscriptionArgs.builder
import com.pulumi.aws.cloudfront.kotlin.inputs.MonitoringSubscriptionMonitoringSubscriptionArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.MonitoringSubscriptionMonitoringSubscriptionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a CloudFront real-time log configuration resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.MonitoringSubscription;
 * import com.pulumi.aws.cloudfront.MonitoringSubscriptionArgs;
 * import com.pulumi.aws.cloudfront.inputs.MonitoringSubscriptionMonitoringSubscriptionArgs;
 * import com.pulumi.aws.cloudfront.inputs.MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MonitoringSubscription("example", MonitoringSubscriptionArgs.builder()
 *             .distributionId(aws_cloudfront_distribution.example().id())
 *             .monitoringSubscription(MonitoringSubscriptionMonitoringSubscriptionArgs.builder()
 *                 .realtimeMetricsSubscriptionConfig(MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs.builder()
 *                     .realtimeMetricsSubscriptionStatus("Enabled")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudFront monitoring subscription using the id. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/monitoringSubscription:MonitoringSubscription example E3QYSUHO4VYRGB
 * ```
 * @property distributionId The ID of the distribution that you are enabling metrics for.
 * @property monitoringSubscription A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
 */
public data class MonitoringSubscriptionArgs(
    public val distributionId: Output<String>? = null,
    public val monitoringSubscription: Output<MonitoringSubscriptionMonitoringSubscriptionArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.MonitoringSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.MonitoringSubscriptionArgs =
        com.pulumi.aws.cloudfront.MonitoringSubscriptionArgs.builder()
            .distributionId(distributionId?.applyValue({ args0 -> args0 }))
            .monitoringSubscription(
                monitoringSubscription?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MonitoringSubscriptionArgs].
 */
@PulumiTagMarker
public class MonitoringSubscriptionArgsBuilder internal constructor() {
    private var distributionId: Output<String>? = null

    private var monitoringSubscription: Output<MonitoringSubscriptionMonitoringSubscriptionArgs>? =
        null

    /**
     * @param value The ID of the distribution that you are enabling metrics for.
     */
    @JvmName("kmtrssfdjmpsgsqf")
    public suspend fun distributionId(`value`: Output<String>) {
        this.distributionId = value
    }

    /**
     * @param value A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
     */
    @JvmName("qnfqsuxwhlscrblg")
    public suspend
    fun monitoringSubscription(`value`: Output<MonitoringSubscriptionMonitoringSubscriptionArgs>) {
        this.monitoringSubscription = value
    }

    /**
     * @param value The ID of the distribution that you are enabling metrics for.
     */
    @JvmName("vsfbdkfxjfedufrc")
    public suspend fun distributionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributionId = mapped
    }

    /**
     * @param value A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
     */
    @JvmName("exlcpaxwyrxqecod")
    public suspend
    fun monitoringSubscription(`value`: MonitoringSubscriptionMonitoringSubscriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringSubscription = mapped
    }

    /**
     * @param argument A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
     */
    @JvmName("hejihfydwtqkmcov")
    public suspend
    fun monitoringSubscription(argument: suspend MonitoringSubscriptionMonitoringSubscriptionArgsBuilder.() -> Unit) {
        val toBeMapped = MonitoringSubscriptionMonitoringSubscriptionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.monitoringSubscription = mapped
    }

    internal fun build(): MonitoringSubscriptionArgs = MonitoringSubscriptionArgs(
        distributionId = distributionId,
        monitoringSubscription = monitoringSubscription,
    )
}
