@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OriginAccessControl].
 */
@PulumiTagMarker
public class OriginAccessControlResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OriginAccessControlArgs = OriginAccessControlArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OriginAccessControlArgsBuilder.() -> Unit) {
        val builder = OriginAccessControlArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OriginAccessControl {
        val builtJavaResource = com.pulumi.aws.cloudfront.OriginAccessControl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OriginAccessControl(builtJavaResource)
    }
}

/**
 * Manages an AWS CloudFront Origin Access Control, which is used by CloudFront Distributions with an Amazon S3 bucket as the origin.
 * Read more about Origin Access Control in the [CloudFront Developer Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html).
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.OriginAccessControl;
 * import com.pulumi.aws.cloudfront.OriginAccessControlArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OriginAccessControl("example", OriginAccessControlArgs.builder()
 *             .description("Example Policy")
 *             .originAccessControlOriginType("s3")
 *             .signingBehavior("always")
 *             .signingProtocol("sigv4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudFront Origin Access Control using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/originAccessControl:OriginAccessControl example E327GJI25M56DG
 * ```
 *
 */
public class OriginAccessControl internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.OriginAccessControl,
) : KotlinCustomResource(javaResource, OriginAccessControlMapper) {
    /**
     * The description of the Origin Access Control. Defaults to "Managed by Pulumi" if omitted.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The current version of this Origin Access Control.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * A name that identifies the Origin Access Control.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of origin that this Origin Access Control is for. Valid values are `s3`, and `mediastore`.
     */
    public val originAccessControlOriginType: Output<String>
        get() = javaResource.originAccessControlOriginType().applyValue({ args0 -> args0 })

    /**
     * Specifies which requests CloudFront signs. Specify `always` for the most common use case. Allowed values: `always`, `never`, and `no-override`.
     */
    public val signingBehavior: Output<String>
        get() = javaResource.signingBehavior().applyValue({ args0 -> args0 })

    /**
     * Determines how CloudFront signs (authenticates) requests. The only valid value is `sigv4`.
     */
    public val signingProtocol: Output<String>
        get() = javaResource.signingProtocol().applyValue({ args0 -> args0 })
}

public object OriginAccessControlMapper : ResourceMapper<OriginAccessControl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.OriginAccessControl::class == javaResource::class

    override fun map(javaResource: Resource): OriginAccessControl = OriginAccessControl(
        javaResource
            as com.pulumi.aws.cloudfront.OriginAccessControl,
    )
}

/**
 * @see [OriginAccessControl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OriginAccessControl].
 */
public suspend fun originAccessControl(
    name: String,
    block: suspend OriginAccessControlResourceBuilder.() -> Unit,
): OriginAccessControl {
    val builder = OriginAccessControlResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OriginAccessControl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun originAccessControl(name: String): OriginAccessControl {
    val builder = OriginAccessControlResourceBuilder()
    builder.name(name)
    return builder.build()
}
