@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OriginAccessIdentity].
 */
@PulumiTagMarker
public class OriginAccessIdentityResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OriginAccessIdentityArgs = OriginAccessIdentityArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OriginAccessIdentityArgsBuilder.() -> Unit) {
        val builder = OriginAccessIdentityArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OriginAccessIdentity {
        val builtJavaResource = com.pulumi.aws.cloudfront.OriginAccessIdentity(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OriginAccessIdentity(builtJavaResource)
    }
}

/**
 * Creates an Amazon CloudFront origin access identity.
 * For information about CloudFront distributions, see the
 * [Amazon CloudFront Developer Guide](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Introduction.html). For more information on generating
 * origin access identities, see
 * [Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content][2].
 * ## Example Usage
 * The following example below creates a CloudFront origin access identity.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.OriginAccessIdentity;
 * import com.pulumi.aws.cloudfront.OriginAccessIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OriginAccessIdentity("example", OriginAccessIdentityArgs.builder()
 *             .comment("Some comment")
 *             .build());
 *     }
 * }
 * ```
 * ## Using With CloudFront
 * Normally, when referencing an origin access identity in CloudFront, you need to
 * prefix the ID with the `origin-access-identity/cloudfront/` special path.
 * The `cloudfront_access_identity_path` allows this to be circumvented.
 * The below snippet demonstrates use with the `s3_origin_config` structure for the
 * `aws.cloudfront.Distribution` resource:
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // ... other configuration ...
 * const example = new aws.cloudfront.Distribution("example", {origins: [{
 *     s3OriginConfig: {
 *         originAccessIdentity: aws_cloudfront_origin_access_identity.example.cloudfront_access_identity_path,
 *     },
 * }]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # ... other configuration ...
 * example = aws.cloudfront.Distribution("example", origins=[aws.cloudfront.DistributionOriginArgs(
 *     s3_origin_config=aws.cloudfront.DistributionOriginS3OriginConfigArgs(
 *         origin_access_identity=aws_cloudfront_origin_access_identity["example"]["cloudfront_access_identity_path"],
 *     ),
 * )])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // ... other configuration ...
 *     var example = new Aws.CloudFront.Distribution("example", new()
 *     {
 *         Origins = new[]
 *         {
 *             new Aws.CloudFront.Inputs.DistributionOriginArgs
 *             {
 *                 S3OriginConfig = new Aws.CloudFront.Inputs.DistributionOriginS3OriginConfigArgs
 *                 {
 *                     OriginAccessIdentity = aws_cloudfront_origin_access_identity.Example.Cloudfront_access_identity_path,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfront.NewDistribution(ctx, "example", &cloudfront.DistributionArgs{
 * 			Origins: cloudfront.DistributionOriginArray{
 * 				&cloudfront.DistributionOriginArgs{
 * 					S3OriginConfig: &cloudfront.DistributionOriginS3OriginConfigArgs{
 * 						OriginAccessIdentity: pulumi.Any(aws_cloudfront_origin_access_identity.Example.Cloudfront_access_identity_path),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.Distribution;
 * import com.pulumi.aws.cloudfront.DistributionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginS3OriginConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Distribution("example", DistributionArgs.builder()
 *             .origins(DistributionOriginArgs.builder()
 *                 .s3OriginConfig(DistributionOriginS3OriginConfigArgs.builder()
 *                     .originAccessIdentity(aws_cloudfront_origin_access_identity.example().cloudfront_access_identity_path())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:Distribution
 *     properties:
 *       origins:
 *         - s3OriginConfig:
 *             originAccessIdentity: ${aws_cloudfront_origin_access_identity.example.cloudfront_access_identity_path}
 * ```
 * ### Updating your bucket policy
 * Note that the AWS API may translate the `s3_canonical_user_id` `CanonicalUser`
 * principal into an `AWS` IAM ARN principal when supplied in an
 * `aws.s3.BucketV2` bucket policy, causing spurious diffs. If
 * you see this behaviour, use the `iam_arn` instead:
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const s3Policy = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["s3:GetObject"],
 *         resources: [`${aws_s3_bucket&#46;example&#46;arn}/*`],
 *         principals: [{
 *             type: "AWS",
 *             identifiers: [aws_cloudfront_origin_access_identity&#46;example&#46;iam_arn],
 *         }],
 *     }],
 * });
 * const example = new aws.s3.BucketPolicy("example", {
 *     bucket: aws_s3_bucket.example.id,
 *     policy: s3Policy.then(s3Policy => s3Policy.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * s3_policy = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
 *     actions=["s3:GetObject"],
 *     resources=[f"{aws_s3_bucket['example']['arn']}/*"],
 *     principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
 *         type="AWS",
 *         identifiers=[aws_cloudfront_origin_access_identity["example"]["iam_arn"]],
 *     )],
 * )])
 * example = aws.s3.BucketPolicy("example",
 *     bucket=aws_s3_bucket["example"]["id"],
 *     policy=s3_policy.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var s3Policy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "s3:GetObject",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     $"{aws_s3_bucket.Example.Arn}/*",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             aws_cloudfront_origin_access_identity.Example.Iam_arn,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var example = new Aws.S3.BucketPolicy("example", new()
 *     {
 *         Bucket = aws_s3_bucket.Example.Id,
 *         Policy = s3Policy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * s3Policy, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Actions: []string{
 * "s3:GetObject",
 * },
 * Resources: []string{
 * fmt.Sprintf("%v/*", aws_s3_bucket.Example.Arn),
 * },
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "AWS",
 * Identifiers: interface{}{
 * aws_cloudfront_origin_access_identity.Example.Iam_arn,
 * },
 * },
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * _, err = s3.NewBucketPolicy(ctx, "example", &s3.BucketPolicyArgs{
 * Bucket: pulumi.Any(aws_s3_bucket.Example.Id),
 * Policy: *pulumi.String(s3Policy.Json),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var s3Policy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("s3:GetObject")
 *                 .resources(String.format("%s/*", aws_s3_bucket.example().arn()))
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(aws_cloudfront_origin_access_identity.example().iam_arn())
 *                     .build())
 *                 .build())
 *             .build());
 *         var example = new BucketPolicy("example", BucketPolicyArgs.builder()
 *             .bucket(aws_s3_bucket.example().id())
 *             .policy(s3Policy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketPolicy
 *     properties:
 *       bucket: ${aws_s3_bucket.example.id}
 *       policy: ${s3Policy.json}
 * variables:
 *   s3Policy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - s3:GetObject
 *             resources:
 *               - ${aws_s3_bucket.example.arn}/*
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - ${aws_cloudfront_origin_access_identity.example.iam_arn}
 * ```
 * [1]: http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Introduction.html
 * [2]: http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html
 * ## Import
 * Using `pulumi import`, import Cloudfront Origin Access Identities using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/originAccessIdentity:OriginAccessIdentity origin_access E74FTE3AEXAMPLE
 * ```
 * */*/*/*/*/*/
 */
public class OriginAccessIdentity internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.OriginAccessIdentity,
) : KotlinCustomResource(javaResource, OriginAccessIdentityMapper) {
    /**
     * Internal value used by CloudFront to allow future
     * updates to the origin access identity.
     */
    public val callerReference: Output<String>
        get() = javaResource.callerReference().applyValue({ args0 -> args0 })

    /**
     * A shortcut to the full path for the
     * origin access identity to use in CloudFront, see below.
     */
    public val cloudfrontAccessIdentityPath: Output<String>
        get() = javaResource.cloudfrontAccessIdentityPath().applyValue({ args0 -> args0 })

    /**
     * An optional comment for the origin access identity.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The current version of the origin access identity's information.
     * For example: `E2QWRUHAPOMQZL`.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * A pre-generated ARN for use in S3 bucket policies (see below).
     * Example: `arn:aws:iam::cloudfront:user/CloudFront Origin Access Identity
     * E2QWRUHAPOMQZL`.
     */
    public val iamArn: Output<String>
        get() = javaResource.iamArn().applyValue({ args0 -> args0 })

    /**
     * The Amazon S3 canonical user ID for the origin
     * access identity, which you use when giving the origin access identity read
     * permission to an object in Amazon S3.
     */
    public val s3CanonicalUserId: Output<String>
        get() = javaResource.s3CanonicalUserId().applyValue({ args0 -> args0 })
}

public object OriginAccessIdentityMapper : ResourceMapper<OriginAccessIdentity> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.OriginAccessIdentity::class == javaResource::class

    override fun map(javaResource: Resource): OriginAccessIdentity = OriginAccessIdentity(
        javaResource
            as com.pulumi.aws.cloudfront.OriginAccessIdentity,
    )
}

/**
 * @see [OriginAccessIdentity].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OriginAccessIdentity].
 */
public suspend fun originAccessIdentity(
    name: String,
    block: suspend OriginAccessIdentityResourceBuilder.() -> Unit,
): OriginAccessIdentity {
    val builder = OriginAccessIdentityResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OriginAccessIdentity].
 * @param name The _unique_ name of the resulting resource.
 */
public fun originAccessIdentity(name: String): OriginAccessIdentity {
    val builder = OriginAccessIdentityResourceBuilder()
    builder.name(name)
    return builder.build()
}
