@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.OriginRequestPolicyArgs.builder
import com.pulumi.aws.cloudfront.kotlin.inputs.OriginRequestPolicyCookiesConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.OriginRequestPolicyCookiesConfigArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.OriginRequestPolicyHeadersConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.OriginRequestPolicyHeadersConfigArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.OriginRequestPolicyQueryStringsConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.OriginRequestPolicyQueryStringsConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * The following example below creates a CloudFront origin request policy.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.OriginRequestPolicy;
 * import com.pulumi.aws.cloudfront.OriginRequestPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyCookiesConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyCookiesConfigCookiesArgs;
 * import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyHeadersConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyHeadersConfigHeadersArgs;
 * import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyQueryStringsConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyQueryStringsConfigQueryStringsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OriginRequestPolicy("example", OriginRequestPolicyArgs.builder()
 *             .comment("example comment")
 *             .cookiesConfig(OriginRequestPolicyCookiesConfigArgs.builder()
 *                 .cookieBehavior("whitelist")
 *                 .cookies(OriginRequestPolicyCookiesConfigCookiesArgs.builder()
 *                     .items("example")
 *                     .build())
 *                 .build())
 *             .headersConfig(OriginRequestPolicyHeadersConfigArgs.builder()
 *                 .headerBehavior("whitelist")
 *                 .headers(OriginRequestPolicyHeadersConfigHeadersArgs.builder()
 *                     .items("example")
 *                     .build())
 *                 .build())
 *             .queryStringsConfig(OriginRequestPolicyQueryStringsConfigArgs.builder()
 *                 .queryStringBehavior("whitelist")
 *                 .queryStrings(OriginRequestPolicyQueryStringsConfigQueryStringsArgs.builder()
 *                     .items("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cloudfront Origin Request Policies using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/originRequestPolicy:OriginRequestPolicy policy ccca32ef-dce3-4df3-80df-1bd3000bc4d3
 * ```
 * @property comment Comment to describe the origin request policy.
 * @property cookiesConfig Object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Cookies Config for more information.
 * @property headersConfig Object that determines whether any HTTP headers (and if so, which headers) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Headers Config for more information.
 * @property name Unique name to identify the origin request policy.
 * @property queryStringsConfig Object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Query String Config for more information.
 */
public data class OriginRequestPolicyArgs(
    public val comment: Output<String>? = null,
    public val cookiesConfig: Output<OriginRequestPolicyCookiesConfigArgs>? = null,
    public val headersConfig: Output<OriginRequestPolicyHeadersConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val queryStringsConfig: Output<OriginRequestPolicyQueryStringsConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.OriginRequestPolicyArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.OriginRequestPolicyArgs =
        com.pulumi.aws.cloudfront.OriginRequestPolicyArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .cookiesConfig(cookiesConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headersConfig(headersConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .queryStringsConfig(
                queryStringsConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [OriginRequestPolicyArgs].
 */
@PulumiTagMarker
public class OriginRequestPolicyArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var cookiesConfig: Output<OriginRequestPolicyCookiesConfigArgs>? = null

    private var headersConfig: Output<OriginRequestPolicyHeadersConfigArgs>? = null

    private var name: Output<String>? = null

    private var queryStringsConfig: Output<OriginRequestPolicyQueryStringsConfigArgs>? = null

    /**
     * @param value Comment to describe the origin request policy.
     */
    @JvmName("vsrqubkudrwbxhoh")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Cookies Config for more information.
     */
    @JvmName("rnaenqwqjxxxdmry")
    public suspend fun cookiesConfig(`value`: Output<OriginRequestPolicyCookiesConfigArgs>) {
        this.cookiesConfig = value
    }

    /**
     * @param value Object that determines whether any HTTP headers (and if so, which headers) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Headers Config for more information.
     */
    @JvmName("ojxemmdfpsefrngj")
    public suspend fun headersConfig(`value`: Output<OriginRequestPolicyHeadersConfigArgs>) {
        this.headersConfig = value
    }

    /**
     * @param value Unique name to identify the origin request policy.
     */
    @JvmName("gudhkrqsmegvojbt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Query String Config for more information.
     */
    @JvmName("bwehushthlklubgi")
    public suspend
    fun queryStringsConfig(`value`: Output<OriginRequestPolicyQueryStringsConfigArgs>) {
        this.queryStringsConfig = value
    }

    /**
     * @param value Comment to describe the origin request policy.
     */
    @JvmName("nopmaownteegdyvx")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Cookies Config for more information.
     */
    @JvmName("oivluykltrcpirtj")
    public suspend fun cookiesConfig(`value`: OriginRequestPolicyCookiesConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookiesConfig = mapped
    }

    /**
     * @param argument Object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Cookies Config for more information.
     */
    @JvmName("vdslmichedaptwfa")
    public suspend
    fun cookiesConfig(argument: suspend OriginRequestPolicyCookiesConfigArgsBuilder.() -> Unit) {
        val toBeMapped = OriginRequestPolicyCookiesConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cookiesConfig = mapped
    }

    /**
     * @param value Object that determines whether any HTTP headers (and if so, which headers) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Headers Config for more information.
     */
    @JvmName("hvnvypponffsqydb")
    public suspend fun headersConfig(`value`: OriginRequestPolicyHeadersConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headersConfig = mapped
    }

    /**
     * @param argument Object that determines whether any HTTP headers (and if so, which headers) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Headers Config for more information.
     */
    @JvmName("wyjqwhgmvwmfjnmt")
    public suspend
    fun headersConfig(argument: suspend OriginRequestPolicyHeadersConfigArgsBuilder.() -> Unit) {
        val toBeMapped = OriginRequestPolicyHeadersConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.headersConfig = mapped
    }

    /**
     * @param value Unique name to identify the origin request policy.
     */
    @JvmName("rvjehenuxwauwktt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Query String Config for more information.
     */
    @JvmName("eqqkbmjetufoxpab")
    public suspend fun queryStringsConfig(`value`: OriginRequestPolicyQueryStringsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStringsConfig = mapped
    }

    /**
     * @param argument Object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Query String Config for more information.
     */
    @JvmName("bsngbuswlgmouafw")
    public suspend
    fun queryStringsConfig(argument: suspend OriginRequestPolicyQueryStringsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = OriginRequestPolicyQueryStringsConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.queryStringsConfig = mapped
    }

    internal fun build(): OriginRequestPolicyArgs = OriginRequestPolicyArgs(
        comment = comment,
        cookiesConfig = cookiesConfig,
        headersConfig = headersConfig,
        name = name,
        queryStringsConfig = queryStringsConfig,
    )
}
