@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PublicKey].
 */
@PulumiTagMarker
public class PublicKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PublicKeyArgs = PublicKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PublicKeyArgsBuilder.() -> Unit) {
        val builder = PublicKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PublicKey {
        val builtJavaResource = com.pulumi.aws.cloudfront.PublicKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PublicKey(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * The following example below creates a CloudFront public key.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.PublicKey;
 * import com.pulumi.aws.cloudfront.PublicKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PublicKey("example", PublicKeyArgs.builder()
 *             .comment("test public key")
 *             .encodedKey(Files.readString(Paths.get("public_key.pem")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudFront Public Key using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/publicKey:PublicKey example K3D5EWEUDCCXON
 * ```
 *
 */
public class PublicKey internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.PublicKey,
) : KotlinCustomResource(javaResource, PublicKeyMapper) {
    /**
     * Internal value used by CloudFront to allow future updates to the public key configuration.
     */
    public val callerReference: Output<String>
        get() = javaResource.callerReference().applyValue({ args0 -> args0 })

    /**
     * An optional comment about the public key.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
     */
    public val encodedKey: Output<String>
        get() = javaResource.encodedKey().applyValue({ args0 -> args0 })

    /**
     * The current version of the public key. For example: `E2QWRUHAPOMQZL`.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name for the public key. By default generated by this provider.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name for the public key. Conflicts with `name`.
     * **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `aws.cloudfront.PublicKey` resource.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })
}

public object PublicKeyMapper : ResourceMapper<PublicKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.PublicKey::class == javaResource::class

    override fun map(javaResource: Resource): PublicKey = PublicKey(
        javaResource as
            com.pulumi.aws.cloudfront.PublicKey,
    )
}

/**
 * @see [PublicKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PublicKey].
 */
public suspend fun publicKey(name: String, block: suspend PublicKeyResourceBuilder.() -> Unit):
    PublicKey {
    val builder = PublicKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PublicKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun publicKey(name: String): PublicKey {
    val builder = PublicKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
