@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.PublicKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * The following example below creates a CloudFront public key.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.PublicKey;
 * import com.pulumi.aws.cloudfront.PublicKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PublicKey("example", PublicKeyArgs.builder()
 *             .comment("test public key")
 *             .encodedKey(Files.readString(Paths.get("public_key.pem")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudFront Public Key using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/publicKey:PublicKey example K3D5EWEUDCCXON
 * ```
 * @property comment An optional comment about the public key.
 * @property encodedKey The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
 * @property name The name for the public key. By default generated by this provider.
 * @property namePrefix The name for the public key. Conflicts with `name`.
 * **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `aws.cloudfront.PublicKey` resource.
 */
public data class PublicKeyArgs(
    public val comment: Output<String>? = null,
    public val encodedKey: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.PublicKeyArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.PublicKeyArgs =
        com.pulumi.aws.cloudfront.PublicKeyArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .encodedKey(encodedKey?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PublicKeyArgs].
 */
@PulumiTagMarker
public class PublicKeyArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var encodedKey: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    /**
     * @param value An optional comment about the public key.
     */
    @JvmName("rgfunvqtkmobcsno")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
     */
    @JvmName("btirtxfubautlroq")
    public suspend fun encodedKey(`value`: Output<String>) {
        this.encodedKey = value
    }

    /**
     * @param value The name for the public key. By default generated by this provider.
     */
    @JvmName("elhhhvnlsalbkoaq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name for the public key. Conflicts with `name`.
     * **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `aws.cloudfront.PublicKey` resource.
     */
    @JvmName("rnxaqitnnqugornx")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value An optional comment about the public key.
     */
    @JvmName("yldkdoovfuodmggq")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
     */
    @JvmName("laxswjkmadfsiyrf")
    public suspend fun encodedKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodedKey = mapped
    }

    /**
     * @param value The name for the public key. By default generated by this provider.
     */
    @JvmName("bkrodpihkcbhetpi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name for the public key. Conflicts with `name`.
     * **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `aws.cloudfront.PublicKey` resource.
     */
    @JvmName("fhmmqxqdwjempuls")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    internal fun build(): PublicKeyArgs = PublicKeyArgs(
        comment = comment,
        encodedKey = encodedKey,
        name = name,
        namePrefix = namePrefix,
    )
}
