@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.kotlin.outputs.RealtimeLogConfigEndpoint
import com.pulumi.aws.cloudfront.kotlin.outputs.RealtimeLogConfigEndpoint.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RealtimeLogConfig].
 */
@PulumiTagMarker
public class RealtimeLogConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RealtimeLogConfigArgs = RealtimeLogConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RealtimeLogConfigArgsBuilder.() -> Unit) {
        val builder = RealtimeLogConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RealtimeLogConfig {
        val builtJavaResource = com.pulumi.aws.cloudfront.RealtimeLogConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RealtimeLogConfig(builtJavaResource)
    }
}

/**
 * Provides a CloudFront real-time log configuration resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.cloudfront.RealtimeLogConfig;
 * import com.pulumi.aws.cloudfront.RealtimeLogConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointArgs;
 * import com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointKinesisStreamConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("cloudfront.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "kinesis:DescribeStreamSummary",
 *                     "kinesis:DescribeStream",
 *                     "kinesis:PutRecord",
 *                     "kinesis:PutRecords")
 *                 .resources(aws_kinesis_stream.example().arn())
 *                 .build())
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.id())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleRealtimeLogConfig = new RealtimeLogConfig("exampleRealtimeLogConfig", RealtimeLogConfigArgs.builder()
 *             .samplingRate(75)
 *             .fields(
 *                 "timestamp",
 *                 "c-ip")
 *             .endpoint(RealtimeLogConfigEndpointArgs.builder()
 *                 .streamType("Kinesis")
 *                 .kinesisStreamConfig(RealtimeLogConfigEndpointKinesisStreamConfigArgs.builder()
 *                     .roleArn(exampleRole.arn())
 *                     .streamArn(aws_kinesis_stream.example().arn())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleRolePolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudFront real-time log configurations using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/realtimeLogConfig:RealtimeLogConfig example arn:aws:cloudfront::111122223333:realtime-log-config/ExampleNameForRealtimeLogConfig
 * ```
 *
 */
public class RealtimeLogConfig internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.RealtimeLogConfig,
) : KotlinCustomResource(javaResource, RealtimeLogConfigMapper) {
    /**
     * The ARN (Amazon Resource Name) of the CloudFront real-time log configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Kinesis data streams where real-time log data is sent.
     */
    public val endpoint: Output<RealtimeLogConfigEndpoint>
        get() = javaResource.endpoint().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
     */
    public val fields: Output<List<String>>
        get() = javaResource.fields().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The unique name to identify this real-time log configuration.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. An integer between `1` and `100`, inclusive.
     */
    public val samplingRate: Output<Int>
        get() = javaResource.samplingRate().applyValue({ args0 -> args0 })
}

public object RealtimeLogConfigMapper : ResourceMapper<RealtimeLogConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.RealtimeLogConfig::class == javaResource::class

    override fun map(javaResource: Resource): RealtimeLogConfig = RealtimeLogConfig(
        javaResource as
            com.pulumi.aws.cloudfront.RealtimeLogConfig,
    )
}

/**
 * @see [RealtimeLogConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RealtimeLogConfig].
 */
public suspend fun realtimeLogConfig(
    name: String,
    block: suspend RealtimeLogConfigResourceBuilder.() -> Unit,
): RealtimeLogConfig {
    val builder = RealtimeLogConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RealtimeLogConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun realtimeLogConfig(name: String): RealtimeLogConfig {
    val builder = RealtimeLogConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
