@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.RealtimeLogConfigArgs.builder
import com.pulumi.aws.cloudfront.kotlin.inputs.RealtimeLogConfigEndpointArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.RealtimeLogConfigEndpointArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a CloudFront real-time log configuration resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.cloudfront.RealtimeLogConfig;
 * import com.pulumi.aws.cloudfront.RealtimeLogConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointArgs;
 * import com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointKinesisStreamConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("cloudfront.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "kinesis:DescribeStreamSummary",
 *                     "kinesis:DescribeStream",
 *                     "kinesis:PutRecord",
 *                     "kinesis:PutRecords")
 *                 .resources(aws_kinesis_stream.example().arn())
 *                 .build())
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.id())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleRealtimeLogConfig = new RealtimeLogConfig("exampleRealtimeLogConfig", RealtimeLogConfigArgs.builder()
 *             .samplingRate(75)
 *             .fields(
 *                 "timestamp",
 *                 "c-ip")
 *             .endpoint(RealtimeLogConfigEndpointArgs.builder()
 *                 .streamType("Kinesis")
 *                 .kinesisStreamConfig(RealtimeLogConfigEndpointKinesisStreamConfigArgs.builder()
 *                     .roleArn(exampleRole.arn())
 *                     .streamArn(aws_kinesis_stream.example().arn())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleRolePolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudFront real-time log configurations using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/realtimeLogConfig:RealtimeLogConfig example arn:aws:cloudfront::111122223333:realtime-log-config/ExampleNameForRealtimeLogConfig
 * ```
 * @property endpoint The Amazon Kinesis data streams where real-time log data is sent.
 * @property fields The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
 * @property name The unique name to identify this real-time log configuration.
 * @property samplingRate The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. An integer between `1` and `100`, inclusive.
 */
public data class RealtimeLogConfigArgs(
    public val endpoint: Output<RealtimeLogConfigEndpointArgs>? = null,
    public val fields: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val samplingRate: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.RealtimeLogConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.RealtimeLogConfigArgs =
        com.pulumi.aws.cloudfront.RealtimeLogConfigArgs.builder()
            .endpoint(endpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fields(fields?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .samplingRate(samplingRate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RealtimeLogConfigArgs].
 */
@PulumiTagMarker
public class RealtimeLogConfigArgsBuilder internal constructor() {
    private var endpoint: Output<RealtimeLogConfigEndpointArgs>? = null

    private var fields: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var samplingRate: Output<Int>? = null

    /**
     * @param value The Amazon Kinesis data streams where real-time log data is sent.
     */
    @JvmName("hmfqxvkywxammhlu")
    public suspend fun endpoint(`value`: Output<RealtimeLogConfigEndpointArgs>) {
        this.endpoint = value
    }

    /**
     * @param value The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
     */
    @JvmName("kqgdoiavhpsdgupm")
    public suspend fun fields(`value`: Output<List<String>>) {
        this.fields = value
    }

    @JvmName("yhsvpewpwursqmem")
    public suspend fun fields(vararg values: Output<String>) {
        this.fields = Output.all(values.asList())
    }

    /**
     * @param values The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
     */
    @JvmName("xyvusjisdhitwjoy")
    public suspend fun fields(values: List<Output<String>>) {
        this.fields = Output.all(values)
    }

    /**
     * @param value The unique name to identify this real-time log configuration.
     */
    @JvmName("rjgvyomxfihlnswi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. An integer between `1` and `100`, inclusive.
     */
    @JvmName("meqdrkyosxvwficm")
    public suspend fun samplingRate(`value`: Output<Int>) {
        this.samplingRate = value
    }

    /**
     * @param value The Amazon Kinesis data streams where real-time log data is sent.
     */
    @JvmName("nrmyxqvgksrspbjx")
    public suspend fun endpoint(`value`: RealtimeLogConfigEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param argument The Amazon Kinesis data streams where real-time log data is sent.
     */
    @JvmName("egdrbbexhtylvxkn")
    public suspend fun endpoint(argument: suspend RealtimeLogConfigEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = RealtimeLogConfigEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endpoint = mapped
    }

    /**
     * @param value The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
     */
    @JvmName("rursvjdiyqqwlwrg")
    public suspend fun fields(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param values The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
     */
    @JvmName("ugumhkbtxmcormae")
    public suspend fun fields(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param value The unique name to identify this real-time log configuration.
     */
    @JvmName("jnkdyrxqosxjnqtu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. An integer between `1` and `100`, inclusive.
     */
    @JvmName("lqxiwtilkgdlxcpt")
    public suspend fun samplingRate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samplingRate = mapped
    }

    internal fun build(): RealtimeLogConfigArgs = RealtimeLogConfigArgs(
        endpoint = endpoint,
        fields = fields,
        name = name,
        samplingRate = samplingRate,
    )
}
