@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicyCorsConfig
import com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicyCustomHeadersConfig
import com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicyRemoveHeadersConfig
import com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicySecurityHeadersConfig
import com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicyServerTimingHeadersConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicyCorsConfig.Companion.toKotlin as responseHeadersPolicyCorsConfigToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicyCustomHeadersConfig.Companion.toKotlin as responseHeadersPolicyCustomHeadersConfigToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicyRemoveHeadersConfig.Companion.toKotlin as responseHeadersPolicyRemoveHeadersConfigToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicySecurityHeadersConfig.Companion.toKotlin as responseHeadersPolicySecurityHeadersConfigToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.ResponseHeadersPolicyServerTimingHeadersConfig.Companion.toKotlin as responseHeadersPolicyServerTimingHeadersConfigToKotlin

/**
 * Builder for [ResponseHeadersPolicy].
 */
@PulumiTagMarker
public class ResponseHeadersPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResponseHeadersPolicyArgs = ResponseHeadersPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResponseHeadersPolicyArgsBuilder.() -> Unit) {
        val builder = ResponseHeadersPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResponseHeadersPolicy {
        val builtJavaResource = com.pulumi.aws.cloudfront.ResponseHeadersPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResponseHeadersPolicy(builtJavaResource)
    }
}

/**
 * Provides a CloudFront response headers policy resource.
 * A response headers policy contains information about a set of HTTP response headers and their values.
 * After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a CloudFront distribution.
 * When it’s attached to a cache behavior, CloudFront adds the headers in the policy to every response that it sends for requests that match the cache behavior.
 * ## Example Usage
 * The example below creates a CloudFront response headers policy.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicy;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResponseHeadersPolicy("example", ResponseHeadersPolicyArgs.builder()
 *             .comment("test comment")
 *             .corsConfig(ResponseHeadersPolicyCorsConfigArgs.builder()
 *                 .accessControlAllowCredentials(true)
 *                 .accessControlAllowHeaders(ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgs.builder()
 *                     .items("test")
 *                     .build())
 *                 .accessControlAllowMethods(ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgs.builder()
 *                     .items("GET")
 *                     .build())
 *                 .accessControlAllowOrigins(ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgs.builder()
 *                     .items("test.example.comtest")
 *                     .build())
 *                 .originOverride(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cloudfront Response Headers Policies using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/responseHeadersPolicy:ResponseHeadersPolicy policy 658327ea-f89d-4fab-a63d-7e88639e58f9
 * ```
 *
 */
public class ResponseHeadersPolicy internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.ResponseHeadersPolicy,
) : KotlinCustomResource(javaResource, ResponseHeadersPolicyMapper) {
    /**
     * A comment to describe the response headers policy. The comment cannot be longer than 128 characters.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A configuration for a set of HTTP response headers that are used for Cross-Origin Resource Sharing (CORS). See Cors Config for more information.
     */
    public val corsConfig: Output<ResponseHeadersPolicyCorsConfig>?
        get() = javaResource.corsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    responseHeadersPolicyCorsConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Object that contains an attribute `items` that contains a list of custom headers. See Custom Header for more information.
     */
    public val customHeadersConfig: Output<ResponseHeadersPolicyCustomHeadersConfig>?
        get() = javaResource.customHeadersConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    responseHeadersPolicyCustomHeadersConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The current version of the response headers policy.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * A unique name to identify the response headers policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A configuration for a set of HTTP headers to remove from the HTTP response. Object that contains an attribute `items` that contains a list of headers. See Remove Header for more information.
     */
    public val removeHeadersConfig: Output<ResponseHeadersPolicyRemoveHeadersConfig>?
        get() = javaResource.removeHeadersConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    responseHeadersPolicyRemoveHeadersConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A configuration for a set of security-related HTTP response headers. See Security Headers Config for more information.
     */
    public val securityHeadersConfig: Output<ResponseHeadersPolicySecurityHeadersConfig>?
        get() = javaResource.securityHeadersConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    responseHeadersPolicySecurityHeadersConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A configuration for enabling the Server-Timing header in HTTP responses sent from CloudFront. See Server Timing Headers Config for more information.
     */
    public val serverTimingHeadersConfig: Output<ResponseHeadersPolicyServerTimingHeadersConfig>?
        get() = javaResource.serverTimingHeadersConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    responseHeadersPolicyServerTimingHeadersConfigToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ResponseHeadersPolicyMapper : ResourceMapper<ResponseHeadersPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.ResponseHeadersPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ResponseHeadersPolicy =
        ResponseHeadersPolicy(javaResource as com.pulumi.aws.cloudfront.ResponseHeadersPolicy)
}

/**
 * @see [ResponseHeadersPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResponseHeadersPolicy].
 */
public suspend fun responseHeadersPolicy(
    name: String,
    block: suspend ResponseHeadersPolicyResourceBuilder.() -> Unit,
): ResponseHeadersPolicy {
    val builder = ResponseHeadersPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResponseHeadersPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun responseHeadersPolicy(name: String): ResponseHeadersPolicy {
    val builder = ResponseHeadersPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
