@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs.builder
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyCorsConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyCorsConfigArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyCustomHeadersConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyCustomHeadersConfigArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyRemoveHeadersConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyRemoveHeadersConfigArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicySecurityHeadersConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicySecurityHeadersConfigArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyServerTimingHeadersConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyServerTimingHeadersConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a CloudFront response headers policy resource.
 * A response headers policy contains information about a set of HTTP response headers and their values.
 * After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a CloudFront distribution.
 * When it’s attached to a cache behavior, CloudFront adds the headers in the policy to every response that it sends for requests that match the cache behavior.
 * ## Example Usage
 * The example below creates a CloudFront response headers policy.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicy;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResponseHeadersPolicy("example", ResponseHeadersPolicyArgs.builder()
 *             .comment("test comment")
 *             .corsConfig(ResponseHeadersPolicyCorsConfigArgs.builder()
 *                 .accessControlAllowCredentials(true)
 *                 .accessControlAllowHeaders(ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgs.builder()
 *                     .items("test")
 *                     .build())
 *                 .accessControlAllowMethods(ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgs.builder()
 *                     .items("GET")
 *                     .build())
 *                 .accessControlAllowOrigins(ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgs.builder()
 *                     .items("test.example.comtest")
 *                     .build())
 *                 .originOverride(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cloudfront Response Headers Policies using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cloudfront/responseHeadersPolicy:ResponseHeadersPolicy policy 658327ea-f89d-4fab-a63d-7e88639e58f9
 * ```
 * @property comment A comment to describe the response headers policy. The comment cannot be longer than 128 characters.
 * @property corsConfig A configuration for a set of HTTP response headers that are used for Cross-Origin Resource Sharing (CORS). See Cors Config for more information.
 * @property customHeadersConfig Object that contains an attribute `items` that contains a list of custom headers. See Custom Header for more information.
 * @property etag The current version of the response headers policy.
 * @property name A unique name to identify the response headers policy.
 * @property removeHeadersConfig A configuration for a set of HTTP headers to remove from the HTTP response. Object that contains an attribute `items` that contains a list of headers. See Remove Header for more information.
 * @property securityHeadersConfig A configuration for a set of security-related HTTP response headers. See Security Headers Config for more information.
 * @property serverTimingHeadersConfig A configuration for enabling the Server-Timing header in HTTP responses sent from CloudFront. See Server Timing Headers Config for more information.
 */
public data class ResponseHeadersPolicyArgs(
    public val comment: Output<String>? = null,
    public val corsConfig: Output<ResponseHeadersPolicyCorsConfigArgs>? = null,
    public val customHeadersConfig: Output<ResponseHeadersPolicyCustomHeadersConfigArgs>? = null,
    public val etag: Output<String>? = null,
    public val name: Output<String>? = null,
    public val removeHeadersConfig: Output<ResponseHeadersPolicyRemoveHeadersConfigArgs>? = null,
    public val securityHeadersConfig: Output<ResponseHeadersPolicySecurityHeadersConfigArgs>? = null,
    public val serverTimingHeadersConfig: Output<ResponseHeadersPolicyServerTimingHeadersConfigArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs =
        com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .corsConfig(corsConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customHeadersConfig(
                customHeadersConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .etag(etag?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .removeHeadersConfig(
                removeHeadersConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securityHeadersConfig(
                securityHeadersConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .serverTimingHeadersConfig(
                serverTimingHeadersConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ResponseHeadersPolicyArgs].
 */
@PulumiTagMarker
public class ResponseHeadersPolicyArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var corsConfig: Output<ResponseHeadersPolicyCorsConfigArgs>? = null

    private var customHeadersConfig: Output<ResponseHeadersPolicyCustomHeadersConfigArgs>? = null

    private var etag: Output<String>? = null

    private var name: Output<String>? = null

    private var removeHeadersConfig: Output<ResponseHeadersPolicyRemoveHeadersConfigArgs>? = null

    private var securityHeadersConfig: Output<ResponseHeadersPolicySecurityHeadersConfigArgs>? = null

    private var serverTimingHeadersConfig: Output<ResponseHeadersPolicyServerTimingHeadersConfigArgs>? =
        null

    /**
     * @param value A comment to describe the response headers policy. The comment cannot be longer than 128 characters.
     */
    @JvmName("mujoyfwdpklqsnoo")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value A configuration for a set of HTTP response headers that are used for Cross-Origin Resource Sharing (CORS). See Cors Config for more information.
     */
    @JvmName("syjkitvvyqwyemmc")
    public suspend fun corsConfig(`value`: Output<ResponseHeadersPolicyCorsConfigArgs>) {
        this.corsConfig = value
    }

    /**
     * @param value Object that contains an attribute `items` that contains a list of custom headers. See Custom Header for more information.
     */
    @JvmName("sipscxasasevighe")
    public suspend
    fun customHeadersConfig(`value`: Output<ResponseHeadersPolicyCustomHeadersConfigArgs>) {
        this.customHeadersConfig = value
    }

    /**
     * @param value The current version of the response headers policy.
     */
    @JvmName("pmtmphnhxascvebx")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value A unique name to identify the response headers policy.
     */
    @JvmName("ufjvsgcqlymgvwrs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A configuration for a set of HTTP headers to remove from the HTTP response. Object that contains an attribute `items` that contains a list of headers. See Remove Header for more information.
     */
    @JvmName("yssxotufupeslmog")
    public suspend
    fun removeHeadersConfig(`value`: Output<ResponseHeadersPolicyRemoveHeadersConfigArgs>) {
        this.removeHeadersConfig = value
    }

    /**
     * @param value A configuration for a set of security-related HTTP response headers. See Security Headers Config for more information.
     */
    @JvmName("ckcujyhvpkgdfqfp")
    public suspend
    fun securityHeadersConfig(`value`: Output<ResponseHeadersPolicySecurityHeadersConfigArgs>) {
        this.securityHeadersConfig = value
    }

    /**
     * @param value A configuration for enabling the Server-Timing header in HTTP responses sent from CloudFront. See Server Timing Headers Config for more information.
     */
    @JvmName("jaaictodxcksvjqk")
    public suspend
    fun serverTimingHeadersConfig(`value`: Output<ResponseHeadersPolicyServerTimingHeadersConfigArgs>) {
        this.serverTimingHeadersConfig = value
    }

    /**
     * @param value A comment to describe the response headers policy. The comment cannot be longer than 128 characters.
     */
    @JvmName("eexchpmhcjuendlm")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value A configuration for a set of HTTP response headers that are used for Cross-Origin Resource Sharing (CORS). See Cors Config for more information.
     */
    @JvmName("enksuaebjkvmwsxj")
    public suspend fun corsConfig(`value`: ResponseHeadersPolicyCorsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsConfig = mapped
    }

    /**
     * @param argument A configuration for a set of HTTP response headers that are used for Cross-Origin Resource Sharing (CORS). See Cors Config for more information.
     */
    @JvmName("nfvksmtxadtxebxm")
    public suspend
    fun corsConfig(argument: suspend ResponseHeadersPolicyCorsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResponseHeadersPolicyCorsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.corsConfig = mapped
    }

    /**
     * @param value Object that contains an attribute `items` that contains a list of custom headers. See Custom Header for more information.
     */
    @JvmName("hbpbgnlgumtsxhrb")
    public suspend fun customHeadersConfig(`value`: ResponseHeadersPolicyCustomHeadersConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHeadersConfig = mapped
    }

    /**
     * @param argument Object that contains an attribute `items` that contains a list of custom headers. See Custom Header for more information.
     */
    @JvmName("hdcgtthbcdbdtpcf")
    public suspend
    fun customHeadersConfig(argument: suspend ResponseHeadersPolicyCustomHeadersConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResponseHeadersPolicyCustomHeadersConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customHeadersConfig = mapped
    }

    /**
     * @param value The current version of the response headers policy.
     */
    @JvmName("drrbaupdanvjnsjp")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value A unique name to identify the response headers policy.
     */
    @JvmName("rxguryohvhscgpuq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A configuration for a set of HTTP headers to remove from the HTTP response. Object that contains an attribute `items` that contains a list of headers. See Remove Header for more information.
     */
    @JvmName("bslgobtpwdatchof")
    public suspend fun removeHeadersConfig(`value`: ResponseHeadersPolicyRemoveHeadersConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.removeHeadersConfig = mapped
    }

    /**
     * @param argument A configuration for a set of HTTP headers to remove from the HTTP response. Object that contains an attribute `items` that contains a list of headers. See Remove Header for more information.
     */
    @JvmName("ovsoxuxewwifmmbs")
    public suspend
    fun removeHeadersConfig(argument: suspend ResponseHeadersPolicyRemoveHeadersConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResponseHeadersPolicyRemoveHeadersConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.removeHeadersConfig = mapped
    }

    /**
     * @param value A configuration for a set of security-related HTTP response headers. See Security Headers Config for more information.
     */
    @JvmName("gnwebjtreuptutlf")
    public suspend
    fun securityHeadersConfig(`value`: ResponseHeadersPolicySecurityHeadersConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityHeadersConfig = mapped
    }

    /**
     * @param argument A configuration for a set of security-related HTTP response headers. See Security Headers Config for more information.
     */
    @JvmName("pwfftyomrknnfoqo")
    public suspend
    fun securityHeadersConfig(argument: suspend ResponseHeadersPolicySecurityHeadersConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResponseHeadersPolicySecurityHeadersConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.securityHeadersConfig = mapped
    }

    /**
     * @param value A configuration for enabling the Server-Timing header in HTTP responses sent from CloudFront. See Server Timing Headers Config for more information.
     */
    @JvmName("yuvqnsdsxpduchba")
    public suspend
    fun serverTimingHeadersConfig(`value`: ResponseHeadersPolicyServerTimingHeadersConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverTimingHeadersConfig = mapped
    }

    /**
     * @param argument A configuration for enabling the Server-Timing header in HTTP responses sent from CloudFront. See Server Timing Headers Config for more information.
     */
    @JvmName("lgkkgmaghifcagkl")
    public suspend
    fun serverTimingHeadersConfig(argument: suspend ResponseHeadersPolicyServerTimingHeadersConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResponseHeadersPolicyServerTimingHeadersConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serverTimingHeadersConfig = mapped
    }

    internal fun build(): ResponseHeadersPolicyArgs = ResponseHeadersPolicyArgs(
        comment = comment,
        corsConfig = corsConfig,
        customHeadersConfig = customHeadersConfig,
        etag = etag,
        name = name,
        removeHeadersConfig = removeHeadersConfig,
        securityHeadersConfig = securityHeadersConfig,
        serverTimingHeadersConfig = serverTimingHeadersConfig,
    )
}
