@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cookiesConfig Whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Cookies Config for more information.
 * @property enableAcceptEncodingBrotli Flag determines whether the Accept-Encoding HTTP header is included in the cache key and in requests that CloudFront sends to the origin.
 * @property enableAcceptEncodingGzip Whether the Accept-Encoding HTTP header is included in the cache key and in requests sent to the origin by CloudFront.
 * @property headersConfig Whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Headers Config for more information.
 * @property queryStringsConfig Whether any URL query strings in viewer requests are included in the cache key. It also automatically includes these query strings in requests that CloudFront sends to the origin. Please refer to the Query String Config for more information.
 */
public data class CachePolicyParametersInCacheKeyAndForwardedToOriginArgs(
    public val cookiesConfig:
    Output<CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs>,
    public val enableAcceptEncodingBrotli: Output<Boolean>? = null,
    public val enableAcceptEncodingGzip: Output<Boolean>? = null,
    public val headersConfig:
    Output<CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs>,
    public val queryStringsConfig:
    Output<CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginArgs =
        com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginArgs.builder()
            .cookiesConfig(cookiesConfig.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableAcceptEncodingBrotli(enableAcceptEncodingBrotli?.applyValue({ args0 -> args0 }))
            .enableAcceptEncodingGzip(enableAcceptEncodingGzip?.applyValue({ args0 -> args0 }))
            .headersConfig(headersConfig.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryStringsConfig(
                queryStringsConfig.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [CachePolicyParametersInCacheKeyAndForwardedToOriginArgs].
 */
@PulumiTagMarker
public class CachePolicyParametersInCacheKeyAndForwardedToOriginArgsBuilder internal constructor() {
    private var cookiesConfig:
        Output<CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs>? = null

    private var enableAcceptEncodingBrotli: Output<Boolean>? = null

    private var enableAcceptEncodingGzip: Output<Boolean>? = null

    private var headersConfig:
        Output<CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs>? = null

    private var queryStringsConfig:
        Output<CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs>? = null

    /**
     * @param value Whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Cookies Config for more information.
     */
    @JvmName("ydapwbcwfcbwpjbd")
    public suspend
    fun cookiesConfig(`value`: Output<CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs>) {
        this.cookiesConfig = value
    }

    /**
     * @param value Flag determines whether the Accept-Encoding HTTP header is included in the cache key and in requests that CloudFront sends to the origin.
     */
    @JvmName("iiiptsuhfptddkdw")
    public suspend fun enableAcceptEncodingBrotli(`value`: Output<Boolean>) {
        this.enableAcceptEncodingBrotli = value
    }

    /**
     * @param value Whether the Accept-Encoding HTTP header is included in the cache key and in requests sent to the origin by CloudFront.
     */
    @JvmName("xneqlikgwbkujgct")
    public suspend fun enableAcceptEncodingGzip(`value`: Output<Boolean>) {
        this.enableAcceptEncodingGzip = value
    }

    /**
     * @param value Whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Headers Config for more information.
     */
    @JvmName("mfketllycaogmoqk")
    public suspend
    fun headersConfig(`value`: Output<CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs>) {
        this.headersConfig = value
    }

    /**
     * @param value Whether any URL query strings in viewer requests are included in the cache key. It also automatically includes these query strings in requests that CloudFront sends to the origin. Please refer to the Query String Config for more information.
     */
    @JvmName("pilokqncvuwrnqmv")
    public suspend
    fun queryStringsConfig(`value`: Output<CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs>) {
        this.queryStringsConfig = value
    }

    /**
     * @param value Whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Cookies Config for more information.
     */
    @JvmName("awpnhnygacafnpga")
    public suspend
    fun cookiesConfig(`value`: CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cookiesConfig = mapped
    }

    /**
     * @param argument Whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Cookies Config for more information.
     */
    @JvmName("hhpkwuqkuthonmde")
    public suspend
    fun cookiesConfig(argument: suspend CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookiesConfig = mapped
    }

    /**
     * @param value Flag determines whether the Accept-Encoding HTTP header is included in the cache key and in requests that CloudFront sends to the origin.
     */
    @JvmName("athraremamqhwwwt")
    public suspend fun enableAcceptEncodingBrotli(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAcceptEncodingBrotli = mapped
    }

    /**
     * @param value Whether the Accept-Encoding HTTP header is included in the cache key and in requests sent to the origin by CloudFront.
     */
    @JvmName("kelvlnxiblsrfdwg")
    public suspend fun enableAcceptEncodingGzip(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAcceptEncodingGzip = mapped
    }

    /**
     * @param value Whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Headers Config for more information.
     */
    @JvmName("bslntjnglnakprca")
    public suspend
    fun headersConfig(`value`: CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headersConfig = mapped
    }

    /**
     * @param argument Whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Headers Config for more information.
     */
    @JvmName("xpapxjfkxtxlrrui")
    public suspend
    fun headersConfig(argument: suspend CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.headersConfig = mapped
    }

    /**
     * @param value Whether any URL query strings in viewer requests are included in the cache key. It also automatically includes these query strings in requests that CloudFront sends to the origin. Please refer to the Query String Config for more information.
     */
    @JvmName("ldiydhidmijfdnsb")
    public suspend
    fun queryStringsConfig(`value`: CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringsConfig = mapped
    }

    /**
     * @param argument Whether any URL query strings in viewer requests are included in the cache key. It also automatically includes these query strings in requests that CloudFront sends to the origin. Please refer to the Query String Config for more information.
     */
    @JvmName("wunasdvdcsisygyg")
    public suspend
    fun queryStringsConfig(argument: suspend CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryStringsConfig = mapped
    }

    internal fun build(): CachePolicyParametersInCacheKeyAndForwardedToOriginArgs =
        CachePolicyParametersInCacheKeyAndForwardedToOriginArgs(
            cookiesConfig = cookiesConfig ?: throw PulumiNullFieldException("cookiesConfig"),
            enableAcceptEncodingBrotli = enableAcceptEncodingBrotli,
            enableAcceptEncodingGzip = enableAcceptEncodingGzip,
            headersConfig = headersConfig ?: throw PulumiNullFieldException("headersConfig"),
            queryStringsConfig = queryStringsConfig ?: throw PulumiNullFieldException("queryStringsConfig"),
        )
}
