@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cookieBehavior Whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values for `cookie_behavior` are `none`, `whitelist`, `allExcept`, and `all`.
 * @property cookies Object that contains a list of cookie names. See Items for more information.
 */
public data class CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs(
    public val cookieBehavior: Output<String>,
    public val cookies:
    Output<CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs =
        com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs.builder()
            .cookieBehavior(cookieBehavior.applyValue({ args0 -> args0 }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs].
 */
@PulumiTagMarker
public class CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgsBuilder internal
constructor() {
    private var cookieBehavior: Output<String>? = null

    private var cookies:
        Output<CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs>? = null

    /**
     * @param value Whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values for `cookie_behavior` are `none`, `whitelist`, `allExcept`, and `all`.
     */
    @JvmName("rmjxvoypycstwgyf")
    public suspend fun cookieBehavior(`value`: Output<String>) {
        this.cookieBehavior = value
    }

    /**
     * @param value Object that contains a list of cookie names. See Items for more information.
     */
    @JvmName("wighjjoixbfqypmw")
    public suspend
    fun cookies(`value`: Output<CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values for `cookie_behavior` are `none`, `whitelist`, `allExcept`, and `all`.
     */
    @JvmName("adnrugrtulhwikmy")
    public suspend fun cookieBehavior(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cookieBehavior = mapped
    }

    /**
     * @param value Object that contains a list of cookie names. See Items for more information.
     */
    @JvmName("hcodjcausbnsklsw")
    public suspend
    fun cookies(`value`: CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Object that contains a list of cookie names. See Items for more information.
     */
    @JvmName("euehkehlegxmeiko")
    public suspend
    fun cookies(argument: suspend CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    internal fun build(): CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs =
        CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs(
            cookieBehavior = cookieBehavior ?: throw PulumiNullFieldException("cookieBehavior"),
            cookies = cookies,
        )
}
