@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property items List of item names, such as cookies, headers, or query strings.
 */
public data class CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs(
    public val items: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs =
        com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs.builder()
            .items(items?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs].
 */
@PulumiTagMarker
public class CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgsBuilder
internal constructor() {
    private var items: Output<List<String>>? = null

    /**
     * @param value List of item names, such as cookies, headers, or query strings.
     */
    @JvmName("rmmqdarkcpvijcap")
    public suspend fun items(`value`: Output<List<String>>) {
        this.items = value
    }

    @JvmName("hjudlsjkaebqxgwr")
    public suspend fun items(vararg values: Output<String>) {
        this.items = Output.all(values.asList())
    }

    /**
     * @param values List of item names, such as cookies, headers, or query strings.
     */
    @JvmName("untqiysstfchyypp")
    public suspend fun items(values: List<Output<String>>) {
        this.items = Output.all(values)
    }

    /**
     * @param value List of item names, such as cookies, headers, or query strings.
     */
    @JvmName("ejynpmeansfcfenq")
    public suspend fun items(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param values List of item names, such as cookies, headers, or query strings.
     */
    @JvmName("hqtlwtnuxvhbnlld")
    public suspend fun items(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.items = mapped
    }

    internal fun build(): CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs =
        CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs(
            items = items,
        )
}
