@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property headerBehavior Whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values for `header_behavior` are `none` and `whitelist`.
 * @property headers Object contains a list of header names. See Items for more information.
 */
public data class CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs(
    public val headerBehavior: Output<String>? = null,
    public val headers:
    Output<CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs =
        com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs.builder()
            .headerBehavior(headerBehavior?.applyValue({ args0 -> args0 }))
            .headers(headers?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs].
 */
@PulumiTagMarker
public class CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgsBuilder internal
constructor() {
    private var headerBehavior: Output<String>? = null

    private var headers:
        Output<CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs>? = null

    /**
     * @param value Whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values for `header_behavior` are `none` and `whitelist`.
     */
    @JvmName("uouapbqafjxsajld")
    public suspend fun headerBehavior(`value`: Output<String>) {
        this.headerBehavior = value
    }

    /**
     * @param value Object contains a list of header names. See Items for more information.
     */
    @JvmName("qdvyxbnphbigfixa")
    public suspend
    fun headers(`value`: Output<CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs>) {
        this.headers = value
    }

    /**
     * @param value Whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values for `header_behavior` are `none` and `whitelist`.
     */
    @JvmName("dmlexjkrpdutijam")
    public suspend fun headerBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerBehavior = mapped
    }

    /**
     * @param value Object contains a list of header names. See Items for more information.
     */
    @JvmName("ceihwbbxihpawutt")
    public suspend
    fun headers(`value`: CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Object contains a list of header names. See Items for more information.
     */
    @JvmName("gehaottvslnxjmjt")
    public suspend
    fun headers(argument: suspend CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgsBuilder.() -> Unit) {
        val toBeMapped =
            CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    internal fun build(): CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs =
        CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs(
            headerBehavior = headerBehavior,
            headers = headers,
        )
}
