@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property items List of item names, such as cookies, headers, or query strings.
 */
public data class CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs(
    public val items: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs =
        com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs.builder()
            .items(items?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs].
 */
@PulumiTagMarker
public class CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgsBuilder
internal constructor() {
    private var items: Output<List<String>>? = null

    /**
     * @param value List of item names, such as cookies, headers, or query strings.
     */
    @JvmName("avmltgaqatfnncfy")
    public suspend fun items(`value`: Output<List<String>>) {
        this.items = value
    }

    @JvmName("mowfvlwkvhdvamjk")
    public suspend fun items(vararg values: Output<String>) {
        this.items = Output.all(values.asList())
    }

    /**
     * @param values List of item names, such as cookies, headers, or query strings.
     */
    @JvmName("phvvwkprncuyujlo")
    public suspend fun items(values: List<Output<String>>) {
        this.items = Output.all(values)
    }

    /**
     * @param value List of item names, such as cookies, headers, or query strings.
     */
    @JvmName("nmmacqfilmhunfll")
    public suspend fun items(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param values List of item names, such as cookies, headers, or query strings.
     */
    @JvmName("emixwslvmjgpnpau")
    public suspend fun items(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.items = mapped
    }

    internal fun build(): CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs =
        CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs(
            items = items,
        )
}
