@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property singleHeaderConfig Determines which HTTP requests are sent to the staging distribution. See `single_header_config`.
 * @property singleWeightConfig Contains the percentage of traffic to send to the staging distribution. See `single_weight_config`.
 * @property type Type of traffic configuration. Valid values are `SingleWeight` and `SingleHeader`.
 */
public data class ContinuousDeploymentPolicyTrafficConfigArgs(
    public val singleHeaderConfig:
    Output<ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs>? = null,
    public val singleWeightConfig:
    Output<ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigArgs =
        com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigArgs.builder()
            .singleHeaderConfig(
                singleHeaderConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .singleWeightConfig(
                singleWeightConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContinuousDeploymentPolicyTrafficConfigArgs].
 */
@PulumiTagMarker
public class ContinuousDeploymentPolicyTrafficConfigArgsBuilder internal constructor() {
    private var singleHeaderConfig:
        Output<ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs>? = null

    private var singleWeightConfig:
        Output<ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Determines which HTTP requests are sent to the staging distribution. See `single_header_config`.
     */
    @JvmName("gomivdratvmsgjmd")
    public suspend
    fun singleHeaderConfig(`value`: Output<ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs>) {
        this.singleHeaderConfig = value
    }

    /**
     * @param value Contains the percentage of traffic to send to the staging distribution. See `single_weight_config`.
     */
    @JvmName("xlfiokkhctgddcye")
    public suspend
    fun singleWeightConfig(`value`: Output<ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs>) {
        this.singleWeightConfig = value
    }

    /**
     * @param value Type of traffic configuration. Valid values are `SingleWeight` and `SingleHeader`.
     */
    @JvmName("qlgbsbiybrwlvllr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Determines which HTTP requests are sent to the staging distribution. See `single_header_config`.
     */
    @JvmName("ehjenunjmoomjrfx")
    public suspend
    fun singleHeaderConfig(`value`: ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeaderConfig = mapped
    }

    /**
     * @param argument Determines which HTTP requests are sent to the staging distribution. See `single_header_config`.
     */
    @JvmName("dmkubjauwvnxrwvw")
    public suspend
    fun singleHeaderConfig(argument: suspend ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeaderConfig = mapped
    }

    /**
     * @param value Contains the percentage of traffic to send to the staging distribution. See `single_weight_config`.
     */
    @JvmName("upibtjxaasjkemqn")
    public suspend
    fun singleWeightConfig(`value`: ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleWeightConfig = mapped
    }

    /**
     * @param argument Contains the percentage of traffic to send to the staging distribution. See `single_weight_config`.
     */
    @JvmName("ivfuvvjanyflpjtg")
    public suspend
    fun singleWeightConfig(argument: suspend ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleWeightConfig = mapped
    }

    /**
     * @param value Type of traffic configuration. Valid values are `SingleWeight` and `SingleHeader`.
     */
    @JvmName("blfwfckhqlmpxrcp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ContinuousDeploymentPolicyTrafficConfigArgs =
        ContinuousDeploymentPolicyTrafficConfigArgs(
            singleHeaderConfig = singleHeaderConfig,
            singleWeightConfig = singleWeightConfig,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
