@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property header Request header name to send to the staging distribution. The header must contain the prefix `aws-cf-cd-`.
 * @property value Request header value.
 */
public data class ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs(
    public val `header`: Output<String>,
    public val `value`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs =
        com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs.builder()
            .`header`(`header`.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs].
 */
@PulumiTagMarker
public class ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgsBuilder internal
constructor() {
    private var `header`: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Request header name to send to the staging distribution. The header must contain the prefix `aws-cf-cd-`.
     */
    @JvmName("gmimlywtvqupfgnp")
    public suspend fun `header`(`value`: Output<String>) {
        this.`header` = value
    }

    /**
     * @param value Request header value.
     */
    @JvmName("njtoxipwawckhaul")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Request header name to send to the staging distribution. The header must contain the prefix `aws-cf-cd-`.
     */
    @JvmName("pnpyxnmjppuccqkl")
    public suspend fun `header`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`header` = mapped
    }

    /**
     * @param value Request header value.
     */
    @JvmName("lydxxhpqfsqovllc")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs =
        ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs(
            `header` = `header` ?: throw PulumiNullFieldException("header"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
