@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sessionStickinessConfig Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to the staging distribution, while others are sent to the primary distribution. Define the session duration using TTL values. See `session_stickiness_config`.
 * @property weight The percentage of traffic to send to a staging distribution, expressed as a decimal number between `0` and `.15`.
 */
public data class ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs(
    public val sessionStickinessConfig:
    Output<ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs>? =
        null,
    public val weight: Output<Double>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs =
        com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs.builder()
            .sessionStickinessConfig(
                sessionStickinessConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .weight(weight.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs].
 */
@PulumiTagMarker
public class ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgsBuilder internal
constructor() {
    private var sessionStickinessConfig:
        Output<ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs>? =
        null

    private var weight: Output<Double>? = null

    /**
     * @param value Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to the staging distribution, while others are sent to the primary distribution. Define the session duration using TTL values. See `session_stickiness_config`.
     */
    @JvmName("lsacyrocybmjfqca")
    public suspend
    fun sessionStickinessConfig(`value`: Output<ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs>) {
        this.sessionStickinessConfig = value
    }

    /**
     * @param value The percentage of traffic to send to a staging distribution, expressed as a decimal number between `0` and `.15`.
     */
    @JvmName("ljhenaasivldobav")
    public suspend fun weight(`value`: Output<Double>) {
        this.weight = value
    }

    /**
     * @param value Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to the staging distribution, while others are sent to the primary distribution. Define the session duration using TTL values. See `session_stickiness_config`.
     */
    @JvmName("fpwedbsxxswppnuu")
    public suspend
    fun sessionStickinessConfig(`value`: ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionStickinessConfig = mapped
    }

    /**
     * @param argument Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This prevents the potentially inconsistent experience of sending some of a given user's requests to the staging distribution, while others are sent to the primary distribution. Define the session duration using TTL values. See `session_stickiness_config`.
     */
    @JvmName("jnktnkfubfxnaqct")
    public suspend
    fun sessionStickinessConfig(argument: suspend ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sessionStickinessConfig = mapped
    }

    /**
     * @param value The percentage of traffic to send to a staging distribution, expressed as a decimal number between `0` and `.15`.
     */
    @JvmName("pubbmhtwiqoltrcy")
    public suspend fun weight(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs =
        ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs(
            sessionStickinessConfig = sessionStickinessConfig,
            weight = weight ?: throw PulumiNullFieldException("weight"),
        )
}
