@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property idleTtl The amount of time in seconds after which sessions will cease if no requests are received. Valid values are `300` – `3600` (5–60 minutes). The value must be less than or equal to `maximum_ttl`.
 * @property maximumTtl The maximum amount of time in seconds to consider requests from the viewer as being part of the same session. Valid values are `300` – `3600` (5–60 minutes). The value must be greater than or equal to `idle_ttl`.
 */
public data class
ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs(
    public val idleTtl: Output<Int>,
    public val maximumTtl: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs =
        com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs.builder()
            .idleTtl(idleTtl.applyValue({ args0 -> args0 }))
            .maximumTtl(maximumTtl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs].
 */
@PulumiTagMarker
public class
ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgsBuilder
internal constructor() {
    private var idleTtl: Output<Int>? = null

    private var maximumTtl: Output<Int>? = null

    /**
     * @param value The amount of time in seconds after which sessions will cease if no requests are received. Valid values are `300` – `3600` (5–60 minutes). The value must be less than or equal to `maximum_ttl`.
     */
    @JvmName("apdfkaxphvnfcmuo")
    public suspend fun idleTtl(`value`: Output<Int>) {
        this.idleTtl = value
    }

    /**
     * @param value The maximum amount of time in seconds to consider requests from the viewer as being part of the same session. Valid values are `300` – `3600` (5–60 minutes). The value must be greater than or equal to `idle_ttl`.
     */
    @JvmName("lteyqcmihugwesop")
    public suspend fun maximumTtl(`value`: Output<Int>) {
        this.maximumTtl = value
    }

    /**
     * @param value The amount of time in seconds after which sessions will cease if no requests are received. Valid values are `300` – `3600` (5–60 minutes). The value must be less than or equal to `maximum_ttl`.
     */
    @JvmName("eudmarithnuxytad")
    public suspend fun idleTtl(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.idleTtl = mapped
    }

    /**
     * @param value The maximum amount of time in seconds to consider requests from the viewer as being part of the same session. Valid values are `300` – `3600` (5–60 minutes). The value must be greater than or equal to `idle_ttl`.
     */
    @JvmName("upqjicqcnnjibayo")
    public suspend fun maximumTtl(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maximumTtl = mapped
    }

    internal fun build():
        ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs =
        ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs(
            idleTtl = idleTtl ?: throw PulumiNullFieldException("idleTtl"),
            maximumTtl = maximumTtl ?: throw PulumiNullFieldException("maximumTtl"),
        )
}
