@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowedMethods Controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin.
 * @property cachePolicyId Unique identifier of the cache policy that is attached to the cache behavior. If configuring the `default_cache_behavior` either `cache_policy_id` or `forwarded_values` must be set.
 * @property cachedMethods Controls whether CloudFront caches the response to requests using the specified HTTP methods.
 * @property compress Whether you want CloudFront to automatically compress content for web requests that include `Accept-Encoding: gzip` in the request header (default: `false`).
 * @property defaultTtl Default amount of time (in seconds) that an object is in a CloudFront cache before CloudFront forwards another request in the absence of an `Cache-Control max-age` or `Expires` header.
 * @property fieldLevelEncryptionId Field level encryption configuration ID.
 * @property forwardedValues The forwarded values configuration that specifies how CloudFront handles query strings, cookies and headers (maximum one).
 * @property functionAssociations A config block that triggers a cloudfront function with specific actions (maximum 2).
 * @property lambdaFunctionAssociations A config block that triggers a lambda function with specific actions (maximum 4).
 * @property maxTtl Maximum amount of time (in seconds) that an object is in a CloudFront cache before CloudFront forwards another request to your origin to determine whether the object has been updated. Only effective in the presence of `Cache-Control max-age`, `Cache-Control s-maxage`, and `Expires` headers.
 * @property minTtl Minimum amount of time that you want objects to stay in CloudFront caches before CloudFront queries your origin to see whether the object has been updated. Defaults to 0 seconds.
 * @property originRequestPolicyId Unique identifier of the origin request policy that is attached to the behavior.
 * @property realtimeLogConfigArn ARN of the real-time log configuration that is attached to this cache behavior.
 * @property responseHeadersPolicyId Identifier for a response headers policy.
 * @property smoothStreaming Indicates whether you want to distribute media files in Microsoft Smooth Streaming format using the origin that is associated with this cache behavior.
 * @property targetOriginId Value of ID for the origin that you want CloudFront to route requests to when a request matches the path pattern either for a cache behavior or for the default cache behavior.
 * @property trustedKeyGroups List of key group IDs that CloudFront can use to validate signed URLs or signed cookies. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
 * @property trustedSigners List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
 * @property viewerProtocolPolicy Use this element to specify the protocol that users can use to access the files in the origin specified by TargetOriginId when a request matches the path pattern in PathPattern. One of `allow-all`, `https-only`, or `redirect-to-https`.
 */
public data class DistributionDefaultCacheBehaviorArgs(
    public val allowedMethods: Output<List<String>>,
    public val cachePolicyId: Output<String>? = null,
    public val cachedMethods: Output<List<String>>,
    public val compress: Output<Boolean>? = null,
    public val defaultTtl: Output<Int>? = null,
    public val fieldLevelEncryptionId: Output<String>? = null,
    public val forwardedValues: Output<DistributionDefaultCacheBehaviorForwardedValuesArgs>? = null,
    public val functionAssociations:
    Output<List<DistributionDefaultCacheBehaviorFunctionAssociationArgs>>? = null,
    public val lambdaFunctionAssociations:
    Output<List<DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs>>? = null,
    public val maxTtl: Output<Int>? = null,
    public val minTtl: Output<Int>? = null,
    public val originRequestPolicyId: Output<String>? = null,
    public val realtimeLogConfigArn: Output<String>? = null,
    public val responseHeadersPolicyId: Output<String>? = null,
    public val smoothStreaming: Output<Boolean>? = null,
    public val targetOriginId: Output<String>,
    public val trustedKeyGroups: Output<List<String>>? = null,
    public val trustedSigners: Output<List<String>>? = null,
    public val viewerProtocolPolicy: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorArgs.builder()
            .allowedMethods(allowedMethods.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cachePolicyId(cachePolicyId?.applyValue({ args0 -> args0 }))
            .cachedMethods(cachedMethods.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .compress(compress?.applyValue({ args0 -> args0 }))
            .defaultTtl(defaultTtl?.applyValue({ args0 -> args0 }))
            .fieldLevelEncryptionId(fieldLevelEncryptionId?.applyValue({ args0 -> args0 }))
            .forwardedValues(forwardedValues?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .functionAssociations(
                functionAssociations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .lambdaFunctionAssociations(
                lambdaFunctionAssociations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .maxTtl(maxTtl?.applyValue({ args0 -> args0 }))
            .minTtl(minTtl?.applyValue({ args0 -> args0 }))
            .originRequestPolicyId(originRequestPolicyId?.applyValue({ args0 -> args0 }))
            .realtimeLogConfigArn(realtimeLogConfigArn?.applyValue({ args0 -> args0 }))
            .responseHeadersPolicyId(responseHeadersPolicyId?.applyValue({ args0 -> args0 }))
            .smoothStreaming(smoothStreaming?.applyValue({ args0 -> args0 }))
            .targetOriginId(targetOriginId.applyValue({ args0 -> args0 }))
            .trustedKeyGroups(trustedKeyGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .trustedSigners(trustedSigners?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .viewerProtocolPolicy(viewerProtocolPolicy.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionDefaultCacheBehaviorArgs].
 */
@PulumiTagMarker
public class DistributionDefaultCacheBehaviorArgsBuilder internal constructor() {
    private var allowedMethods: Output<List<String>>? = null

    private var cachePolicyId: Output<String>? = null

    private var cachedMethods: Output<List<String>>? = null

    private var compress: Output<Boolean>? = null

    private var defaultTtl: Output<Int>? = null

    private var fieldLevelEncryptionId: Output<String>? = null

    private var forwardedValues: Output<DistributionDefaultCacheBehaviorForwardedValuesArgs>? = null

    private var functionAssociations:
        Output<List<DistributionDefaultCacheBehaviorFunctionAssociationArgs>>? = null

    private var lambdaFunctionAssociations:
        Output<List<DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs>>? = null

    private var maxTtl: Output<Int>? = null

    private var minTtl: Output<Int>? = null

    private var originRequestPolicyId: Output<String>? = null

    private var realtimeLogConfigArn: Output<String>? = null

    private var responseHeadersPolicyId: Output<String>? = null

    private var smoothStreaming: Output<Boolean>? = null

    private var targetOriginId: Output<String>? = null

    private var trustedKeyGroups: Output<List<String>>? = null

    private var trustedSigners: Output<List<String>>? = null

    private var viewerProtocolPolicy: Output<String>? = null

    /**
     * @param value Controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin.
     */
    @JvmName("hnnqnximtfchcayi")
    public suspend fun allowedMethods(`value`: Output<List<String>>) {
        this.allowedMethods = value
    }

    @JvmName("bietgvckrgddtrcl")
    public suspend fun allowedMethods(vararg values: Output<String>) {
        this.allowedMethods = Output.all(values.asList())
    }

    /**
     * @param values Controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin.
     */
    @JvmName("lhrdgrwvuqbxmuae")
    public suspend fun allowedMethods(values: List<Output<String>>) {
        this.allowedMethods = Output.all(values)
    }

    /**
     * @param value Unique identifier of the cache policy that is attached to the cache behavior. If configuring the `default_cache_behavior` either `cache_policy_id` or `forwarded_values` must be set.
     */
    @JvmName("datltxmenyknasbm")
    public suspend fun cachePolicyId(`value`: Output<String>) {
        this.cachePolicyId = value
    }

    /**
     * @param value Controls whether CloudFront caches the response to requests using the specified HTTP methods.
     */
    @JvmName("bjaxagetskvsmjee")
    public suspend fun cachedMethods(`value`: Output<List<String>>) {
        this.cachedMethods = value
    }

    @JvmName("barjeyfxcfxanlgw")
    public suspend fun cachedMethods(vararg values: Output<String>) {
        this.cachedMethods = Output.all(values.asList())
    }

    /**
     * @param values Controls whether CloudFront caches the response to requests using the specified HTTP methods.
     */
    @JvmName("fwnkxjthyfcjsrmr")
    public suspend fun cachedMethods(values: List<Output<String>>) {
        this.cachedMethods = Output.all(values)
    }

    /**
     * @param value Whether you want CloudFront to automatically compress content for web requests that include `Accept-Encoding: gzip` in the request header (default: `false`).
     */
    @JvmName("rkhhrduejpksuxpu")
    public suspend fun compress(`value`: Output<Boolean>) {
        this.compress = value
    }

    /**
     * @param value Default amount of time (in seconds) that an object is in a CloudFront cache before CloudFront forwards another request in the absence of an `Cache-Control max-age` or `Expires` header.
     */
    @JvmName("vfsggeegtqafdljm")
    public suspend fun defaultTtl(`value`: Output<Int>) {
        this.defaultTtl = value
    }

    /**
     * @param value Field level encryption configuration ID.
     */
    @JvmName("wqmbpcmvrrfnudop")
    public suspend fun fieldLevelEncryptionId(`value`: Output<String>) {
        this.fieldLevelEncryptionId = value
    }

    /**
     * @param value The forwarded values configuration that specifies how CloudFront handles query strings, cookies and headers (maximum one).
     */
    @JvmName("yaimxdvknxfgofml")
    public suspend
    fun forwardedValues(`value`: Output<DistributionDefaultCacheBehaviorForwardedValuesArgs>) {
        this.forwardedValues = value
    }

    /**
     * @param value A config block that triggers a cloudfront function with specific actions (maximum 2).
     */
    @JvmName("tdndriijygftonew")
    public suspend
    fun functionAssociations(`value`: Output<List<DistributionDefaultCacheBehaviorFunctionAssociationArgs>>) {
        this.functionAssociations = value
    }

    @JvmName("hrblddcndpjgayvq")
    public suspend fun functionAssociations(
        vararg
        values: Output<DistributionDefaultCacheBehaviorFunctionAssociationArgs>,
    ) {
        this.functionAssociations = Output.all(values.asList())
    }

    /**
     * @param values A config block that triggers a cloudfront function with specific actions (maximum 2).
     */
    @JvmName("oiriiecsvypiecno")
    public suspend
    fun functionAssociations(values: List<Output<DistributionDefaultCacheBehaviorFunctionAssociationArgs>>) {
        this.functionAssociations = Output.all(values)
    }

    /**
     * @param value A config block that triggers a lambda function with specific actions (maximum 4).
     */
    @JvmName("kdnsubhxwtoaglwm")
    public suspend
    fun lambdaFunctionAssociations(`value`: Output<List<DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs>>) {
        this.lambdaFunctionAssociations = value
    }

    @JvmName("fitgcdtrurycicfe")
    public suspend fun lambdaFunctionAssociations(
        vararg
        values: Output<DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs>,
    ) {
        this.lambdaFunctionAssociations = Output.all(values.asList())
    }

    /**
     * @param values A config block that triggers a lambda function with specific actions (maximum 4).
     */
    @JvmName("nhnkugfrforwmpxe")
    public suspend
    fun lambdaFunctionAssociations(values: List<Output<DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs>>) {
        this.lambdaFunctionAssociations = Output.all(values)
    }

    /**
     * @param value Maximum amount of time (in seconds) that an object is in a CloudFront cache before CloudFront forwards another request to your origin to determine whether the object has been updated. Only effective in the presence of `Cache-Control max-age`, `Cache-Control s-maxage`, and `Expires` headers.
     */
    @JvmName("twayaagayllpgcyp")
    public suspend fun maxTtl(`value`: Output<Int>) {
        this.maxTtl = value
    }

    /**
     * @param value Minimum amount of time that you want objects to stay in CloudFront caches before CloudFront queries your origin to see whether the object has been updated. Defaults to 0 seconds.
     */
    @JvmName("ledyeetepbsfuvve")
    public suspend fun minTtl(`value`: Output<Int>) {
        this.minTtl = value
    }

    /**
     * @param value Unique identifier of the origin request policy that is attached to the behavior.
     */
    @JvmName("fbqvfcyouhqjyeon")
    public suspend fun originRequestPolicyId(`value`: Output<String>) {
        this.originRequestPolicyId = value
    }

    /**
     * @param value ARN of the real-time log configuration that is attached to this cache behavior.
     */
    @JvmName("kkxfksbbthovjmin")
    public suspend fun realtimeLogConfigArn(`value`: Output<String>) {
        this.realtimeLogConfigArn = value
    }

    /**
     * @param value Identifier for a response headers policy.
     */
    @JvmName("rskxyptloamjvswx")
    public suspend fun responseHeadersPolicyId(`value`: Output<String>) {
        this.responseHeadersPolicyId = value
    }

    /**
     * @param value Indicates whether you want to distribute media files in Microsoft Smooth Streaming format using the origin that is associated with this cache behavior.
     */
    @JvmName("qnvkdvdpiqyrykuc")
    public suspend fun smoothStreaming(`value`: Output<Boolean>) {
        this.smoothStreaming = value
    }

    /**
     * @param value Value of ID for the origin that you want CloudFront to route requests to when a request matches the path pattern either for a cache behavior or for the default cache behavior.
     */
    @JvmName("muankukiiorgjlwv")
    public suspend fun targetOriginId(`value`: Output<String>) {
        this.targetOriginId = value
    }

    /**
     * @param value List of key group IDs that CloudFront can use to validate signed URLs or signed cookies. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("twbdkdttrxykaugm")
    public suspend fun trustedKeyGroups(`value`: Output<List<String>>) {
        this.trustedKeyGroups = value
    }

    @JvmName("sjdfegxtojqxkyoi")
    public suspend fun trustedKeyGroups(vararg values: Output<String>) {
        this.trustedKeyGroups = Output.all(values.asList())
    }

    /**
     * @param values List of key group IDs that CloudFront can use to validate signed URLs or signed cookies. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("mulvnekbrulkreqj")
    public suspend fun trustedKeyGroups(values: List<Output<String>>) {
        this.trustedKeyGroups = Output.all(values)
    }

    /**
     * @param value List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("pgtqsiomaaxqtipb")
    public suspend fun trustedSigners(`value`: Output<List<String>>) {
        this.trustedSigners = value
    }

    @JvmName("jecmunjpygidblxt")
    public suspend fun trustedSigners(vararg values: Output<String>) {
        this.trustedSigners = Output.all(values.asList())
    }

    /**
     * @param values List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("baqsuvnqtaprnpiv")
    public suspend fun trustedSigners(values: List<Output<String>>) {
        this.trustedSigners = Output.all(values)
    }

    /**
     * @param value Use this element to specify the protocol that users can use to access the files in the origin specified by TargetOriginId when a request matches the path pattern in PathPattern. One of `allow-all`, `https-only`, or `redirect-to-https`.
     */
    @JvmName("ifbouwenswotwdhs")
    public suspend fun viewerProtocolPolicy(`value`: Output<String>) {
        this.viewerProtocolPolicy = value
    }

    /**
     * @param value Controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin.
     */
    @JvmName("hjfhnffyhgalpvco")
    public suspend fun allowedMethods(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param values Controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin.
     */
    @JvmName("ocvdxcsvdmmpojlf")
    public suspend fun allowedMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param value Unique identifier of the cache policy that is attached to the cache behavior. If configuring the `default_cache_behavior` either `cache_policy_id` or `forwarded_values` must be set.
     */
    @JvmName("qgunfasavprouyef")
    public suspend fun cachePolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cachePolicyId = mapped
    }

    /**
     * @param value Controls whether CloudFront caches the response to requests using the specified HTTP methods.
     */
    @JvmName("gpkxjyqiuqdshklx")
    public suspend fun cachedMethods(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cachedMethods = mapped
    }

    /**
     * @param values Controls whether CloudFront caches the response to requests using the specified HTTP methods.
     */
    @JvmName("ecooadgmmgkkminh")
    public suspend fun cachedMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cachedMethods = mapped
    }

    /**
     * @param value Whether you want CloudFront to automatically compress content for web requests that include `Accept-Encoding: gzip` in the request header (default: `false`).
     */
    @JvmName("pbujkwqohnyhvucb")
    public suspend fun compress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compress = mapped
    }

    /**
     * @param value Default amount of time (in seconds) that an object is in a CloudFront cache before CloudFront forwards another request in the absence of an `Cache-Control max-age` or `Expires` header.
     */
    @JvmName("xuvcmaukblinjdmx")
    public suspend fun defaultTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultTtl = mapped
    }

    /**
     * @param value Field level encryption configuration ID.
     */
    @JvmName("jwfnljcpweafqotq")
    public suspend fun fieldLevelEncryptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldLevelEncryptionId = mapped
    }

    /**
     * @param value The forwarded values configuration that specifies how CloudFront handles query strings, cookies and headers (maximum one).
     */
    @JvmName("alwtmxrsjtonyerb")
    public suspend
    fun forwardedValues(`value`: DistributionDefaultCacheBehaviorForwardedValuesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedValues = mapped
    }

    /**
     * @param argument The forwarded values configuration that specifies how CloudFront handles query strings, cookies and headers (maximum one).
     */
    @JvmName("vejhhduwfeqbetug")
    public suspend
    fun forwardedValues(argument: suspend DistributionDefaultCacheBehaviorForwardedValuesArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionDefaultCacheBehaviorForwardedValuesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.forwardedValues = mapped
    }

    /**
     * @param value A config block that triggers a cloudfront function with specific actions (maximum 2).
     */
    @JvmName("xpspepyeuxlasejh")
    public suspend
    fun functionAssociations(`value`: List<DistributionDefaultCacheBehaviorFunctionAssociationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionAssociations = mapped
    }

    /**
     * @param argument A config block that triggers a cloudfront function with specific actions (maximum 2).
     */
    @JvmName("ctfqwhcqojmrkiuk")
    public suspend
    fun functionAssociations(argument: List<suspend DistributionDefaultCacheBehaviorFunctionAssociationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionDefaultCacheBehaviorFunctionAssociationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.functionAssociations = mapped
    }

    /**
     * @param argument A config block that triggers a cloudfront function with specific actions (maximum 2).
     */
    @JvmName("cdxqnnjlaqpwpjvg")
    public suspend fun functionAssociations(
        vararg
        argument: suspend DistributionDefaultCacheBehaviorFunctionAssociationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DistributionDefaultCacheBehaviorFunctionAssociationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.functionAssociations = mapped
    }

    /**
     * @param argument A config block that triggers a cloudfront function with specific actions (maximum 2).
     */
    @JvmName("advouwwrtctqkgmw")
    public suspend
    fun functionAssociations(argument: suspend DistributionDefaultCacheBehaviorFunctionAssociationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DistributionDefaultCacheBehaviorFunctionAssociationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.functionAssociations = mapped
    }

    /**
     * @param values A config block that triggers a cloudfront function with specific actions (maximum 2).
     */
    @JvmName("cussbgmmvxyaihgd")
    public suspend fun functionAssociations(
        vararg
        values: DistributionDefaultCacheBehaviorFunctionAssociationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionAssociations = mapped
    }

    /**
     * @param value A config block that triggers a lambda function with specific actions (maximum 4).
     */
    @JvmName("hpghgnvedmncvtue")
    public suspend
    fun lambdaFunctionAssociations(`value`: List<DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaFunctionAssociations = mapped
    }

    /**
     * @param argument A config block that triggers a lambda function with specific actions (maximum 4).
     */
    @JvmName("uxllgkjkmjiswtwx")
    public suspend
    fun lambdaFunctionAssociations(argument: List<suspend DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lambdaFunctionAssociations = mapped
    }

    /**
     * @param argument A config block that triggers a lambda function with specific actions (maximum 4).
     */
    @JvmName("wvnathqhndqkasnf")
    public suspend fun lambdaFunctionAssociations(
        vararg
        argument: suspend DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lambdaFunctionAssociations = mapped
    }

    /**
     * @param argument A config block that triggers a lambda function with specific actions (maximum 4).
     */
    @JvmName("mqecdgdvqabbebuk")
    public suspend
    fun lambdaFunctionAssociations(argument: suspend DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.lambdaFunctionAssociations = mapped
    }

    /**
     * @param values A config block that triggers a lambda function with specific actions (maximum 4).
     */
    @JvmName("cgavquqjrdygvhlv")
    public suspend fun lambdaFunctionAssociations(
        vararg
        values: DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdaFunctionAssociations = mapped
    }

    /**
     * @param value Maximum amount of time (in seconds) that an object is in a CloudFront cache before CloudFront forwards another request to your origin to determine whether the object has been updated. Only effective in the presence of `Cache-Control max-age`, `Cache-Control s-maxage`, and `Expires` headers.
     */
    @JvmName("xwbxasqijwigkidm")
    public suspend fun maxTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxTtl = mapped
    }

    /**
     * @param value Minimum amount of time that you want objects to stay in CloudFront caches before CloudFront queries your origin to see whether the object has been updated. Defaults to 0 seconds.
     */
    @JvmName("ufbrilgoxdqmfnxv")
    public suspend fun minTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minTtl = mapped
    }

    /**
     * @param value Unique identifier of the origin request policy that is attached to the behavior.
     */
    @JvmName("jfdmqhgwllblvhem")
    public suspend fun originRequestPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originRequestPolicyId = mapped
    }

    /**
     * @param value ARN of the real-time log configuration that is attached to this cache behavior.
     */
    @JvmName("tsvkkmcgcsmipdtk")
    public suspend fun realtimeLogConfigArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.realtimeLogConfigArn = mapped
    }

    /**
     * @param value Identifier for a response headers policy.
     */
    @JvmName("jamxqqqtvadsrygn")
    public suspend fun responseHeadersPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseHeadersPolicyId = mapped
    }

    /**
     * @param value Indicates whether you want to distribute media files in Microsoft Smooth Streaming format using the origin that is associated with this cache behavior.
     */
    @JvmName("pxyqcnfbdsfchvtu")
    public suspend fun smoothStreaming(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smoothStreaming = mapped
    }

    /**
     * @param value Value of ID for the origin that you want CloudFront to route requests to when a request matches the path pattern either for a cache behavior or for the default cache behavior.
     */
    @JvmName("eptxxoyuvkuyykvi")
    public suspend fun targetOriginId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetOriginId = mapped
    }

    /**
     * @param value List of key group IDs that CloudFront can use to validate signed URLs or signed cookies. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("uxhxcrbjsudomoaj")
    public suspend fun trustedKeyGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedKeyGroups = mapped
    }

    /**
     * @param values List of key group IDs that CloudFront can use to validate signed URLs or signed cookies. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("ysrfpcijvtpscnlh")
    public suspend fun trustedKeyGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedKeyGroups = mapped
    }

    /**
     * @param value List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("xllihpoaspndvuoq")
    public suspend fun trustedSigners(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedSigners = mapped
    }

    /**
     * @param values List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("jgyylwrvyymlcksa")
    public suspend fun trustedSigners(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedSigners = mapped
    }

    /**
     * @param value Use this element to specify the protocol that users can use to access the files in the origin specified by TargetOriginId when a request matches the path pattern in PathPattern. One of `allow-all`, `https-only`, or `redirect-to-https`.
     */
    @JvmName("gjpbvlmfxidriutd")
    public suspend fun viewerProtocolPolicy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.viewerProtocolPolicy = mapped
    }

    internal fun build(): DistributionDefaultCacheBehaviorArgs = DistributionDefaultCacheBehaviorArgs(
        allowedMethods = allowedMethods ?: throw PulumiNullFieldException("allowedMethods"),
        cachePolicyId = cachePolicyId,
        cachedMethods = cachedMethods ?: throw PulumiNullFieldException("cachedMethods"),
        compress = compress,
        defaultTtl = defaultTtl,
        fieldLevelEncryptionId = fieldLevelEncryptionId,
        forwardedValues = forwardedValues,
        functionAssociations = functionAssociations,
        lambdaFunctionAssociations = lambdaFunctionAssociations,
        maxTtl = maxTtl,
        minTtl = minTtl,
        originRequestPolicyId = originRequestPolicyId,
        realtimeLogConfigArn = realtimeLogConfigArn,
        responseHeadersPolicyId = responseHeadersPolicyId,
        smoothStreaming = smoothStreaming,
        targetOriginId = targetOriginId ?: throw PulumiNullFieldException("targetOriginId"),
        trustedKeyGroups = trustedKeyGroups,
        trustedSigners = trustedSigners,
        viewerProtocolPolicy = viewerProtocolPolicy ?: throw
            PulumiNullFieldException("viewerProtocolPolicy"),
    )
}
