@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionLoggingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket Amazon S3 bucket to store the access logs in, for example, `myawslogbucket.s3.amazonaws.com`.
 * @property includeCookies Whether to include cookies in access logs (default: `false`).
 * @property prefix Prefix to the access log filenames for this distribution, for example, `myprefix/`.
 */
public data class DistributionLoggingConfigArgs(
    public val bucket: Output<String>,
    public val includeCookies: Output<Boolean>? = null,
    public val prefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionLoggingConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionLoggingConfigArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionLoggingConfigArgs.builder()
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .includeCookies(includeCookies?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionLoggingConfigArgs].
 */
@PulumiTagMarker
public class DistributionLoggingConfigArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var includeCookies: Output<Boolean>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value Amazon S3 bucket to store the access logs in, for example, `myawslogbucket.s3.amazonaws.com`.
     */
    @JvmName("ufdxwwavcewettqn")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Whether to include cookies in access logs (default: `false`).
     */
    @JvmName("uyyexagpchmigupg")
    public suspend fun includeCookies(`value`: Output<Boolean>) {
        this.includeCookies = value
    }

    /**
     * @param value Prefix to the access log filenames for this distribution, for example, `myprefix/`.
     */
    @JvmName("kbptjqkiuvejqmno")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Amazon S3 bucket to store the access logs in, for example, `myawslogbucket.s3.amazonaws.com`.
     */
    @JvmName("dowdkhpeofitlhxq")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Whether to include cookies in access logs (default: `false`).
     */
    @JvmName("nxihbtuuldvgdlur")
    public suspend fun includeCookies(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeCookies = mapped
    }

    /**
     * @param value Prefix to the access log filenames for this distribution, for example, `myprefix/`.
     */
    @JvmName("vyktdljeuakqljyr")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): DistributionLoggingConfigArgs = DistributionLoggingConfigArgs(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
        includeCookies = includeCookies,
        prefix = prefix,
    )
}
