@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowedMethods Controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin.
 * @property cachePolicyId Unique identifier of the cache policy that is attached to the cache behavior. If configuring the `default_cache_behavior` either `cache_policy_id` or `forwarded_values` must be set.
 * @property cachedMethods Controls whether CloudFront caches the response to requests using the specified HTTP methods.
 * @property compress Whether you want CloudFront to automatically compress content for web requests that include `Accept-Encoding: gzip` in the request header (default: `false`).
 * @property defaultTtl Default amount of time (in seconds) that an object is in a CloudFront cache before CloudFront forwards another request in the absence of an `Cache-Control max-age` or `Expires` header.
 * @property fieldLevelEncryptionId Field level encryption configuration ID.
 * @property forwardedValues The forwarded values configuration that specifies how CloudFront handles query strings, cookies and headers (maximum one).
 * @property functionAssociations A config block that triggers a cloudfront function with specific actions (maximum 2).
 * @property lambdaFunctionAssociations A config block that triggers a lambda function with specific actions (maximum 4).
 * @property maxTtl Maximum amount of time (in seconds) that an object is in a CloudFront cache before CloudFront forwards another request to your origin to determine whether the object has been updated. Only effective in the presence of `Cache-Control max-age`, `Cache-Control s-maxage`, and `Expires` headers.
 * @property minTtl Minimum amount of time that you want objects to stay in CloudFront caches before CloudFront queries your origin to see whether the object has been updated. Defaults to 0 seconds.
 * @property originRequestPolicyId Unique identifier of the origin request policy that is attached to the behavior.
 * @property pathPattern Pattern (for example, `images/*.jpg`) that specifies which requests you want this cache behavior to apply to.
 * @property realtimeLogConfigArn ARN of the real-time log configuration that is attached to this cache behavior.
 * @property responseHeadersPolicyId Identifier for a response headers policy.
 * @property smoothStreaming Indicates whether you want to distribute media files in Microsoft Smooth Streaming format using the origin that is associated with this cache behavior.
 * @property targetOriginId Value of ID for the origin that you want CloudFront to route requests to when a request matches the path pattern either for a cache behavior or for the default cache behavior.
 * @property trustedKeyGroups List of key group IDs that CloudFront can use to validate signed URLs or signed cookies. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
 * @property trustedSigners List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
 * @property viewerProtocolPolicy Use this element to specify the protocol that users can use to access the files in the origin specified by TargetOriginId when a request matches the path pattern in PathPattern. One of `allow-all`, `https-only`, or `redirect-to-https`.
 * */
 */
public data class DistributionOrderedCacheBehaviorArgs(
    public val allowedMethods: Output<List<String>>,
    public val cachePolicyId: Output<String>? = null,
    public val cachedMethods: Output<List<String>>,
    public val compress: Output<Boolean>? = null,
    public val defaultTtl: Output<Int>? = null,
    public val fieldLevelEncryptionId: Output<String>? = null,
    public val forwardedValues: Output<DistributionOrderedCacheBehaviorForwardedValuesArgs>? = null,
    public val functionAssociations:
    Output<List<DistributionOrderedCacheBehaviorFunctionAssociationArgs>>? = null,
    public val lambdaFunctionAssociations:
    Output<List<DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgs>>? = null,
    public val maxTtl: Output<Int>? = null,
    public val minTtl: Output<Int>? = null,
    public val originRequestPolicyId: Output<String>? = null,
    public val pathPattern: Output<String>,
    public val realtimeLogConfigArn: Output<String>? = null,
    public val responseHeadersPolicyId: Output<String>? = null,
    public val smoothStreaming: Output<Boolean>? = null,
    public val targetOriginId: Output<String>,
    public val trustedKeyGroups: Output<List<String>>? = null,
    public val trustedSigners: Output<List<String>>? = null,
    public val viewerProtocolPolicy: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorArgs.builder()
            .allowedMethods(allowedMethods.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cachePolicyId(cachePolicyId?.applyValue({ args0 -> args0 }))
            .cachedMethods(cachedMethods.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .compress(compress?.applyValue({ args0 -> args0 }))
            .defaultTtl(defaultTtl?.applyValue({ args0 -> args0 }))
            .fieldLevelEncryptionId(fieldLevelEncryptionId?.applyValue({ args0 -> args0 }))
            .forwardedValues(forwardedValues?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .functionAssociations(
                functionAssociations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .lambdaFunctionAssociations(
                lambdaFunctionAssociations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .maxTtl(maxTtl?.applyValue({ args0 -> args0 }))
            .minTtl(minTtl?.applyValue({ args0 -> args0 }))
            .originRequestPolicyId(originRequestPolicyId?.applyValue({ args0 -> args0 }))
            .pathPattern(pathPattern.applyValue({ args0 -> args0 }))
            .realtimeLogConfigArn(realtimeLogConfigArn?.applyValue({ args0 -> args0 }))
            .responseHeadersPolicyId(responseHeadersPolicyId?.applyValue({ args0 -> args0 }))
            .smoothStreaming(smoothStreaming?.applyValue({ args0 -> args0 }))
            .targetOriginId(targetOriginId.applyValue({ args0 -> args0 }))
            .trustedKeyGroups(trustedKeyGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .trustedSigners(trustedSigners?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .viewerProtocolPolicy(viewerProtocolPolicy.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionOrderedCacheBehaviorArgs].
 */
@PulumiTagMarker
public class DistributionOrderedCacheBehaviorArgsBuilder internal constructor() {
    private var allowedMethods: Output<List<String>>? = null

    private var cachePolicyId: Output<String>? = null

    private var cachedMethods: Output<List<String>>? = null

    private var compress: Output<Boolean>? = null

    private var defaultTtl: Output<Int>? = null

    private var fieldLevelEncryptionId: Output<String>? = null

    private var forwardedValues: Output<DistributionOrderedCacheBehaviorForwardedValuesArgs>? = null

    private var functionAssociations:
        Output<List<DistributionOrderedCacheBehaviorFunctionAssociationArgs>>? = null

    private var lambdaFunctionAssociations:
        Output<List<DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgs>>? = null

    private var maxTtl: Output<Int>? = null

    private var minTtl: Output<Int>? = null

    private var originRequestPolicyId: Output<String>? = null

    private var pathPattern: Output<String>? = null

    private var realtimeLogConfigArn: Output<String>? = null

    private var responseHeadersPolicyId: Output<String>? = null

    private var smoothStreaming: Output<Boolean>? = null

    private var targetOriginId: Output<String>? = null

    private var trustedKeyGroups: Output<List<String>>? = null

    private var trustedSigners: Output<List<String>>? = null

    private var viewerProtocolPolicy: Output<String>? = null

    /**
     * @param value Controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin.
     */
    @JvmName("igftqotvfvfiaosn")
    public suspend fun allowedMethods(`value`: Output<List<String>>) {
        this.allowedMethods = value
    }

    @JvmName("ssoqeofqrufqadmc")
    public suspend fun allowedMethods(vararg values: Output<String>) {
        this.allowedMethods = Output.all(values.asList())
    }

    /**
     * @param values Controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin.
     */
    @JvmName("yupblxtifijwrroq")
    public suspend fun allowedMethods(values: List<Output<String>>) {
        this.allowedMethods = Output.all(values)
    }

    /**
     * @param value Unique identifier of the cache policy that is attached to the cache behavior. If configuring the `default_cache_behavior` either `cache_policy_id` or `forwarded_values` must be set.
     */
    @JvmName("qspwhlhklvvffrgc")
    public suspend fun cachePolicyId(`value`: Output<String>) {
        this.cachePolicyId = value
    }

    /**
     * @param value Controls whether CloudFront caches the response to requests using the specified HTTP methods.
     */
    @JvmName("alhhcnafjlnjailr")
    public suspend fun cachedMethods(`value`: Output<List<String>>) {
        this.cachedMethods = value
    }

    @JvmName("lsnoqukvneybmegl")
    public suspend fun cachedMethods(vararg values: Output<String>) {
        this.cachedMethods = Output.all(values.asList())
    }

    /**
     * @param values Controls whether CloudFront caches the response to requests using the specified HTTP methods.
     */
    @JvmName("egkjhmprlvfrldno")
    public suspend fun cachedMethods(values: List<Output<String>>) {
        this.cachedMethods = Output.all(values)
    }

    /**
     * @param value Whether you want CloudFront to automatically compress content for web requests that include `Accept-Encoding: gzip` in the request header (default: `false`).
     */
    @JvmName("twmysugjqdgkpoph")
    public suspend fun compress(`value`: Output<Boolean>) {
        this.compress = value
    }

    /**
     * @param value Default amount of time (in seconds) that an object is in a CloudFront cache before CloudFront forwards another request in the absence of an `Cache-Control max-age` or `Expires` header.
     */
    @JvmName("pgtxskvwmixivdfv")
    public suspend fun defaultTtl(`value`: Output<Int>) {
        this.defaultTtl = value
    }

    /**
     * @param value Field level encryption configuration ID.
     */
    @JvmName("ackwtnecytxqedop")
    public suspend fun fieldLevelEncryptionId(`value`: Output<String>) {
        this.fieldLevelEncryptionId = value
    }

    /**
     * @param value The forwarded values configuration that specifies how CloudFront handles query strings, cookies and headers (maximum one).
     */
    @JvmName("ymdvvahrtrdkhxni")
    public suspend
    fun forwardedValues(`value`: Output<DistributionOrderedCacheBehaviorForwardedValuesArgs>) {
        this.forwardedValues = value
    }

    /**
     * @param value A config block that triggers a cloudfront function with specific actions (maximum 2).
     */
    @JvmName("hdedysioqplffbbn")
    public suspend
    fun functionAssociations(`value`: Output<List<DistributionOrderedCacheBehaviorFunctionAssociationArgs>>) {
        this.functionAssociations = value
    }

    @JvmName("jkkqatsqiirrityk")
    public suspend fun functionAssociations(
        vararg
        values: Output<DistributionOrderedCacheBehaviorFunctionAssociationArgs>,
    ) {
        this.functionAssociations = Output.all(values.asList())
    }

    /**
     * @param values A config block that triggers a cloudfront function with specific actions (maximum 2).
     */
    @JvmName("xcakqjeataqjgava")
    public suspend
    fun functionAssociations(values: List<Output<DistributionOrderedCacheBehaviorFunctionAssociationArgs>>) {
        this.functionAssociations = Output.all(values)
    }

    /**
     * @param value A config block that triggers a lambda function with specific actions (maximum 4).
     */
    @JvmName("ocjgflrshroldhqv")
    public suspend
    fun lambdaFunctionAssociations(`value`: Output<List<DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgs>>) {
        this.lambdaFunctionAssociations = value
    }

    @JvmName("vrijkfkuqeygoyub")
    public suspend fun lambdaFunctionAssociations(
        vararg
        values: Output<DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgs>,
    ) {
        this.lambdaFunctionAssociations = Output.all(values.asList())
    }

    /**
     * @param values A config block that triggers a lambda function with specific actions (maximum 4).
     */
    @JvmName("jigiidxnlaaeqlmd")
    public suspend
    fun lambdaFunctionAssociations(values: List<Output<DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgs>>) {
        this.lambdaFunctionAssociations = Output.all(values)
    }

    /**
     * @param value Maximum amount of time (in seconds) that an object is in a CloudFront cache before CloudFront forwards another request to your origin to determine whether the object has been updated. Only effective in the presence of `Cache-Control max-age`, `Cache-Control s-maxage`, and `Expires` headers.
     */
    @JvmName("uabblxqkgtcdnmvl")
    public suspend fun maxTtl(`value`: Output<Int>) {
        this.maxTtl = value
    }

    /**
     * @param value Minimum amount of time that you want objects to stay in CloudFront caches before CloudFront queries your origin to see whether the object has been updated. Defaults to 0 seconds.
     */
    @JvmName("nhrvoruutelgmvoa")
    public suspend fun minTtl(`value`: Output<Int>) {
        this.minTtl = value
    }

    /**
     * @param value Unique identifier of the origin request policy that is attached to the behavior.
     */
    @JvmName("hiocgqogmqscmhki")
    public suspend fun originRequestPolicyId(`value`: Output<String>) {
        this.originRequestPolicyId = value
    }

    /**
     * @param value Pattern (for example, `images/*.jpg`) that specifies which requests you want this cache behavior to apply to.
     * */
     */
    @JvmName("sutvkuuxdrskeenj")
    public suspend fun pathPattern(`value`: Output<String>) {
        this.pathPattern = value
    }

    /**
     * @param value ARN of the real-time log configuration that is attached to this cache behavior.
     */
    @JvmName("ssmstesdihjwvyvl")
    public suspend fun realtimeLogConfigArn(`value`: Output<String>) {
        this.realtimeLogConfigArn = value
    }

    /**
     * @param value Identifier for a response headers policy.
     */
    @JvmName("omwwpfnvmlnmiukf")
    public suspend fun responseHeadersPolicyId(`value`: Output<String>) {
        this.responseHeadersPolicyId = value
    }

    /**
     * @param value Indicates whether you want to distribute media files in Microsoft Smooth Streaming format using the origin that is associated with this cache behavior.
     */
    @JvmName("vbaxuovgdpktywlw")
    public suspend fun smoothStreaming(`value`: Output<Boolean>) {
        this.smoothStreaming = value
    }

    /**
     * @param value Value of ID for the origin that you want CloudFront to route requests to when a request matches the path pattern either for a cache behavior or for the default cache behavior.
     */
    @JvmName("cysptcatqtdvfler")
    public suspend fun targetOriginId(`value`: Output<String>) {
        this.targetOriginId = value
    }

    /**
     * @param value List of key group IDs that CloudFront can use to validate signed URLs or signed cookies. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("antajsrdpcnxexlp")
    public suspend fun trustedKeyGroups(`value`: Output<List<String>>) {
        this.trustedKeyGroups = value
    }

    @JvmName("devnoffdrrlymyjk")
    public suspend fun trustedKeyGroups(vararg values: Output<String>) {
        this.trustedKeyGroups = Output.all(values.asList())
    }

    /**
     * @param values List of key group IDs that CloudFront can use to validate signed URLs or signed cookies. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("rbsshtfsfdjwwwag")
    public suspend fun trustedKeyGroups(values: List<Output<String>>) {
        this.trustedKeyGroups = Output.all(values)
    }

    /**
     * @param value List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("hybinokabjuxcvjs")
    public suspend fun trustedSigners(`value`: Output<List<String>>) {
        this.trustedSigners = value
    }

    @JvmName("mxpbclfexlqeogqr")
    public suspend fun trustedSigners(vararg values: Output<String>) {
        this.trustedSigners = Output.all(values.asList())
    }

    /**
     * @param values List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("cndkffgueehbgsdb")
    public suspend fun trustedSigners(values: List<Output<String>>) {
        this.trustedSigners = Output.all(values)
    }

    /**
     * @param value Use this element to specify the protocol that users can use to access the files in the origin specified by TargetOriginId when a request matches the path pattern in PathPattern. One of `allow-all`, `https-only`, or `redirect-to-https`.
     */
    @JvmName("naxlovsywqlwidot")
    public suspend fun viewerProtocolPolicy(`value`: Output<String>) {
        this.viewerProtocolPolicy = value
    }

    /**
     * @param value Controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin.
     */
    @JvmName("atonyqcpkmvtgrls")
    public suspend fun allowedMethods(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param values Controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin.
     */
    @JvmName("ycgityyrvepgmbhf")
    public suspend fun allowedMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param value Unique identifier of the cache policy that is attached to the cache behavior. If configuring the `default_cache_behavior` either `cache_policy_id` or `forwarded_values` must be set.
     */
    @JvmName("ttokiysvoabyrkgw")
    public suspend fun cachePolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cachePolicyId = mapped
    }

    /**
     * @param value Controls whether CloudFront caches the response to requests using the specified HTTP methods.
     */
    @JvmName("kdcbvwbxurtrmqbh")
    public suspend fun cachedMethods(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cachedMethods = mapped
    }

    /**
     * @param values Controls whether CloudFront caches the response to requests using the specified HTTP methods.
     */
    @JvmName("yqcjvnoaalaeqbxm")
    public suspend fun cachedMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cachedMethods = mapped
    }

    /**
     * @param value Whether you want CloudFront to automatically compress content for web requests that include `Accept-Encoding: gzip` in the request header (default: `false`).
     */
    @JvmName("wvduxgisvcdgcxhp")
    public suspend fun compress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compress = mapped
    }

    /**
     * @param value Default amount of time (in seconds) that an object is in a CloudFront cache before CloudFront forwards another request in the absence of an `Cache-Control max-age` or `Expires` header.
     */
    @JvmName("bkrjcvalekpwcias")
    public suspend fun defaultTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultTtl = mapped
    }

    /**
     * @param value Field level encryption configuration ID.
     */
    @JvmName("majgkkfkhlicgjtf")
    public suspend fun fieldLevelEncryptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldLevelEncryptionId = mapped
    }

    /**
     * @param value The forwarded values configuration that specifies how CloudFront handles query strings, cookies and headers (maximum one).
     */
    @JvmName("efhyghuietyxtltc")
    public suspend
    fun forwardedValues(`value`: DistributionOrderedCacheBehaviorForwardedValuesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedValues = mapped
    }

    /**
     * @param argument The forwarded values configuration that specifies how CloudFront handles query strings, cookies and headers (maximum one).
     */
    @JvmName("fcmlapilpmpolglx")
    public suspend
    fun forwardedValues(argument: suspend DistributionOrderedCacheBehaviorForwardedValuesArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionOrderedCacheBehaviorForwardedValuesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.forwardedValues = mapped
    }

    /**
     * @param value A config block that triggers a cloudfront function with specific actions (maximum 2).
     */
    @JvmName("ormfcowhtyvfvutp")
    public suspend
    fun functionAssociations(`value`: List<DistributionOrderedCacheBehaviorFunctionAssociationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionAssociations = mapped
    }

    /**
     * @param argument A config block that triggers a cloudfront function with specific actions (maximum 2).
     */
    @JvmName("ddwgwdsobonneahu")
    public suspend
    fun functionAssociations(argument: List<suspend DistributionOrderedCacheBehaviorFunctionAssociationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionOrderedCacheBehaviorFunctionAssociationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.functionAssociations = mapped
    }

    /**
     * @param argument A config block that triggers a cloudfront function with specific actions (maximum 2).
     */
    @JvmName("ojdnywluhrxhuoah")
    public suspend fun functionAssociations(
        vararg
        argument: suspend DistributionOrderedCacheBehaviorFunctionAssociationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DistributionOrderedCacheBehaviorFunctionAssociationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.functionAssociations = mapped
    }

    /**
     * @param argument A config block that triggers a cloudfront function with specific actions (maximum 2).
     */
    @JvmName("odeekeqpgssietwr")
    public suspend
    fun functionAssociations(argument: suspend DistributionOrderedCacheBehaviorFunctionAssociationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DistributionOrderedCacheBehaviorFunctionAssociationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.functionAssociations = mapped
    }

    /**
     * @param values A config block that triggers a cloudfront function with specific actions (maximum 2).
     */
    @JvmName("bjlhiyoqvrtuitpu")
    public suspend fun functionAssociations(
        vararg
        values: DistributionOrderedCacheBehaviorFunctionAssociationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionAssociations = mapped
    }

    /**
     * @param value A config block that triggers a lambda function with specific actions (maximum 4).
     */
    @JvmName("saebpqdgngxwfwqj")
    public suspend
    fun lambdaFunctionAssociations(`value`: List<DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaFunctionAssociations = mapped
    }

    /**
     * @param argument A config block that triggers a lambda function with specific actions (maximum 4).
     */
    @JvmName("tteleowmutfhvkua")
    public suspend
    fun lambdaFunctionAssociations(argument: List<suspend DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lambdaFunctionAssociations = mapped
    }

    /**
     * @param argument A config block that triggers a lambda function with specific actions (maximum 4).
     */
    @JvmName("yrenvnsaaandkdod")
    public suspend fun lambdaFunctionAssociations(
        vararg
        argument: suspend DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lambdaFunctionAssociations = mapped
    }

    /**
     * @param argument A config block that triggers a lambda function with specific actions (maximum 4).
     */
    @JvmName("lkalvpheamnaipig")
    public suspend
    fun lambdaFunctionAssociations(argument: suspend DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.lambdaFunctionAssociations = mapped
    }

    /**
     * @param values A config block that triggers a lambda function with specific actions (maximum 4).
     */
    @JvmName("iaykdioqicppibgy")
    public suspend fun lambdaFunctionAssociations(
        vararg
        values: DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdaFunctionAssociations = mapped
    }

    /**
     * @param value Maximum amount of time (in seconds) that an object is in a CloudFront cache before CloudFront forwards another request to your origin to determine whether the object has been updated. Only effective in the presence of `Cache-Control max-age`, `Cache-Control s-maxage`, and `Expires` headers.
     */
    @JvmName("ksytknykbsyoeffu")
    public suspend fun maxTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxTtl = mapped
    }

    /**
     * @param value Minimum amount of time that you want objects to stay in CloudFront caches before CloudFront queries your origin to see whether the object has been updated. Defaults to 0 seconds.
     */
    @JvmName("btcgnxwgjtdqqtau")
    public suspend fun minTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minTtl = mapped
    }

    /**
     * @param value Unique identifier of the origin request policy that is attached to the behavior.
     */
    @JvmName("ofqiadcvrhirbqie")
    public suspend fun originRequestPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originRequestPolicyId = mapped
    }

    /**
     * @param value Pattern (for example, `images/*.jpg`) that specifies which requests you want this cache behavior to apply to.
     * */
     */
    @JvmName("fvombftxrswkhwjv")
    public suspend fun pathPattern(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pathPattern = mapped
    }

    /**
     * @param value ARN of the real-time log configuration that is attached to this cache behavior.
     */
    @JvmName("iapsqenqwshctxpr")
    public suspend fun realtimeLogConfigArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.realtimeLogConfigArn = mapped
    }

    /**
     * @param value Identifier for a response headers policy.
     */
    @JvmName("weiubckaiesuyjxm")
    public suspend fun responseHeadersPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseHeadersPolicyId = mapped
    }

    /**
     * @param value Indicates whether you want to distribute media files in Microsoft Smooth Streaming format using the origin that is associated with this cache behavior.
     */
    @JvmName("wdvootvwulyurdgd")
    public suspend fun smoothStreaming(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smoothStreaming = mapped
    }

    /**
     * @param value Value of ID for the origin that you want CloudFront to route requests to when a request matches the path pattern either for a cache behavior or for the default cache behavior.
     */
    @JvmName("wobtgubjyefcywmv")
    public suspend fun targetOriginId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetOriginId = mapped
    }

    /**
     * @param value List of key group IDs that CloudFront can use to validate signed URLs or signed cookies. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("fhxvqclpindcymdr")
    public suspend fun trustedKeyGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedKeyGroups = mapped
    }

    /**
     * @param values List of key group IDs that CloudFront can use to validate signed URLs or signed cookies. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("fjmewibrmujrejsy")
    public suspend fun trustedKeyGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedKeyGroups = mapped
    }

    /**
     * @param value List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("gyiyfhhycbfnyrjk")
    public suspend fun trustedSigners(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedSigners = mapped
    }

    /**
     * @param values List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content. See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
     */
    @JvmName("dqllmrxllcukrolg")
    public suspend fun trustedSigners(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedSigners = mapped
    }

    /**
     * @param value Use this element to specify the protocol that users can use to access the files in the origin specified by TargetOriginId when a request matches the path pattern in PathPattern. One of `allow-all`, `https-only`, or `redirect-to-https`.
     */
    @JvmName("psdmrkednawyxojp")
    public suspend fun viewerProtocolPolicy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.viewerProtocolPolicy = mapped
    }

    internal fun build(): DistributionOrderedCacheBehaviorArgs = DistributionOrderedCacheBehaviorArgs(
        allowedMethods = allowedMethods ?: throw PulumiNullFieldException("allowedMethods"),
        cachePolicyId = cachePolicyId,
        cachedMethods = cachedMethods ?: throw PulumiNullFieldException("cachedMethods"),
        compress = compress,
        defaultTtl = defaultTtl,
        fieldLevelEncryptionId = fieldLevelEncryptionId,
        forwardedValues = forwardedValues,
        functionAssociations = functionAssociations,
        lambdaFunctionAssociations = lambdaFunctionAssociations,
        maxTtl = maxTtl,
        minTtl = minTtl,
        originRequestPolicyId = originRequestPolicyId,
        pathPattern = pathPattern ?: throw PulumiNullFieldException("pathPattern"),
        realtimeLogConfigArn = realtimeLogConfigArn,
        responseHeadersPolicyId = responseHeadersPolicyId,
        smoothStreaming = smoothStreaming,
        targetOriginId = targetOriginId ?: throw PulumiNullFieldException("targetOriginId"),
        trustedKeyGroups = trustedKeyGroups,
        trustedSigners = trustedSigners,
        viewerProtocolPolicy = viewerProtocolPolicy ?: throw
            PulumiNullFieldException("viewerProtocolPolicy"),
    )
}
