@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property connectionAttempts Number of times that CloudFront attempts to connect to the origin. Must be between 1-3. Defaults to 3.
 * @property connectionTimeout Number of seconds that CloudFront waits when trying to establish a connection to the origin. Must be between 1-10. Defaults to 10.
 * @property customHeaders One or more sub-resources with `name` and `value` parameters that specify header data that will be sent to the origin (multiples allowed).
 * @property customOriginConfig The CloudFront custom origin configuration information. If an S3 origin is required, use `origin_access_control_id` or `s3_origin_config` instead.
 * @property domainName DNS domain name of either the S3 bucket, or web site of your custom origin.
 * @property originAccessControlId Unique identifier of a [CloudFront origin access control][8] for this origin.
 * @property originId Unique identifier of the member origin.
 * @property originPath Optional element that causes CloudFront to request your content from a directory in your Amazon S3 bucket or your custom origin.
 * @property originShield CloudFront Origin Shield configuration information. Using Origin Shield can help reduce the load on your origin. For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the Amazon CloudFront Developer Guide.
 * @property s3OriginConfig CloudFront S3 origin configuration information. If a custom origin is required, use `custom_origin_config` instead.
 */
public data class DistributionOriginArgs(
    public val connectionAttempts: Output<Int>? = null,
    public val connectionTimeout: Output<Int>? = null,
    public val customHeaders: Output<List<DistributionOriginCustomHeaderArgs>>? = null,
    public val customOriginConfig: Output<DistributionOriginCustomOriginConfigArgs>? = null,
    public val domainName: Output<String>,
    public val originAccessControlId: Output<String>? = null,
    public val originId: Output<String>,
    public val originPath: Output<String>? = null,
    public val originShield: Output<DistributionOriginOriginShieldArgs>? = null,
    public val s3OriginConfig: Output<DistributionOriginS3OriginConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs.builder()
            .connectionAttempts(connectionAttempts?.applyValue({ args0 -> args0 }))
            .connectionTimeout(connectionTimeout?.applyValue({ args0 -> args0 }))
            .customHeaders(
                customHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .customOriginConfig(
                customOriginConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .domainName(domainName.applyValue({ args0 -> args0 }))
            .originAccessControlId(originAccessControlId?.applyValue({ args0 -> args0 }))
            .originId(originId.applyValue({ args0 -> args0 }))
            .originPath(originPath?.applyValue({ args0 -> args0 }))
            .originShield(originShield?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3OriginConfig(
                s3OriginConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DistributionOriginArgs].
 */
@PulumiTagMarker
public class DistributionOriginArgsBuilder internal constructor() {
    private var connectionAttempts: Output<Int>? = null

    private var connectionTimeout: Output<Int>? = null

    private var customHeaders: Output<List<DistributionOriginCustomHeaderArgs>>? = null

    private var customOriginConfig: Output<DistributionOriginCustomOriginConfigArgs>? = null

    private var domainName: Output<String>? = null

    private var originAccessControlId: Output<String>? = null

    private var originId: Output<String>? = null

    private var originPath: Output<String>? = null

    private var originShield: Output<DistributionOriginOriginShieldArgs>? = null

    private var s3OriginConfig: Output<DistributionOriginS3OriginConfigArgs>? = null

    /**
     * @param value Number of times that CloudFront attempts to connect to the origin. Must be between 1-3. Defaults to 3.
     */
    @JvmName("npflmhexfdcychnr")
    public suspend fun connectionAttempts(`value`: Output<Int>) {
        this.connectionAttempts = value
    }

    /**
     * @param value Number of seconds that CloudFront waits when trying to establish a connection to the origin. Must be between 1-10. Defaults to 10.
     */
    @JvmName("yiajiwijmebyskbx")
    public suspend fun connectionTimeout(`value`: Output<Int>) {
        this.connectionTimeout = value
    }

    /**
     * @param value One or more sub-resources with `name` and `value` parameters that specify header data that will be sent to the origin (multiples allowed).
     */
    @JvmName("ubnbpoesvvlprjkb")
    public suspend fun customHeaders(`value`: Output<List<DistributionOriginCustomHeaderArgs>>) {
        this.customHeaders = value
    }

    @JvmName("uqdaaxkcuicwdkin")
    public suspend fun customHeaders(vararg values: Output<DistributionOriginCustomHeaderArgs>) {
        this.customHeaders = Output.all(values.asList())
    }

    /**
     * @param values One or more sub-resources with `name` and `value` parameters that specify header data that will be sent to the origin (multiples allowed).
     */
    @JvmName("fuhoinrpsplogcgl")
    public suspend fun customHeaders(values: List<Output<DistributionOriginCustomHeaderArgs>>) {
        this.customHeaders = Output.all(values)
    }

    /**
     * @param value The CloudFront custom origin configuration information. If an S3 origin is required, use `origin_access_control_id` or `s3_origin_config` instead.
     */
    @JvmName("rrcdblinrqlfykdy")
    public suspend fun customOriginConfig(`value`: Output<DistributionOriginCustomOriginConfigArgs>) {
        this.customOriginConfig = value
    }

    /**
     * @param value DNS domain name of either the S3 bucket, or web site of your custom origin.
     */
    @JvmName("kfhatlfhhjuqodgb")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Unique identifier of a [CloudFront origin access control][8] for this origin.
     */
    @JvmName("bgmsreadvbmhnxbc")
    public suspend fun originAccessControlId(`value`: Output<String>) {
        this.originAccessControlId = value
    }

    /**
     * @param value Unique identifier of the member origin.
     */
    @JvmName("roxycwjmubsphihl")
    public suspend fun originId(`value`: Output<String>) {
        this.originId = value
    }

    /**
     * @param value Optional element that causes CloudFront to request your content from a directory in your Amazon S3 bucket or your custom origin.
     */
    @JvmName("tckaowfiuevxonin")
    public suspend fun originPath(`value`: Output<String>) {
        this.originPath = value
    }

    /**
     * @param value CloudFront Origin Shield configuration information. Using Origin Shield can help reduce the load on your origin. For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the Amazon CloudFront Developer Guide.
     */
    @JvmName("fyanlhcsrjguywlx")
    public suspend fun originShield(`value`: Output<DistributionOriginOriginShieldArgs>) {
        this.originShield = value
    }

    /**
     * @param value CloudFront S3 origin configuration information. If a custom origin is required, use `custom_origin_config` instead.
     */
    @JvmName("vdaxaasuxjvuixpo")
    public suspend fun s3OriginConfig(`value`: Output<DistributionOriginS3OriginConfigArgs>) {
        this.s3OriginConfig = value
    }

    /**
     * @param value Number of times that CloudFront attempts to connect to the origin. Must be between 1-3. Defaults to 3.
     */
    @JvmName("noywkrnwgsylftos")
    public suspend fun connectionAttempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionAttempts = mapped
    }

    /**
     * @param value Number of seconds that CloudFront waits when trying to establish a connection to the origin. Must be between 1-10. Defaults to 10.
     */
    @JvmName("gexqjdfwrhcrssla")
    public suspend fun connectionTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionTimeout = mapped
    }

    /**
     * @param value One or more sub-resources with `name` and `value` parameters that specify header data that will be sent to the origin (multiples allowed).
     */
    @JvmName("xkfuydofakxxiaih")
    public suspend fun customHeaders(`value`: List<DistributionOriginCustomHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHeaders = mapped
    }

    /**
     * @param argument One or more sub-resources with `name` and `value` parameters that specify header data that will be sent to the origin (multiples allowed).
     */
    @JvmName("cwwhuuocfwxgfmlv")
    public suspend
    fun customHeaders(argument: List<suspend DistributionOriginCustomHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionOriginCustomHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customHeaders = mapped
    }

    /**
     * @param argument One or more sub-resources with `name` and `value` parameters that specify header data that will be sent to the origin (multiples allowed).
     */
    @JvmName("hdafwxcqbwskelsk")
    public suspend fun customHeaders(
        vararg
        argument: suspend DistributionOriginCustomHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DistributionOriginCustomHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customHeaders = mapped
    }

    /**
     * @param argument One or more sub-resources with `name` and `value` parameters that specify header data that will be sent to the origin (multiples allowed).
     */
    @JvmName("pinvuweyxbvcyhej")
    public suspend
    fun customHeaders(argument: suspend DistributionOriginCustomHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DistributionOriginCustomHeaderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customHeaders = mapped
    }

    /**
     * @param values One or more sub-resources with `name` and `value` parameters that specify header data that will be sent to the origin (multiples allowed).
     */
    @JvmName("evwwcxcjkiegpxjo")
    public suspend fun customHeaders(vararg values: DistributionOriginCustomHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customHeaders = mapped
    }

    /**
     * @param value The CloudFront custom origin configuration information. If an S3 origin is required, use `origin_access_control_id` or `s3_origin_config` instead.
     */
    @JvmName("vyheobjpspeybkcf")
    public suspend fun customOriginConfig(`value`: DistributionOriginCustomOriginConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customOriginConfig = mapped
    }

    /**
     * @param argument The CloudFront custom origin configuration information. If an S3 origin is required, use `origin_access_control_id` or `s3_origin_config` instead.
     */
    @JvmName("dyjlioehogcglote")
    public suspend
    fun customOriginConfig(argument: suspend DistributionOriginCustomOriginConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionOriginCustomOriginConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customOriginConfig = mapped
    }

    /**
     * @param value DNS domain name of either the S3 bucket, or web site of your custom origin.
     */
    @JvmName("aktipgtsipywcale")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Unique identifier of a [CloudFront origin access control][8] for this origin.
     */
    @JvmName("innohxhbcjhtutiy")
    public suspend fun originAccessControlId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originAccessControlId = mapped
    }

    /**
     * @param value Unique identifier of the member origin.
     */
    @JvmName("drneqjucnyocrmwg")
    public suspend fun originId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.originId = mapped
    }

    /**
     * @param value Optional element that causes CloudFront to request your content from a directory in your Amazon S3 bucket or your custom origin.
     */
    @JvmName("eicbhnvqoijjokph")
    public suspend fun originPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originPath = mapped
    }

    /**
     * @param value CloudFront Origin Shield configuration information. Using Origin Shield can help reduce the load on your origin. For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the Amazon CloudFront Developer Guide.
     */
    @JvmName("aegbcdnfxjnohnpx")
    public suspend fun originShield(`value`: DistributionOriginOriginShieldArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originShield = mapped
    }

    /**
     * @param argument CloudFront Origin Shield configuration information. Using Origin Shield can help reduce the load on your origin. For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the Amazon CloudFront Developer Guide.
     */
    @JvmName("poysxaswlbyxocka")
    public suspend
    fun originShield(argument: suspend DistributionOriginOriginShieldArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionOriginOriginShieldArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.originShield = mapped
    }

    /**
     * @param value CloudFront S3 origin configuration information. If a custom origin is required, use `custom_origin_config` instead.
     */
    @JvmName("gatltwlpsumrvguf")
    public suspend fun s3OriginConfig(`value`: DistributionOriginS3OriginConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3OriginConfig = mapped
    }

    /**
     * @param argument CloudFront S3 origin configuration information. If a custom origin is required, use `custom_origin_config` instead.
     */
    @JvmName("ukusrmflqsxxrjfi")
    public suspend
    fun s3OriginConfig(argument: suspend DistributionOriginS3OriginConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionOriginS3OriginConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3OriginConfig = mapped
    }

    internal fun build(): DistributionOriginArgs = DistributionOriginArgs(
        connectionAttempts = connectionAttempts,
        connectionTimeout = connectionTimeout,
        customHeaders = customHeaders,
        customOriginConfig = customOriginConfig,
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        originAccessControlId = originAccessControlId,
        originId = originId ?: throw PulumiNullFieldException("originId"),
        originPath = originPath,
        originShield = originShield,
        s3OriginConfig = s3OriginConfig,
    )
}
