@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionOriginCustomOriginConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property httpPort HTTP port the custom origin listens on.
 * @property httpsPort HTTPS port the custom origin listens on.
 * @property originKeepaliveTimeout The Custom KeepAlive timeout, in seconds. By default, AWS enforces an upper limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout). Defaults to `5`.
 * @property originProtocolPolicy Origin protocol policy to apply to your origin. One of `http-only`, `https-only`, or `match-viewer`.
 * @property originReadTimeout The Custom Read timeout, in seconds. By default, AWS enforces an upper limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout). Defaults to `30`.
 * @property originSslProtocols SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS. A list of one or more of `SSLv3`, `TLSv1`, `TLSv1.1`, and `TLSv1.2`.
 */
public data class DistributionOriginCustomOriginConfigArgs(
    public val httpPort: Output<Int>,
    public val httpsPort: Output<Int>,
    public val originKeepaliveTimeout: Output<Int>? = null,
    public val originProtocolPolicy: Output<String>,
    public val originReadTimeout: Output<Int>? = null,
    public val originSslProtocols: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionOriginCustomOriginConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionOriginCustomOriginConfigArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionOriginCustomOriginConfigArgs.builder()
            .httpPort(httpPort.applyValue({ args0 -> args0 }))
            .httpsPort(httpsPort.applyValue({ args0 -> args0 }))
            .originKeepaliveTimeout(originKeepaliveTimeout?.applyValue({ args0 -> args0 }))
            .originProtocolPolicy(originProtocolPolicy.applyValue({ args0 -> args0 }))
            .originReadTimeout(originReadTimeout?.applyValue({ args0 -> args0 }))
            .originSslProtocols(originSslProtocols.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DistributionOriginCustomOriginConfigArgs].
 */
@PulumiTagMarker
public class DistributionOriginCustomOriginConfigArgsBuilder internal constructor() {
    private var httpPort: Output<Int>? = null

    private var httpsPort: Output<Int>? = null

    private var originKeepaliveTimeout: Output<Int>? = null

    private var originProtocolPolicy: Output<String>? = null

    private var originReadTimeout: Output<Int>? = null

    private var originSslProtocols: Output<List<String>>? = null

    /**
     * @param value HTTP port the custom origin listens on.
     */
    @JvmName("emiqkgmjwdeyifjm")
    public suspend fun httpPort(`value`: Output<Int>) {
        this.httpPort = value
    }

    /**
     * @param value HTTPS port the custom origin listens on.
     */
    @JvmName("cotklxnxyhusewcs")
    public suspend fun httpsPort(`value`: Output<Int>) {
        this.httpsPort = value
    }

    /**
     * @param value The Custom KeepAlive timeout, in seconds. By default, AWS enforces an upper limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout). Defaults to `5`.
     */
    @JvmName("yulcdrsgvahvkcjf")
    public suspend fun originKeepaliveTimeout(`value`: Output<Int>) {
        this.originKeepaliveTimeout = value
    }

    /**
     * @param value Origin protocol policy to apply to your origin. One of `http-only`, `https-only`, or `match-viewer`.
     */
    @JvmName("myabsrdtbhwglfen")
    public suspend fun originProtocolPolicy(`value`: Output<String>) {
        this.originProtocolPolicy = value
    }

    /**
     * @param value The Custom Read timeout, in seconds. By default, AWS enforces an upper limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout). Defaults to `30`.
     */
    @JvmName("rrmortbsifraqyyh")
    public suspend fun originReadTimeout(`value`: Output<Int>) {
        this.originReadTimeout = value
    }

    /**
     * @param value SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS. A list of one or more of `SSLv3`, `TLSv1`, `TLSv1.1`, and `TLSv1.2`.
     */
    @JvmName("hjgjxnnhrshgagyt")
    public suspend fun originSslProtocols(`value`: Output<List<String>>) {
        this.originSslProtocols = value
    }

    @JvmName("trifsmtromllvdsu")
    public suspend fun originSslProtocols(vararg values: Output<String>) {
        this.originSslProtocols = Output.all(values.asList())
    }

    /**
     * @param values SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS. A list of one or more of `SSLv3`, `TLSv1`, `TLSv1.1`, and `TLSv1.2`.
     */
    @JvmName("pnwtcfisvhkscsqb")
    public suspend fun originSslProtocols(values: List<Output<String>>) {
        this.originSslProtocols = Output.all(values)
    }

    /**
     * @param value HTTP port the custom origin listens on.
     */
    @JvmName("lsgqhrooqribywhi")
    public suspend fun httpPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpPort = mapped
    }

    /**
     * @param value HTTPS port the custom origin listens on.
     */
    @JvmName("ruyynaankhtjyhyd")
    public suspend fun httpsPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpsPort = mapped
    }

    /**
     * @param value The Custom KeepAlive timeout, in seconds. By default, AWS enforces an upper limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout). Defaults to `5`.
     */
    @JvmName("lcvqajkyjuajpjsl")
    public suspend fun originKeepaliveTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originKeepaliveTimeout = mapped
    }

    /**
     * @param value Origin protocol policy to apply to your origin. One of `http-only`, `https-only`, or `match-viewer`.
     */
    @JvmName("lrlhhudduobkvilo")
    public suspend fun originProtocolPolicy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.originProtocolPolicy = mapped
    }

    /**
     * @param value The Custom Read timeout, in seconds. By default, AWS enforces an upper limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout). Defaults to `30`.
     */
    @JvmName("uocgwfakjnjdncoc")
    public suspend fun originReadTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originReadTimeout = mapped
    }

    /**
     * @param value SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS. A list of one or more of `SSLv3`, `TLSv1`, `TLSv1.1`, and `TLSv1.2`.
     */
    @JvmName("iwjfbrfyvwhorcba")
    public suspend fun originSslProtocols(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.originSslProtocols = mapped
    }

    /**
     * @param values SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS. A list of one or more of `SSLv3`, `TLSv1`, `TLSv1.1`, and `TLSv1.2`.
     */
    @JvmName("hpbxonjhcthsfoxm")
    public suspend fun originSslProtocols(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.originSslProtocols = mapped
    }

    internal fun build(): DistributionOriginCustomOriginConfigArgs =
        DistributionOriginCustomOriginConfigArgs(
            httpPort = httpPort ?: throw PulumiNullFieldException("httpPort"),
            httpsPort = httpsPort ?: throw PulumiNullFieldException("httpsPort"),
            originKeepaliveTimeout = originKeepaliveTimeout,
            originProtocolPolicy = originProtocolPolicy ?: throw
                PulumiNullFieldException("originProtocolPolicy"),
            originReadTimeout = originReadTimeout,
            originSslProtocols = originSslProtocols ?: throw PulumiNullFieldException("originSslProtocols"),
        )
}
