@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupFailoverCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property statusCodes List of HTTP status codes for the origin group.
 */
public data class DistributionOriginGroupFailoverCriteriaArgs(
    public val statusCodes: Output<List<Int>>,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupFailoverCriteriaArgs> {
    override fun toJava():
        com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupFailoverCriteriaArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupFailoverCriteriaArgs.builder()
            .statusCodes(statusCodes.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DistributionOriginGroupFailoverCriteriaArgs].
 */
@PulumiTagMarker
public class DistributionOriginGroupFailoverCriteriaArgsBuilder internal constructor() {
    private var statusCodes: Output<List<Int>>? = null

    /**
     * @param value List of HTTP status codes for the origin group.
     */
    @JvmName("mnikskmbvxkivqaa")
    public suspend fun statusCodes(`value`: Output<List<Int>>) {
        this.statusCodes = value
    }

    @JvmName("gpjepxsmaicxcunr")
    public suspend fun statusCodes(vararg values: Output<Int>) {
        this.statusCodes = Output.all(values.asList())
    }

    /**
     * @param values List of HTTP status codes for the origin group.
     */
    @JvmName("vdotyaomdhvvohcm")
    public suspend fun statusCodes(values: List<Output<Int>>) {
        this.statusCodes = Output.all(values)
    }

    /**
     * @param value List of HTTP status codes for the origin group.
     */
    @JvmName("psksomgjkjkrggpw")
    public suspend fun statusCodes(`value`: List<Int>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusCodes = mapped
    }

    /**
     * @param values List of HTTP status codes for the origin group.
     */
    @JvmName("bscqhnuugoclykac")
    public suspend fun statusCodes(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusCodes = mapped
    }

    internal fun build(): DistributionOriginGroupFailoverCriteriaArgs =
        DistributionOriginGroupFailoverCriteriaArgs(
            statusCodes = statusCodes ?: throw PulumiNullFieldException("statusCodes"),
        )
}
