@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionOriginOriginShieldArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether Origin Shield is enabled.
 * @property originShieldRegion AWS Region for Origin Shield. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as `us-east-2`.
 */
public data class DistributionOriginOriginShieldArgs(
    public val enabled: Output<Boolean>,
    public val originShieldRegion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionOriginOriginShieldArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionOriginOriginShieldArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionOriginOriginShieldArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .originShieldRegion(originShieldRegion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionOriginOriginShieldArgs].
 */
@PulumiTagMarker
public class DistributionOriginOriginShieldArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var originShieldRegion: Output<String>? = null

    /**
     * @param value Whether Origin Shield is enabled.
     */
    @JvmName("qpgrimfreqafisrj")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value AWS Region for Origin Shield. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as `us-east-2`.
     */
    @JvmName("ysjafhjuchqqtqtw")
    public suspend fun originShieldRegion(`value`: Output<String>) {
        this.originShieldRegion = value
    }

    /**
     * @param value Whether Origin Shield is enabled.
     */
    @JvmName("jhoqeypnqwmvqijf")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value AWS Region for Origin Shield. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as `us-east-2`.
     */
    @JvmName("hukvbxqsqledbccq")
    public suspend fun originShieldRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originShieldRegion = mapped
    }

    internal fun build(): DistributionOriginOriginShieldArgs = DistributionOriginOriginShieldArgs(
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        originShieldRegion = originShieldRegion,
    )
}
